/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.util.SDebug;
import cerent.util.UObservable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observer;

public abstract class CmsObservable
extends UObservable {
    private static final SDebug db = new SDebug("CmsObservable");

    protected void handleException(Exception exception, Observer observer, Object object) {
        if (exception instanceof AbstractCmsIOException) {
            if (db.on()) {
                db.println("CmsIOException in CmsObservable.notifyObservers");
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            super.handleException(exception, (Object)observer, object);
        }
    }

    public static void listObservers(Object object, Collection collection) {
        if (db.on() && collection.size() > 0) {
            db.println(" *** On destroy, observers found for " + CmsObservable.getParsedName(object.getClass()) + ": " + collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                db.println(e + " (class=" + CmsObservable.getParsedName(e.getClass()) + ")");
            }
        }
    }

    public void destroy() {
        CmsObservable.listObservers((Object)this, this.getObservers());
    }

    private static String getParsedName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }
}

