/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DataComm;
import cerent.cms.model.DatabaseHeader;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SwUpgradeModel;
import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.DownloadState;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.job.IJobProgressControl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.GZIPInputStream;

public class DataTransfer
implements Observer {
    private String hostName;
    private String userName;
    private String session;
    private String password;
    private String fileName;
    private IJobProgressControl observer;
    private CtcHttpRetriever retriever;
    private DownloadState state;
    private int operation;
    private String operationName;
    private int error;
    private String errorMsg;
    private boolean is600SwUpgrade;
    private String dbTypes;
    private SwUpgradeModel swUpgradeModel;
    private NodeModelDelegate nodeModel;
    private TDMTerminology terms;
    private static final SDebug db = new SDebug("DataTransfer");

    public DataTransfer(NodeModelDelegate nodeModelDelegate, String string, int n, IJobProgressControl iJobProgressControl) {
        this.fileName = string;
        this.operation = n;
        this.observer = iJobProgressControl;
        this.hostName = nodeModelDelegate.getHostName();
        this.userName = nodeModelDelegate.getUserName();
        this.password = nodeModelDelegate.getUserPassword();
        this.terms = nodeModelDelegate.getTDMTerminology();
        this.session = DataComm.getSession(nodeModelDelegate);
        this.retriever = null;
        this.state = null;
        this.error = 200;
        this.errorMsg = null;
        this.dbTypes = "";
        this.nodeModel = nodeModelDelegate;
        if (n == 3) {
            this.operationName = "downloading";
        } else {
            this.operationName = "Database Restore";
            this.dbTypes = nodeModelDelegate.getDbTypes();
        }
        this.is600SwUpgrade = false;
    }

    public void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block34: {
            Serializable serializable2222;
            InputStream inputStream;
            boolean bl;
            block31: {
                bl = false;
                inputStream = null;
                URL uRL = null;
                long l = 0L;
                switch (this.operation) {
                    case 2: {
                        try {
                            uRL = new URL("http://" + this.hostName + "/database/");
                            bl = DatabaseHeader.fileWithHeader(this.fileName);
                            if (bl) {
                                this.fileName = DatabaseHeader.stripHeader(this.fileName);
                            }
                            if (!this.nodeModel.getPlatform().is600()) {
                                l = DataComm.findGZIPRealLength(this.fileName);
                                inputStream = new GZIPInputStream(new FileInputStream(this.fileName));
                                break;
                            }
                            File file = new File(this.fileName);
                            l = file.length();
                            inputStream = new FileInputStream(file);
                            break;
                        }
                        catch (IOException iOException) {
                            throw new AnnotatedException("The selected file may be corrupted\nor it's not a correct file type.", (Exception)iOException);
                        }
                    }
                    case 7: {
                        try {
                            uRL = new URL("http://" + this.hostName + "/configureNode/");
                            File file = new File(this.fileName);
                            l = file.length();
                            inputStream = new FileInputStream(file);
                            break;
                        }
                        catch (IOException iOException) {
                            throw new AnnotatedException("The selected file may be corrupted\nor it's not a correct file type.", (Exception)iOException);
                        }
                    }
                    case 3: {
                        uRL = new URL("http://" + this.hostName + "/software/");
                        File file = new File(this.fileName);
                        l = file.length();
                        inputStream = new FileInputStream(file);
                        break;
                    }
                    default: {
                        throw new Exception("Unexpected request for Data Transfer Operation " + this.operation);
                    }
                }
                this.state = new DownloadState(this.operationName);
                this.state.addObserver((Observer)this);
                if (this.operation == 3 && this.nodeModel.getPlatform().is600()) {
                    this.is600SwUpgrade = true;
                    this.swUpgradeModel = SwUpgradeModel.getInstance(this.nodeModel);
                    if (!this.swUpgradeModel.isInited()) {
                        this.swUpgradeModel.init();
                        db.severe("SwUpgradeModel should be always be inited at this point. Somethins broken");
                    }
                    this.swUpgradeModel.setJobProgressContol(this.observer);
                }
                this.retriever = new CtcHttpRetriever();
                this.error = this.retriever.transferContent(uRL, this.session + this.dbTypes + this.userName + ":" + this.password, inputStream, l, this.state);
                this.errorMsg = DataComm.getErrorMsg(this.error, this.operationName, this.nodeModel.getPlatform().getControlCardName(), this.terms);
                if (!db.on()) break block31;
                db.println("Returning from DataTransfer.run() with value " + this.error);
            }
            Object var8_11 = null;
            try {
                if (bl && this.operation == 2) {
                    serializable2222 = new File(this.fileName);
                    ((File)serializable2222).delete();
                }
            }
            catch (Exception serializable2222) {
                SDebug.printStackTrace((Throwable)serializable2222);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException serializable2222) {
                    // empty catch block
                }
            }
            this.dispose();
            {
                break block34;
                catch (Exception exception) {
                    Serializable serializable32222;
                    db.println("Caught exception in DataTransfer.run()");
                    SDebug.printStackTrace((Throwable)exception);
                    this.error = -1;
                    this.errorMsg = exception.getMessage();
                    Object var8_12 = null;
                    try {
                        if (bl && this.operation == 2) {
                            serializable32222 = new File(this.fileName);
                            ((File)serializable32222).delete();
                        }
                    }
                    catch (Exception serializable32222) {
                        SDebug.printStackTrace((Throwable)serializable32222);
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException serializable32222) {
                            // empty catch block
                        }
                    }
                    this.dispose();
                }
            }
            catch (Throwable throwable) {
                Serializable serializable42222;
                Object var8_13 = null;
                try {
                    if (bl && this.operation == 2) {
                        serializable42222 = new File(this.fileName);
                        ((File)serializable42222).delete();
                    }
                }
                catch (Exception serializable42222) {
                    SDebug.printStackTrace((Throwable)serializable42222);
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException serializable42222) {
                        // empty catch block
                    }
                }
                this.dispose();
                throw throwable;
            }
        }
    }

    public boolean aborted() {
        return this.retriever == null ? false : this.retriever.aborted();
    }

    public void abort() {
        if (this.retriever != null) {
            this.retriever.abort();
        }
    }

    public boolean failed() {
        return this.error != 200;
    }

    public void dispose() {
        if (this.state != null) {
            this.state.deleteObserver((Observer)this);
        }
        if (this.swUpgradeModel != null) {
            this.swUpgradeModel.setJobProgressContol(null);
        }
    }

    public void update(Observable observable, Object object) {
        if (!this.is600SwUpgrade) {
            if (object instanceof String) {
                if (this.observer != null) {
                    this.observer.setProgressText(this.state.sourceName() + " " + this.nodeModel.getPlatform().getControlCardName());
                    this.observer.setPercentCompleted(0);
                }
            } else if (this.observer != null) {
                this.observer.setPercentCompleted(this.state.getPercent());
            }
        }
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }
}

