/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eTrafficDirection;
import cerent.cms.idl.Ds123Media.xBusy;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xSyncProvBusy;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class Ds1LineModel
extends Ds123LineModel {
    public Ds1LineModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate, n);
    }

    public Ds1LineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2);
    }

    public List getConnectionsList() {
        PoolModel poolModel;
        ModuleModel moduleModel;
        IPortModel iPortModel;
        block10: {
            iPortModel = null;
            moduleModel = null;
            poolModel = null;
            try {
                iPortModel = this.getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block10;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (iPortModel != null) {
            moduleModel = (ModuleModel)iPortModel.getModuleModel();
        }
        if (moduleModel != null) {
            if (moduleModel.isComboModule()) {
                Iterator iterator;
                int n = 0;
                List list = moduleModel.getDescendantsOfType(eEqType.DS1_VT_MAPPED);
                if (list != null && (iterator = list.iterator()).hasNext()) {
                    n = ((PortModel)iterator.next()).getIndex();
                    while (iterator.hasNext()) {
                        int n2 = ((PortModel)iterator.next()).getIndex();
                        if (ComparisonUtil.compare(n2, n) >= 0) continue;
                        n = n2;
                    }
                }
                int n3 = iPortModel.getIndex();
                n += 28 * ((n3 - n) / 28);
                poolModel = (PoolModel)this.getNodeModelDelegate().getPoolModels().getPoolModel(n);
            } else {
                int n = moduleModel.getEntityIndex();
                poolModel = (PoolModel)this.getNodeModelDelegate().getPoolModels().getPoolModel(n);
            }
        }
        if (poolModel != null) {
            List list = poolModel.getConnectionsList(iPortModel);
            if (this.db.on()) {
                this.db.println("DS1 ConnectionsList: " + list.size() + "(size), " + list);
            }
            return list;
        }
        return new LinkedList();
    }

    public void clearStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, eTrafficDirection.DIR_TXRX};
            this.stats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            this.db.println("Caught UserException in DS1LineModel.clearStats...");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public sLineSyncConfig getSyncConfig() throws NoSuchInterface, UnsupportedOperation {
        sLineSyncConfig sLineSyncConfig2 = null;
        try {
            sLineSyncConfig2 = (sLineSyncConfig)this.getSyncConfigCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSyncConfig", userException);
        }
        return sLineSyncConfig2;
    }

    public void setSyncConfig(sLineSyncConfig sLineSyncConfig2) throws NoSuchInterface, UnsupportedOperation, ConfigError, SyncProvError {
        try {
            this.getSyncConfigCV().set(sLineSyncConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvError("Can not change configuration. The port is used as the system clock source by manual/force switch.");
        }
        catch (UserException userException) {
            throw this.doUnknown("setSyncConfig", userException);
        }
    }

    public boolean getDs1RetimingEnabled() throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.getDs1RetimingEnabledCV().get();
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDs1RetimingEnabled", userException);
        }
    }

    public void setDs1RetimingEnabled(boolean bl) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, Busy {
        try {
            this.getDs1RetimingEnabledCV().set(new Boolean(bl));
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xBusy xBusy2) {
            throw new Busy(ErrorMsg.getString((EID)EMC.EID_FAIL_RETIMING_PORT_BUSY));
        }
        catch (UserException userException) {
            throw this.doUnknown("setDs1RetimingEnabled", userException);
        }
    }
}

