/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eReversionMode;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Equipment.EntityTable;
import cerent.cms.idl.Equipment.IModule;
import cerent.cms.idl.Equipment.ProtectionGroup;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.Equipment.sEntity;
import cerent.cms.idl.Equipment.sEntityListElem;
import cerent.cms.idl.Equipment.sProtGroupListElem;
import cerent.cms.idl.Equipment.sProtectionConfig;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xProvisionError;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DeprecatedMethodCalled;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ElementModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.Feature;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.IVcatTermAttributes;
import cerent.cms.model.IVcatTermModels;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.ElementComparator;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.UserException;

public class EntityTableModel
extends Model
implements IEntityTableModel {
    private NodeModelDelegate nmd;
    private EntityModel chassis = null;
    private TreeMap entityModelTable = new TreeMap();
    private LastChange lastChange;
    private ProtectionGroupList protectionGroupList;
    private ProvisionProtectionGroup provisionProtectionGroup;
    private ProvisionModule provisionModule;
    private ProvisionPluggable provisionPluggable;
    private ProvisionPort provisionPort;
    private UnprovisionPort unprovisionPort;
    private EntityList entityList;
    private TestAllLeds testAllLeds;
    private static ModelSingletonCollection entityTableModelSingletons;
    private EventDispatcher dispatcher;
    private GetPortTypeList getPortTypeList;
    static /* synthetic */ Class class$cerent$cms$model$EntityTableModel;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEqType;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eClass;
    static /* synthetic */ Class class$cerent$cms$model$InterfaceModel;
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;

    private EntityTable getEntityTableRef() {
        return this.nmd.getIorRepository().getEntityTableRef();
    }

    public static synchronized EntityTableModel getInstance(NodeModelDelegate nodeModelDelegate) {
        EntityTableModel entityTableModel;
        if (entityTableModelSingletons == null) {
            entityTableModelSingletons = ModelSingletonCollection.getMSCInstanceByName("EntityTableModel");
        }
        if ((entityTableModel = (EntityTableModel)entityTableModelSingletons.get(nodeModelDelegate)) == null) {
            entityTableModel = new EntityTableModel(nodeModelDelegate);
            entityTableModelSingletons.add(nodeModelDelegate, entityTableModel);
        }
        return entityTableModel;
    }

    protected EntityTableModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$EntityTableModel == null ? (class$cerent$cms$model$EntityTableModel = EntityTableModel.class$("cerent.cms.model.EntityTableModel")) : class$cerent$cms$model$EntityTableModel));
        this.nmd = nodeModelDelegate;
        this.lastChange = new LastChange(this.nmd, "EntityTableModel.lastChange");
        this.protectionGroupList = new ProtectionGroupList(this.nmd, "EntityTableModel.protectionGroupList");
        this.provisionProtectionGroup = new ProvisionProtectionGroup(this.nmd, "EntityTableModel.provisionProtectionGroup");
        this.provisionModule = new ProvisionModule(this.nmd, "EntityTableModel.provisionModule");
        this.provisionPluggable = new ProvisionPluggable(this.nmd, "EntityTableModel.provisionPluggable");
        this.provisionPort = new ProvisionPort(nodeModelDelegate, "EntityTableModel.provisionPort");
        this.unprovisionPort = new UnprovisionPort(nodeModelDelegate, "EntityTableModel.unprovisionPort");
        this.getPortTypeList = new GetPortTypeList(nodeModelDelegate, "EntityTableModel.getPortTypeList");
        this.entityList = new EntityList(this.nmd, "EntityTableModel.entityList");
        this.testAllLeds = new TestAllLeds(this.nmd, "EntityTableModel.testAllLeds");
        this.index = 0;
        this.dispatcher = null;
    }

    private EntityTableModel() {
        super(new SDebug("EntityTableModel"));
        this.index = 0;
        this.dispatcher = null;
    }

    public void init() throws IllegalStateException {
        this.db.addCommand(this, "dump", "Dump entity table as a tree");
        this.db.addCommand(this, "printTable", "Print entity table (with indices)");
        super.init0();
        this.discoverEntityTable();
        this.initEntities();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectEntityTable, 0, (Observer)this);
        }
    }

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EntityModel entityModel;
        TreeMap treeMap;
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectEntityTable, 0, (Observer)this);
        }
        if (this.db.on()) {
            this.db.println("dispose() entry");
        }
        Object object = this;
        synchronized (object) {
            treeMap = this.entityModelTable;
            this.entityModelTable = new TreeMap();
            this.chassis = null;
        }
        if (treeMap != null && (object = treeMap.values().iterator()).hasNext() && (entityModel = (EntityModel)object.next()) != null) {
            entityModel.destroy();
        }
        treeMap = null;
        this.db.removeCommand(this, "dump");
        this.db.removeCommand(this, "printTable");
        super.dispose();
        if (this.db.on()) {
            this.db.println("dispose() exit");
        }
    }

    private String toString(eEqType eEqType2) {
        return EnumStrings.getStrings((Class)(class$cerent$cms$idl$Equipment$eEqType == null ? (class$cerent$cms$idl$Equipment$eEqType = EntityTableModel.class$("cerent.cms.idl.Equipment.eEqType")) : class$cerent$cms$idl$Equipment$eEqType))[eEqType2.value()];
    }

    private String toString(eClass eClass2) {
        return EnumStrings.getStrings((Class)(class$cerent$cms$idl$Equipment$eClass == null ? (class$cerent$cms$idl$Equipment$eClass = EntityTableModel.class$("cerent.cms.idl.Equipment.eClass")) : class$cerent$cms$idl$Equipment$eClass))[eClass2.value()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discoverEntityTable() throws IllegalStateException {
        try {
            EntityModel entityModel;
            sEntity sEntity2;
            sEntityListElem sEntityListElem2;
            int n;
            if (this.db.on()) {
                this.db.println("discoverEntityTable():entry");
            }
            sEntityListElem[] sEntityListElemArray = this.getEntityArray();
            TreeMap<Integer, EntityModel> treeMap = new TreeMap<Integer, EntityModel>();
            EntityModel entityModel2 = null;
            if (this.db.on()) {
                this.db.println("Phase 2a: Build Entity Model and  TreeMap");
            }
            for (n = 0; n < sEntityListElemArray.length; ++n) {
                sEntityListElem2 = sEntityListElemArray[n];
                sEntity2 = sEntityListElem2.entityData;
                entityModel = this.nmd.getEntityModelFactory().makeEntityModel(sEntityListElem2.ent, sEntity2.index, sEntity2.eqType, sEntity2.genericClass, sEntity2.posInParent);
                treeMap.put(new Integer(sEntity2.index), entityModel);
            }
            if (this.db.on()) {
                this.db.println("Step 2b: Build Entity Model parent/child tree");
            }
            for (n = 0; n < sEntityListElemArray.length; ++n) {
                sEntityListElem2 = sEntityListElemArray[n];
                sEntity2 = sEntityListElem2.entityData;
                entityModel = (EntityModel)treeMap.get(new Integer(sEntity2.index));
                int n2 = sEntity2.parent;
                if (0 == n2) {
                    entityModel2 = entityModel;
                    continue;
                }
                EntityModel entityModel3 = (EntityModel)treeMap.get(new Integer(n2));
                if (entityModel3 == null) {
                    String string = "id=" + Integer.toHexString(sEntity2.index) + "/spcType=" + this.toString(sEntity2.eqType) + "/genType=" + this.toString(sEntity2.genericClass) + "/parent=" + Integer.toHexString(sEntity2.parent);
                    if (this.db.on()) {
                        this.db.println("parent not found: " + string);
                    }
                    throw new IllegalStateException("EntityTable contains an entry with a non-existent parent(" + string + ")");
                }
                entityModel3.add(entityModel);
            }
            EntityTableModel entityTableModel = this;
            synchronized (entityTableModel) {
                this.chassis = entityModel2;
                this.entityModelTable = treeMap;
            }
            if (this.db.on()) {
                this.db.println("discoverEntityTable(): exit");
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.dispose();
            throw abstractCmsIOException;
        }
    }

    protected void addAllModels(IEntityModel iEntityModel) {
        this.entityModelTable.put(new Integer(iEntityModel.getIndex()), iEntityModel);
        List list = iEntityModel.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            this.addAllModels(iEntityModel2);
        }
    }

    public void removeModel(IEntityModel iEntityModel) {
        if (iEntityModel != null) {
            this.entityModelTable.remove(new Integer(iEntityModel.getIndex()));
        }
    }

    public synchronized List getEntityModelTable() {
        return new ArrayList(this.entityModelTable.values());
    }

    public synchronized List getModuleEntities() {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass2 = entityModel.genericClass;
            if (this.db.on()) {
                this.db.println(entityModel.toString());
            }
            if (eClass2 == eClass.PORT || eClass2 == eClass.E_SENSOR || eClass2 == eClass.SENSOR_OUTPUT) continue;
            arrayList.add(entityModel);
        }
        return arrayList;
    }

    public synchronized List getPortEntities() {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass2 = entityModel.genericClass;
            if (eClass2 != eClass.PORT && eClass2 != eClass.E_SENSOR && eClass2 != eClass.SENSOR_OUTPUT) continue;
            arrayList.add(entityModel);
        }
        return arrayList;
    }

    public synchronized List getEntityModelsByClass(eClass eClass2) {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass3 = entityModel.genericClass;
            if (eClass3 != eClass2) continue;
            arrayList.add(entityModel);
        }
        return arrayList;
    }

    public synchronized List filterEntitiesByClass(eClass[] eClassArray) {
        ArrayList<EntityModel> arrayList = new ArrayList<EntityModel>();
        int n = eClassArray.length;
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass2 = entityModel.genericClass;
            for (int i = 0; i < n; ++i) {
                if (eClass2 != eClassArray[i]) continue;
                arrayList.add(entityModel);
            }
        }
        return arrayList;
    }

    public void initEntities() {
        if (this.chassis == null) {
            throw new CmsObjectNotExistException("chassis reference is null");
        }
        this.chassis.initAll();
    }

    private long getLastChange() {
        try {
            return (Long)this.lastChange.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getlastChange", userException);
        }
    }

    public sProtGroupListElem[] getProtectionGroupList() {
        try {
            return (sProtGroupListElem[])this.protectionGroupList.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getProtectionGroupList", userException);
        }
    }

    public Integer[] getElementIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Iterator iterator = this.entityModelTable.values().iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            eClass eClass2 = entityModel.genericClass;
            if (eClass2 != eClass.PORT && eClass2 != eClass.E_MODULE) continue;
            arrayList.add(new Integer(entityModel.getEntityIndex()));
        }
        return arrayList.toArray(new Integer[0]);
    }

    public IEntityModel getEntityModelByIndex(int n) throws AbstractCmsNoSuchEntityException {
        IEntityModel iEntityModel = null;
        iEntityModel = (IEntityModel)this.entityModelTable.get(new Integer(n));
        if (iEntityModel == null) {
            throw new CmsNoSuchEntityException("Entity Model does not exist for index = 0x" + Integer.toHexString(n) + ".\nThis is a normal result of some race conditions.");
        }
        return iEntityModel;
    }

    public IEntityModel getEntityModelBySlot(int n) {
        EntityModel entityModel = (EntityModel)this.getChassis().getChildren().get(0);
        Iterator iterator = entityModel.getChildrenOfType(eClass.CONTAINER).iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel2 = (EntityModel)iterator.next();
            if (entityModel2.getPositionInParent() != n) continue;
            return entityModel2;
        }
        return null;
    }

    public int removePersistentStateInEmptySlots() {
        EntityModel entityModel = (EntityModel)this.getChassis().getChildren().get(0);
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getNodeModel();
        IModelPersistenceStrategy iModelPersistenceStrategy = nodeModelDelegate.getModelPersistenceStrategy(class$cerent$cms$model$InterfaceModel == null ? (class$cerent$cms$model$InterfaceModel = EntityTableModel.class$("cerent.cms.model.InterfaceModel")) : class$cerent$cms$model$InterfaceModel);
        int n = 0;
        if (!iModelPersistenceStrategy.doesGetReallyPersisted(null)) {
            return n;
        }
        Iterator iterator = entityModel.getChildrenOfType(eClass.CONTAINER).iterator();
        int n2 = nodeModelDelegate.getPersistenceId();
        while (iterator.hasNext()) {
            EntityModel entityModel2 = (EntityModel)iterator.next();
            List list = entityModel2 == null ? null : entityModel2.getChildren();
            IEntityModel iEntityModel = list == null || list.size() == 0 ? null : list.get(0);
            if (entityModel2 == null || iEntityModel != null) continue;
            short s = (short)entityModel2.getPositionInParent();
            ModuleModel.deleteIfPersistedState(this.db, iModelPersistenceStrategy, n2, s);
            ++n;
        }
        return n;
    }

    public boolean hasCardNamed(String string) {
        EntityModel entityModel = (EntityModel)this.getChassis().getChildren().get(0);
        Iterator iterator = entityModel.getChildrenOfType(eClass.CONTAINER).iterator();
        while (iterator.hasNext()) {
            ModuleModel moduleModel;
            EntityModel entityModel2 = (EntityModel)iterator.next();
            List list = entityModel2.getChildren();
            if (list.size() <= 0 || !(list.get(0) instanceof ModuleModel) || !(moduleModel = (ModuleModel)list.get(0)).isCardNamed(string)) continue;
            return true;
        }
        return false;
    }

    public IEntityModel getChassis() {
        return this.chassis;
    }

    public void provisionProtectionGroupModel(String string, eProtectionType eProtectionType2, eReversionMode eReversionMode2, int n, IModuleModel iModuleModel, IModuleModel[] iModuleModelArray) throws ProvisionError, ResourceInUse {
        try {
            if (this.db.on()) {
                this.db.println("provisionProtectionGroupModel(): entry");
            }
            sProtectionConfig sProtectionConfig2 = new sProtectionConfig();
            sProtectionConfig2.name = string;
            sProtectionConfig2.protectType = eProtectionType2;
            sProtectionConfig2.reversion = new sRevertiveBehavior(eReversionMode2, n);
            ModuleModel moduleModel = (ModuleModel)iModuleModel;
            sProtectionConfig2.protectModule = moduleModel.getIModuleRef();
            sProtectionConfig2.mainModules = new IModule[iModuleModelArray.length];
            for (int i = 0; i < iModuleModelArray.length; ++i) {
                ModuleModel moduleModel2 = (ModuleModel)iModuleModelArray[i];
                sProtectionConfig2.mainModules[i] = moduleModel2.getIModuleRef();
            }
            if (this.db.on()) {
                this.db.println("Before calling pgRef = provisionProtectionGroup");
            }
            ProtectionGroup protectionGroup = (ProtectionGroup)this.provisionProtectionGroup.get(sProtectionConfig2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionProtectionGroupModel", userException);
        }
    }

    public ProtectionGroupModel[] getProtectionGroupModelArray() {
        if (this.db.on()) {
            this.db.println("getProtectionGroupModelArray(): entry");
        }
        return this.nmd.getProtectionGroupModels().getProtectionGroupModelArray();
    }

    private boolean is454SdhChassis() {
        return this.getChassis().getEqType() == 71;
    }

    public IModuleModel[] getAvailableProtectModules(eProtectionType eProtectionType2) {
        IEntityModel iEntityModel;
        List list = new ArrayList();
        if (this.db.on() && this.db.on()) {
            this.db.println("getAvailableProtectModules(): entry");
        }
        if ((iEntityModel = this.getChassis()) != null) {
            list = ((EntityModel)iEntityModel).getDescendantsOfType(eClass.E_MODULE);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ModuleModel)) {
                iterator.remove();
                continue;
            }
            ModuleModel moduleModel = (ModuleModel)e;
            EntityModel entityModel = moduleModel.getAncestorOfType(eClass.CONTAINER);
            int n = entityModel.getPositionInParent();
            boolean bl = false;
            block0 : switch (eProtectionType2.value()) {
                case 1: {
                    if ((entityModel.getEqType() != 21 || (n & 1) != 1) && ((n & 1) != 0 || moduleModel.getEqType() != 113) || moduleModel.getState() == eEqState.DELETED) {
                        bl = true;
                    } else {
                        switch (moduleModel.getEqType()) {
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 12: 
                            case 13: 
                            case 57: 
                            case 58: 
                            case 64: 
                            case 65: 
                            case 66: 
                            case 67: 
                            case 83: 
                            case 145: {
                                if (n < 7 || n <= 12) break;
                                break;
                            }
                            case 113: {
                                if ((n & 1) == 0 && n > 13) {
                                    bl = true;
                                }
                                if ((n & 1) != 1 || n >= 5) break;
                                bl = true;
                                break;
                            }
                            default: {
                                bl = true;
                            }
                        }
                    }
                    if (bl || n != 5 && n != 13 || !this.is454SdhChassis()) break;
                    bl = true;
                    break;
                }
                case 0: {
                    if (entityModel.getEqType() != 21 || n != 3 && n != 15 && (n != 4 || moduleModel.getEqType() != 113) && (n != 17 || moduleModel.getEqType() != 113) || moduleModel.getState() == eEqState.DELETED) {
                        bl = true;
                        break;
                    }
                    switch (moduleModel.getEqType()) {
                        case 5: 
                        case 7: 
                        case 13: 
                        case 58: 
                        case 64: 
                        case 67: 
                        case 108: 
                        case 109: 
                        case 145: 
                        case 185: {
                            break;
                        }
                        case 113: {
                            if (n == 4 || n == 17) break block0;
                            bl = true;
                            break;
                        }
                        default: {
                            bl = true;
                            break;
                        }
                    }
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl && moduleModel.getProtectionGroupModel() == null) continue;
            iterator.remove();
        }
        if (this.db.on()) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                this.db.println("    " + iterator.next());
            }
            this.db.println("getAvailableProtectModules(): exit");
        }
        return list.toArray(new ModuleModel[0]);
    }

    public List getModuleModelSupportedRegenGroup() {
        List list = ((EntityModel)this.getChassis()).getDescendantsOfType(eClass.E_MODULE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof DwdmModuleModel && ((DwdmModuleModel)e).supportRegenGroup()) continue;
            iterator.remove();
        }
        return list;
    }

    public List getCompatibleModuleModelForRegenGroup(DwdmModuleModel dwdmModuleModel) {
        List list = this.getModuleModelSupportedRegenGroup();
        int n = dwdmModuleModel.getEqType();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DwdmModuleModel dwdmModuleModel2 = (DwdmModuleModel)iterator.next();
            if (dwdmModuleModel2 != dwdmModuleModel && dwdmModuleModel2.getEqType() == n) continue;
            iterator.remove();
        }
        return list;
    }

    public IModuleModel[] getCompatibleMainModules(ModuleModel moduleModel, eProtectionType eProtectionType2) {
        List list = new ArrayList();
        int n = moduleModel.getSlot();
        eEqType eEqType2 = eEqType.from_int(moduleModel.getEqType());
        list = ((EntityModel)this.getChassis()).getDescendantsOfType(eClass.E_MODULE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ModuleModel)) {
                iterator.remove();
                continue;
            }
            ModuleModel moduleModel2 = (ModuleModel)e;
            if (moduleModel2 == moduleModel) {
                iterator.remove();
                continue;
            }
            EntityModel entityModel = moduleModel2.getAncestorOfType(eClass.CONTAINER);
            int n2 = entityModel.getPositionInParent();
            eEqType eEqType3 = eEqType.from_int(moduleModel2.getEqType());
            boolean bl = false;
            switch (eProtectionType2.value()) {
                case 1: {
                    if (entityModel.getEqType() != 21 || (n2 >= 9 || n2 != n + 1) && (n2 <= 9 || n2 != n - 1) && eEqType2.value() != 113 || moduleModel2.getState() == eEqState.DELETED) {
                        bl = true;
                    } else if (eEqType2 != eEqType3) {
                        switch (eEqType2.value()) {
                            case 64: 
                            case 83: {
                                bl = eEqType3 != eEqType.E1_LINE_CARD && eEqType3 != eEqType.E1N_LINE_CARD;
                                break;
                            }
                            case 108: 
                            case 109: {
                                bl = eEqType3 != eEqType.E1_42_LINE_CARD && eEqType3 != eEqType.E1N_42_LINE_CARD;
                                break;
                            }
                            case 66: 
                            case 67: {
                                bl = eEqType3 != eEqType.DS3I_LINE_CARD && eEqType3 != eEqType.DS3IN_LINE_CARD;
                                break;
                            }
                            case 4: {
                                bl = eEqType3 != eEqType.DS1N_LINE_CARD;
                                break;
                            }
                            case 5: {
                                bl = eEqType3 != eEqType.DS1_LINE_CARD;
                                break;
                            }
                            case 6: {
                                bl = eEqType3 != eEqType.DS3N_LINE_CARD;
                                break;
                            }
                            case 7: {
                                bl = eEqType3 != eEqType.DS3_LINE_CARD;
                                break;
                            }
                            case 57: {
                                bl = eEqType3 != eEqType.DS3NE_LINE_CARD && eEqType3 != eEqType.DS3N_LINE_CARD && eEqType3 != eEqType.DS3_LINE_CARD;
                                break;
                            }
                            case 58: {
                                bl = eEqType3 != eEqType.DS3E_LINE_CARD && eEqType3 != eEqType.DS3N_LINE_CARD && eEqType3 != eEqType.DS3_LINE_CARD;
                                break;
                            }
                            case 12: {
                                bl = eEqType3 != eEqType.EC1N_LINE_CARD;
                                break;
                            }
                            case 13: {
                                bl = eEqType3 != eEqType.EC1_LINE_CARD;
                                break;
                            }
                            case 145: {
                                bl = eEqType3 != eEqType.DS3XM_LINE_CARD && eEqType3 != eEqType.DS3XM12_LINE_CARD;
                                break;
                            }
                            default: {
                                bl = true;
                                break;
                            }
                        }
                    } else if (eEqType2.value() == 113) {
                        boolean bl2 = bl = n2 != n - 1;
                    }
                    if (bl || n2 != 6 && n2 != 12 || !this.is454SdhChassis()) break;
                    bl = true;
                    break;
                }
                case 0: {
                    if (eEqType2.value() == 145 && eEqType2 == eEqType3) {
                        bl = n != 3 && n != 15 || (n2 <= 0 || n2 >= 7) && (n2 <= 11 || n2 >= 18) || moduleModel2.getState() == eEqState.DELETED;
                    } else if (!(entityModel.getEqType() == 21 && (n == 3 && n2 > 0 && n2 < 7 || n == 15 && n2 > 11 && n2 < 18 || n == 4 && n2 > 0 && n2 < 4 || n == 17 && n2 > 12 && n2 < 17) && moduleModel2.getState() != eEqState.DELETED)) {
                        bl = true;
                    } else if (eEqType2 != eEqType3) {
                        switch (eEqType2.value()) {
                            case 64: {
                                bl = eEqType3 != eEqType.E1_LINE_CARD && eEqType3 != eEqType.E1N_LINE_CARD;
                                break;
                            }
                            case 108: 
                            case 109: {
                                bl = eEqType3 != eEqType.E1_42_LINE_CARD && eEqType3 != eEqType.E1N_42_LINE_CARD;
                                break;
                            }
                            case 66: 
                            case 67: {
                                bl = eEqType3 != eEqType.DS3I_LINE_CARD && eEqType3 != eEqType.DS3IN_LINE_CARD;
                                break;
                            }
                            case 5: {
                                bl = eEqType3 != eEqType.DS1_LINE_CARD;
                                break;
                            }
                            case 7: {
                                bl = eEqType3 != eEqType.DS3_LINE_CARD;
                                break;
                            }
                            case 58: {
                                bl = eEqType3 != eEqType.DS3E_LINE_CARD && eEqType3 != eEqType.DS3_LINE_CARD;
                                break;
                            }
                            case 13: {
                                bl = eEqType3 != eEqType.EC1_LINE_CARD;
                                break;
                            }
                            case 185: {
                                bl = eEqType3 != eEqType.DS3E_LINE_CARD && eEqType3 != eEqType.DS3NE_LINE_CARD && eEqType3 != eEqType.DS3_LINE_CARD && eEqType3 != eEqType.DS3N_LINE_CARD;
                                break;
                            }
                            case 113: {
                                bl = eEqType3 != eEqType.STM1E_12_LINE_CARD;
                                break;
                            }
                            case 145: {
                                bl = eEqType3 != eEqType.DS3XM_LINE_CARD;
                                break;
                            }
                            default: {
                                bl = true;
                            }
                        }
                    }
                    if (bl || n2 != 6 && n2 != 12 || !this.is454SdhChassis()) break;
                    bl = true;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (!bl && moduleModel2.getProtectionGroupModel() == null) continue;
            iterator.remove();
        }
        return list.toArray(new ModuleModel[0]);
    }

    public IModule provisionModule(int n, eEqType eEqType2) throws xProvisionError, xInUse {
        try {
            Object[] objectArray = new Object[]{new Integer(n), eEqType2};
            return (IModule)this.provisionModule.get(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw xProvisionError2;
        }
        catch (xInUse xInUse2) {
            throw xInUse2;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionModule", userException);
        }
    }

    public boolean provisionPluggable(PluggableSlotModel pluggableSlotModel, eEqType eEqType2) throws ProvisionError, ResourceInUse {
        try {
            this.provisionPluggable.get(new Object[]{new Integer(pluggableSlotModel.getEntityIndex()), eEqType2});
            return true;
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionPluggable", userException);
        }
    }

    public boolean provisionPort(IPortContainer iPortContainer, int n, eEqType eEqType2) throws ProvisionError, ResourceInUse {
        try {
            Object[] objectArray = new Object[]{new Integer(iPortContainer.getEntityIndex()), new Integer(n), eEqType2};
            return (Boolean)this.provisionPort.get(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw ElementDefaults.getProvisionError(xProvisionError2, this.getNodeModel().getTDMTerminology());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "provisionPort", userException);
        }
    }

    public boolean unprovisionPort(PortModel portModel) throws ProvisionError, ResourceInUse {
        int n = portModel.getEntityIndex();
        try {
            return (Boolean)this.unprovisionPort.get(new Integer(n));
        }
        catch (xProvisionError xProvisionError2) {
            throw ElementDefaults.getProvisionError(xProvisionError2, this.getNodeModel().getTDMTerminology());
        }
        catch (xInUse xInUse2) {
            throw new ResourceInUse((UserException)xInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "unprovisionPort", userException);
        }
    }

    public eEqType[] getPortTypeList(int n, int n2) {
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
            return (eEqType[])this.getPortTypeList.get(objectArray);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void doLampTest() throws BAD_OPERATION {
        try {
            this.testAllLeds.set();
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            throw bAD_OPERATION;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "doLampTest", userException);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + this + ", From=" + observable + ", arg=" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = EntityTableModel.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType))[n]);
            }
            switch (n) {
                case 0: {
                    if (!this.db.on()) break;
                    this.db.println("update(): this DELETED, noop for EntityTableModel");
                    break;
                }
                case 1: {
                    if (!this.db.on()) break;
                    this.db.println("update(): this CHANGED, noop for EntityTableModel");
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println("update(): this STRUCTURE CHANGED, noop for EntityTableModel");
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.println("update(): ILLEGAL UpdateType");
                }
            }
        }
    }

    private sEntityListElem[] getEntityArray() throws AbstractCmsIOException {
        sEntityListElem[] sEntityListElemArray = null;
        int n = 0;
        while (true) {
            try {
                sEntityListElemArray = (sEntityListElem[])this.entityList.get();
            }
            catch (UserException userException) {
                throw NodeModelDelegate.doUnknown(this.db, "getEntityArray", userException);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                if (n > 5) {
                    throw abstractCmsIOException;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
                continue;
            }
            break;
        }
        return sEntityListElemArray;
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    private List getEntityList() {
        try {
            return Arrays.asList((sEntityListElem[])this.entityList.get());
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getEntityList", userException);
        }
    }

    public List getAvailEntitiesForLo(int n, boolean bl) {
        LinkedList linkedList = new LinkedList();
        IEntityModel iEntityModel = this.nmd.getChassis();
        if (iEntityModel == null) {
            if (this.db.on()) {
                this.db.println("unable to find chassis model");
            }
        } else if (!this.nmd.provides(Feature.XCVT)) {
            if (this.db.on()) {
                this.db.println("Node does not support VT XC's");
            }
        } else {
            IConnectionModels iConnectionModels = this.nmd.getConnectionModels();
            IEntityModel[] iEntityModelArray = iConnectionModels.getAvailEntitiesForLoPath(n);
            LinkedList linkedList2 = new LinkedList();
            if (this.db.on()) {
                this.db.println("entities after getAvailEntitiesForLoPath(pathSize=" + n + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
            }
            this.screenAvailEntities(iEntityModelArray, linkedList2, bl);
            if (this.db.on()) {
                this.db.println("screenList: " + linkedList2.size() + "(size), " + linkedList2);
            }
            this.loFilterEntities(linkedList2, linkedList);
            if (this.db.on()) {
                this.db.println("returnList: " + linkedList.size() + "(size), " + linkedList);
            }
        }
        return linkedList;
    }

    public List getAvailEntitiesForVt(int n, boolean bl) {
        throw new DeprecatedMethodCalled("FTG deprecated EntityTableModel.getAvailEntitiesForVt(int pathSize, boolean protectedPortsOnly)");
    }

    public List getAvailEntitiesForHo(short s, int n, boolean bl) {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        IConnectionModels iConnectionModels = this.nmd.getConnectionModels();
        IEntityModel[] iEntityModelArray = iConnectionModels.getAvailEntitiesForHoPath(s);
        if (this.db.on()) {
            this.db.println("entities after getAvailEntitiesForHoPath(pathSize=" + s + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
        }
        this.screenAvailEntities(iEntityModelArray, linkedList2, bl);
        if (this.db.on()) {
            this.db.println("screenList: " + linkedList2.size() + "(size), " + linkedList2);
        }
        this.hoFilterEntities(linkedList2, linkedList, n);
        if (this.db.on()) {
            this.db.println("returnList: " + linkedList.size() + "(size), " + linkedList);
        }
        return linkedList;
    }

    public ITdmPortModel[] getAvailableOnePlusOnePorts(eOnePlusOneType eOnePlusOneType2) {
        TreeSet treeSet = new TreeSet(new ElementComparator());
        treeSet.addAll(this.nmd.getElementModelsDelegate().getOnePlusOneAvailableElements(eOnePlusOneType2));
        LinkedList<TdmPortModel> linkedList = new LinkedList<TdmPortModel>();
        TdmPortModel tdmPortModel = null;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            try {
                tdmPortModel = (TdmPortModel)((ElementModel)iterator.next()).getEntityModel();
                linkedList.add(tdmPortModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("getAvailableOnePlusOnePorts: Entity not found for index=" + tdmPortModel.getIndex());
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            catch (Exception exception) {
                this.db.println(exception + "in getAvailableOnePlusOnePorts for Index=" + tdmPortModel.getIndex());
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        ITdmPortModel[] iTdmPortModelArray = linkedList.toArray(new TdmPortModel[0]);
        if (this.db.on()) {
            this.db.println("getAvailableOnePlusOnePorts: " + iTdmPortModelArray.length);
            for (int i = 0; i < iTdmPortModelArray.length; ++i) {
                this.db.println("#" + i + ":" + iTdmPortModelArray[i]);
            }
        }
        return iTdmPortModelArray;
    }

    public List getAvailEntitiesForSts(short s, int n, boolean bl) {
        throw new DeprecatedMethodCalled("FTG deprecated EntityTableModel.getAvailEntitiesForSts((short pathSize, int circuitDir, boolean protectedPortsOnly)");
    }

    public IDwdmPortModel[] getAvailableYCablePorts() {
        TreeSet treeSet = new TreeSet(new ElementComparator());
        treeSet.addAll(this.nmd.getElementModelsDelegate().getYCableAvailableElements());
        LinkedList<DwdmPortModel> linkedList = new LinkedList<DwdmPortModel>();
        DwdmPortModel dwdmPortModel = null;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            try {
                dwdmPortModel = (DwdmPortModel)((ElementModel)iterator.next()).getEntityModel();
                if (dwdmPortModel.isSonetDccTermination()) continue;
                linkedList.add(dwdmPortModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("getAvailableYCablePorts: Entity not found for index=" + dwdmPortModel.getIndex());
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            catch (Exception exception) {
                this.db.println(exception + "in getAvailableYCablePorts for Index=" + dwdmPortModel.getIndex());
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.db.on()) {
            this.db.println("portsList: " + linkedList.size() + "(size), " + linkedList);
        }
        return linkedList.toArray(new DwdmPortModel[0]);
    }

    public List getFirstAvailPairPPorts(short s) {
        EntityModel entityModel;
        LinkedList<EntityModel> linkedList = new LinkedList<EntityModel>();
        LinkedList linkedList2 = new LinkedList();
        TreeMap<Integer, EntityModel> treeMap = new TreeMap<Integer, EntityModel>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        EntityModel entityModel2 = null;
        EntityModel entityModel3 = null;
        IConnectionModels iConnectionModels = this.nmd.getConnectionModels();
        IEntityModel[] iEntityModelArray = iConnectionModels.getAvailEntitiesForHoPath(s);
        if (this.db.on()) {
            this.db.println("getFirstAvailPairPPorts after getAvailEntitiesForHoPath(pathSize=" + s + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
        }
        this.screenAvailEntities(iEntityModelArray, linkedList2, false);
        if (this.db.on()) {
            this.db.println("getFirstAvailPairPPorts after screen: " + linkedList2.size() + "(size), " + linkedList2);
        }
        for (int i = 0; i < linkedList2.size(); ++i) {
            entityModel = (EntityModel)linkedList2.get(i);
            if (entityModel == null || !entityModel.onPortlessPort()) continue;
            treeMap.put(new Integer(entityModel.getIndex()), entityModel);
        }
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            entityModel = (EntityModel)iterator.next();
            if (entityModel.getPort() % 2 == 1) {
                if (this.db.on()) {
                    this.db.println("find an entity on an odd port " + entityModel.getPort());
                }
                entityModel2 = entityModel;
                continue;
            }
            entityModel3 = entityModel;
            if (entityModel2 == null || entityModel2.getSlot() != entityModel3.getSlot() || !entityModel2.onPairPortlessPorts(entityModel3) || treeSet.contains(new Integer(entityModel2.getSlot()))) continue;
            linkedList.add(entityModel2);
            linkedList.add(entityModel3);
            treeSet.add(new Integer(entityModel2.getSlot()));
        }
        if (this.db.on()) {
            this.db.println("return " + linkedList.size() + " entities");
        }
        return linkedList;
    }

    public void screenAvailEntities(IEntityModel[] iEntityModelArray, List list, boolean bl) {
        for (int i = 0; i < iEntityModelArray.length; ++i) {
            ProtectionGroupModel protectionGroupModel;
            ModuleModel moduleModel;
            EntityModel entityModel = (EntityModel)iEntityModelArray[i];
            if (entityModel == null) continue;
            int n = entityModel.getEqType();
            if (n == 4 || n == 5 || n == 83 || n == 64 || n == 108 || n == 109 || n == 65 || n == 66 || n == 67) {
                moduleModel = (ModuleModel)entityModel;
                if (moduleModel == null || ((protectionGroupModel = moduleModel.getProtectionGroupModel()) != null ? moduleModel == protectionGroupModel.getProtectModuleModel() : bl)) {
                    continue;
                }
            } else if (n == 34 || n == 32 || n == 31 || n == 33 || n == 114) {
                moduleModel = (ModuleModel)entityModel.getModuleModel();
                if (moduleModel == null || ((protectionGroupModel = moduleModel.getProtectionGroupModel()) != null ? moduleModel == protectionGroupModel.getProtectModuleModel() : bl)) {
                    continue;
                }
            } else if (n == 28 || n == 29 || n == 30 || n == 61) {
                ElementModel elementModel;
                ElementModelsDelegate elementModelsDelegate = this.nmd.getElementModelsDelegate();
                if (elementModelsDelegate == null) continue;
                int n2 = entityModel.getEntityIndex();
                try {
                    elementModel = elementModelsDelegate.getElementModel(n2);
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (this.db.on()) {
                        this.db.println("screenAvailPorts - Oc-n ElementModel not found");
                    }
                    elementModel = null;
                }
                if (elementModel != null) {
                    block20: {
                        if (elementModel.getType() == 1) {
                            int n3;
                            OnePlusOneModel onePlusOneModel = (OnePlusOneModel)elementModel;
                            try {
                                n3 = onePlusOneModel.getProtectEntityIndex();
                            }
                            catch (AbstractCmsIOException abstractCmsIOException) {
                                n3 = -1;
                            }
                            if (n3 == n2) {
                                continue;
                            }
                        } else if (elementModel.getType() == 3 && !bl) {
                            BlsrModel blsrModel = (BlsrModel)elementModel;
                            int n4 = blsrModel.getProtectEntityIndex(entityModel.getEntityIndex());
                            try {
                                IEntityModel iEntityModel = this.getEntityModelByIndex(n4);
                                list.add(iEntityModel);
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                this.db.println("Unable to find Protect Entity for 4F BLSR:" + n4);
                                if (!this.db.on()) break block20;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                        }
                    }
                    if (bl && elementModel.getType() == 0) continue;
                }
            }
            list.add(entityModel);
        }
    }

    public void lapFilterEntities(List list, List list2) {
        int n;
        IEntityModel iEntityModel;
        this.loFilterEntities(list, list2);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            iEntityModel = (IEntityModel)iterator.next();
            n = iEntityModel.getPayloadType();
            if (n != 5 && n != 10 && n != 11 && n != 12 && n != 15 && n != 16 && n != 14 && n != 18) continue;
            iterator.remove();
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            iEntityModel = (IEntityModel)iterator.next();
            n = iEntityModel.getPayloadType();
            if (n != 3) continue;
            list2.add(iEntityModel);
        }
    }

    private void loFilterEntities(List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            int n = iEntityModel.getPayloadType();
            if (n != 1 && n != 7 && n != 2 && n != 4 && n != 5 && n != 9 && n != 12 && n != 10 && n != 11 && n != 14 && n != 18) continue;
            list2.add(iEntityModel);
        }
    }

    private void hoFilterEntities(List list, List list2, int n) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            int n2 = iEntityModel.getPayloadType();
            if (n2 == 6 || n2 == 8 || n2 == 13 || n2 == 18 || n2 == 17) {
                if (n != 1) continue;
                list2.add(iEntityModel);
                continue;
            }
            list2.add(iEntityModel);
        }
    }

    public void filterDropEntities(List list, IEntityModel iEntityModel, int n, int n2, List list2) {
    }

    public IEntityModel getModule(int n) {
        List list;
        IEntityModel iEntityModel = this.nmd.getEntityTableModel().getEntityModelBySlot(n);
        IEntityModel iEntityModel2 = null;
        if (iEntityModel != null && (list = iEntityModel.getChildren()).size() > 0) {
            iEntityModel2 = (IEntityModel)list.get(0);
        }
        return iEntityModel2;
    }

    public long getLastInterfaceChange(int n) {
        long l = 0L;
        ModuleModel moduleModel = (ModuleModel)this.getModule(n);
        if (moduleModel != null) {
            l = moduleModel.getLastInterfaceChange();
        }
        return l;
    }

    public Map getAllLastInterfaceChanges() {
        HashMap<Integer, Long> hashMap = new HashMap<Integer, Long>();
        int n = 0;
        long l = 0L;
        EntityModel entityModel = (EntityModel)this.getChassis().getChildren().get(0);
        Iterator iterator = entityModel.getChildrenOfType(eClass.CONTAINER).iterator();
        while (iterator.hasNext()) {
            ModuleModel moduleModel;
            EntityModel entityModel2 = (EntityModel)iterator.next();
            List list = entityModel2.getChildren();
            if (list.size() > 0 && list.get(0) instanceof ModuleModel && (moduleModel = (ModuleModel)list.get(0)) != null) {
                l = moduleModel.getLastInterfaceChange();
                n = moduleModel.getSlot();
                hashMap.put(new Integer(n), new Long(l));
            }
            n = 0;
            l = 0L;
        }
        return hashMap;
    }

    public IEntityModel getPort(int n, int[] nArray) {
        EntityModel entityModel = (EntityModel)this.getModule(n);
        if (entityModel != null) {
            List list = entityModel.getDescendantsOfType(eClass.PORT);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PortModel portModel = (PortModel)iterator.next();
                if (ComparisonUtil.compare(portModel.getPortNum(), nArray) != 0) continue;
                return portModel;
            }
        }
        return null;
    }

    protected IEntityModel findEntityInPosition(IEntityModel iEntityModel, int n) {
        IEntityModel iEntityModel2 = null;
        if (iEntityModel != null) {
            List list = iEntityModel.getChildren();
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                IEntityModel iEntityModel3 = (IEntityModel)list.get(i);
                if (iEntityModel3.getPositionInParent() != n) continue;
                iEntityModel2 = iEntityModel3;
                break;
            }
        }
        return iEntityModel2;
    }

    public List getAvailEntitiesForHoVcat(short s, IVcatTermAttributes iVcatTermAttributes, boolean bl) {
        LinkedList linkedList = new LinkedList();
        IVcatTermModels iVcatTermModels = this.nmd.getVcatTermModels();
        int n = iVcatTermAttributes.getDirection();
        IEntityModel[] iEntityModelArray = iVcatTermModels.getAvailEntitiesForHoVcat(iVcatTermAttributes, s);
        if (this.db.on()) {
            this.db.println("entities after getAvailEntitiesForHoVcat(pathSize=" + s + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
        }
        List<IEntityModel> list = Arrays.asList(iEntityModelArray);
        this.hoFilterEntities(list, linkedList, n);
        if (this.db.on()) {
            this.db.println("returnList: " + linkedList.size() + "(size), " + linkedList);
        }
        return linkedList;
    }

    public List getAvailEntitiesForLoVcat(int n, IVcatTermAttributes iVcatTermAttributes, boolean bl) {
        LinkedList linkedList = new LinkedList();
        IEntityModel iEntityModel = this.nmd.getChassis();
        if (iEntityModel == null) {
            if (this.db.on()) {
                this.db.println("unable to find chassis model");
            }
            return linkedList;
        }
        if (!this.nmd.provides(Feature.XCVT)) {
            if (this.db.on()) {
                this.db.println("Node does not support VT XC's");
            }
            return linkedList;
        }
        IVcatTermModels iVcatTermModels = this.nmd.getVcatTermModels();
        int n2 = iVcatTermAttributes.getDirection();
        IEntityModel[] iEntityModelArray = iVcatTermModels.getAvailEntitiesForLoVcat(iVcatTermAttributes, n);
        if (this.db.on()) {
            this.db.println("entities after getAvailEntitiesForLoVcat(pathSize=" + n + "): " + iEntityModelArray.length + "(length), " + iEntityModelArray);
        }
        List<IEntityModel> list = Arrays.asList(iEntityModelArray);
        this.loFilterEntities(list, linkedList);
        if (this.db.on()) {
            this.db.println("returnList: " + linkedList.size() + "(size), " + linkedList);
        }
        return linkedList;
    }

    public boolean hasStandbyControllerCard(eEqType eEqType2) {
        EntityModel entityModel = this.getControllerCard(eEqType2, eEqState.STANDBY);
        return entityModel != null;
    }

    public boolean isStandbyTCC2P() {
        EntityModel entityModel = this.getControllerCard(eEqType.TCC_CARD, eEqState.STANDBY);
        return entityModel != null && this.isTCC2P(entityModel);
    }

    public boolean hasActiveTCC2P() {
        EntityModel entityModel = this.getControllerCard(eEqType.TCC_CARD, eEqState.ACTIVE);
        return entityModel != null && this.isTCC2P(entityModel);
    }

    private EntityModel getControllerCard(eEqType eEqType2, eEqState eEqState2) {
        EntityModel entityModel = null;
        EntityModel entityModel2 = (EntityModel)this.getChassis();
        if (entityModel2 == null) {
            if (this.db.on()) {
                this.db.println("getControllerCard- chassis is not present");
            }
            throw new CmsObjectNotExistException("chassis is null");
        }
        try {
            List list = entityModel2.getDescendantsOfType(eEqType2);
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    PluggableModel pluggableModel;
                    EntityModel entityModel3 = (EntityModel)list.get(i);
                    if (!(entityModel3 instanceof PluggableModel) || (pluggableModel = (PluggableModel)entityModel3).getState() != eEqState2) continue;
                    entityModel = entityModel3;
                    return entityModel;
                }
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.println("cc(): Exception in chassis.getDescendantsOfType - " + (Object)((Object)abstractCmsIOException));
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            throw abstractCmsIOException;
        }
        return entityModel;
    }

    public boolean isTCC2P(EntityModel entityModel) {
        String string;
        PluggableModel pluggableModel;
        Map map;
        boolean bl = false;
        if (entityModel instanceof PluggableModel && (map = (pluggableModel = (PluggableModel)entityModel).getExtraInfoMap()).containsKey("SWTYPE") && (string = (String)map.get("SWTYPE")).equals("1")) {
            bl = true;
        }
        return bl;
    }

    public void debugDumpEntityTree(IEntityModel iEntityModel) {
        if (this.db.on()) {
            this.db.println("--- Entity Tree ---");
            this.debugDumpEntityTree(iEntityModel, 0);
            this.db.println("--- Entity Tree ---");
        }
    }

    private void debugDumpEntityTree(IEntityModel iEntityModel, int n) {
        if (null != iEntityModel) {
            String string = "";
            for (int i = 0; i < n; ++i) {
                string = string + "| ";
            }
            this.db.println(string + iEntityModel.toString());
            Iterator iterator = iEntityModel.getChildren().iterator();
            while (iterator.hasNext()) {
                this.debugDumpEntityTree((IEntityModel)iterator.next(), n + 1);
            }
        }
    }

    public String toString() {
        return "EntityTable";
    }

    public final void dump() {
        this.debugDumpEntityTree(this.getChassis());
    }

    public final void printTable() {
        Iterator iterator = this.entityModelTable.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = this.entityModelTable.get(k);
            this.db.println("index = " + k.toString() + ", type = " + v.getClass().getName());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TestAllLeds
    extends NonCachedValue {
        public TestAllLeds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() {
            EntityTableModel.this.getEntityTableRef().testAllLeds();
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class EntityList
    extends NonCachedValue {
        public EntityList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return EntityTableModel.this.getEntityTableRef().entityList();
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class GetPortTypeList
    extends NonCachedValue {
        public GetPortTypeList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            return EntityTableModel.this.getEntityTableRef().getPortTypeList(n, n2);
        }
    }

    class UnprovisionPort
    extends NonCachedValue {
        public UnprovisionPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            int n = (Integer)object;
            boolean bl = EntityTableModel.this.getEntityTableRef().unprovisionPort(n);
            return new Boolean(bl);
        }
    }

    class ProvisionPort
    extends NonCachedValue {
        public ProvisionPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            eEqType eEqType2 = (eEqType)objectArray[2];
            boolean bl = EntityTableModel.this.getEntityTableRef().provisionPort(n, n2, eEqType2);
            return new Boolean(bl);
        }
    }

    class ProvisionPluggable
    extends NonCachedValue {
        public ProvisionPluggable(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInUse, xProvisionError {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            eEqType eEqType2 = (eEqType)objectArray[1];
            return EntityTableModel.this.getEntityTableRef().provisionPluggable(n, eEqType2);
        }
    }

    class ProvisionModule
    extends NonCachedValue {
        public ProvisionModule(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0] + 1;
            return EntityTableModel.this.getEntityTableRef().provisionModule(n, (eEqType)objectArray[1]);
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class ProvisionProtectionGroup
    extends NonCachedValue {
        public ProvisionProtectionGroup(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return EntityTableModel.this.getEntityTableRef().provisionProtectionGroup((sProtectionConfig)object, false);
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class ProtectionGroupList
    extends NonCachedValue {
        public ProtectionGroupList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return EntityTableModel.this.getEntityTableRef().protectionGroupList();
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }

    class LastChange
    extends NonCachedValue {
        public LastChange(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Long(EntityTableModel.this.getEntityTableRef().lastChange());
        }

        public Object outer() {
            return EntityTableModel.this;
        }
    }
}

