/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Alarm.sAlarmMessage;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.model.AlarmEventQueue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventQueue;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ObjectMessageQueue;
import cerent.cms.model.event.AlarmDecoder;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.stats.StatsMgr;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class EventDispatcher {
    public static final int maxAlrBuff = 100;
    private DispatcherDebug db;
    private ObjectMessageActionClient objectMessageActionClient;
    private AlarmEventActionClient alarmEventActionClient;
    private NodeModelDelegate nodeModel;
    private Map ObservableList;
    private Map indexLessObservableList;
    private EventUtilities eventUtilities;
    private EventQueue alarmEventQueue;
    private EventQueue objectMessageQueue;
    private ElementAlarmStore alarmStore;
    private ElementEventStore eventStore;
    private static ModelSingletonCollection eventDispatcherSingletons;
    static /* synthetic */ Class class$cerent$cms$idl$Common$ObjectType;
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;
    static /* synthetic */ Class class$cerent$cms$model$IObjectType;

    public static synchronized EventDispatcher getInstance(NodeModelDelegate nodeModelDelegate) {
        EventDispatcher eventDispatcher;
        if (eventDispatcherSingletons == null) {
            eventDispatcherSingletons = ModelSingletonCollection.getMSCInstanceByName("EventDispatcher");
        }
        if ((eventDispatcher = (EventDispatcher)eventDispatcherSingletons.get(nodeModelDelegate)) == null) {
            eventDispatcher = new EventDispatcher(nodeModelDelegate);
            eventDispatcherSingletons.add(nodeModelDelegate, eventDispatcher);
        }
        return eventDispatcher;
    }

    private EventDispatcher(NodeModelDelegate nodeModelDelegate) {
        this.nodeModel = nodeModelDelegate;
        this.alarmEventActionClient = null;
        this.objectMessageActionClient = null;
        this.eventUtilities = EventUtilities.getInstance(nodeModelDelegate);
        this.alarmEventQueue = AlarmEventQueue.getInstance(nodeModelDelegate);
        this.objectMessageQueue = ObjectMessageQueue.getInstance(nodeModelDelegate);
        this.ObservableList = Collections.synchronizedMap(new HashMap(101));
        this.indexLessObservableList = Collections.synchronizedMap(new HashMap(10));
        this.alarmStore = (ElementAlarmStore)this.nodeModel.getElementAlarmStore();
        this.eventStore = (ElementEventStore)this.nodeModel.getElementEventStore();
        this.db = new DispatcherDebug(nodeModelDelegate.getDebug(), "EventDispatcher");
    }

    public synchronized void start() {
        if (this.alarmEventActionClient == null) {
            this.alarmEventActionClient = new AlarmEventActionClient(this, this.nodeModel);
            this.alarmEventQueue.setActionClient(this.alarmEventActionClient);
        }
        if (this.objectMessageActionClient == null) {
            this.objectMessageActionClient = new ObjectMessageActionClient(this, this.nodeModel, this.ObservableList, this.indexLessObservableList);
            this.objectMessageQueue.setActionClient(this.objectMessageActionClient);
        }
    }

    public void convertAlarmsToEventInfo(ArrayList arrayList, sAlarmMessage[] sAlarmMessageArray, long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.eventUtilities.convertAlarmsToEventInfo(arrayList, sAlarmMessageArray, l, bl, bl2, bl3, bl4, bl5);
    }

    public int oidFromTypeAndIndex(int n, int n2) {
        int n3 = (n << 24) + n2;
        return n3;
    }

    public int getTypeFromOid(int n) {
        return n >> 24;
    }

    public int getIndexFromOid(int n) {
        int n2 = 0xFFFFFF;
        return n & n2;
    }

    public Model getModel(int n, int n2) {
        return this.getModel(ObjectType.from_int(n), n2);
    }

    public Model getModel(ObjectType objectType, int n) {
        if (this.db.on) {
            this.db.print("Getting Model for ");
            this.db.print(" Type = " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Common$ObjectType == null ? (class$cerent$cms$idl$Common$ObjectType = EventDispatcher.class$("cerent.cms.idl.Common.ObjectType")) : class$cerent$cms$idl$Common$ObjectType))[objectType.value()]);
            this.db.println(" Index = " + Integer.toHexString(n));
        }
        return this.getModel(this.oidFromTypeAndIndex(objectType.value(), n));
    }

    private Model getModel(int n) {
        Model model = null;
        CmsObservable cmsObservable = (CmsObservable)((Object)this.ObservableList.get(new Integer(n)));
        if (cmsObservable != null) {
            int n2 = cmsObservable.getObservers().size();
            if (n2 == 1) {
                Object[] objectArray = cmsObservable.getObservers().toArray();
                model = (Model)objectArray[0];
            } else if (this.db.on()) {
                this.db.println("Number of observers = " + n2);
                this.db.println(" Since its not 1, we dont know what to return?");
            }
        } else if (this.db.on()) {
            this.db.println("No Observers for this type and index registered yet :( ");
        }
        return model;
    }

    public void addObserver(int n, Observer observer) {
        int n2;
        CmsObservable cmsObservable = null;
        cmsObservable = (CmsObservable)((Object)this.ObservableList.get(new Integer(n)));
        if (cmsObservable == null) {
            cmsObservable = new StatsObservable();
            this.ObservableList.put(new Integer(n), cmsObservable);
        }
        cmsObservable.addObserver(observer);
        if (this.db.on() && (n2 = cmsObservable.getObservers().size()) > 1) {
            this.db.println("Number of observers = " + n2);
            this.db.println("Type = " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Common$ObjectType == null ? (class$cerent$cms$idl$Common$ObjectType = EventDispatcher.class$("cerent.cms.idl.Common.ObjectType")) : class$cerent$cms$idl$Common$ObjectType))[this.getTypeFromOid(n)]);
            this.db.println("Index = " + this.getIndexFromOid(n));
            Object[] objectArray = cmsObservable.getObservers().toArray();
            for (int i = 0; i < n2; ++i) {
                this.db.println("Class name = " + objectArray[i].getClass().getName());
            }
        }
    }

    public void addObserver(ObjectType objectType, int n, Observer observer) {
        if (this.db.on) {
            this.db.println("addObserver(type=" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Common$ObjectType == null ? (class$cerent$cms$idl$Common$ObjectType = EventDispatcher.class$("cerent.cms.idl.Common.ObjectType")) : class$cerent$cms$idl$Common$ObjectType))[objectType.value()] + ", i=" + Integer.toHexString(n) + ")");
        }
        this.addObserver(this.oidFromTypeAndIndex(objectType.value(), n), observer);
    }

    public void addObserver(int n, int n2, Observer observer) {
        this.addObserver(ObjectType.from_int(n), n2, observer);
    }

    public void addObserver(ObjectType objectType, Observer observer) {
        CmsObservable cmsObservable = null;
        if (this.db.on) {
            this.db.println("addObserver will add the type: " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Common$ObjectType == null ? (class$cerent$cms$idl$Common$ObjectType = EventDispatcher.class$("cerent.cms.idl.Common.ObjectType")) : class$cerent$cms$idl$Common$ObjectType))[objectType.value()] + " list of Index Less Observers.");
            this.db.println("The Observer is: " + observer);
        }
        if ((cmsObservable = (CmsObservable)((Object)this.indexLessObservableList.get(objectType))) == null) {
            cmsObservable = new StatsObservable();
            this.indexLessObservableList.put(objectType, cmsObservable);
        }
        cmsObservable.addObserver(observer);
    }

    public void deleteObserver(int n, Observer observer) {
        CmsObservable cmsObservable = null;
        cmsObservable = (CmsObservable)((Object)this.ObservableList.get(new Integer(n)));
        if (cmsObservable != null) {
            cmsObservable.deleteObserver(observer);
            if (cmsObservable.countObservers() == 0) {
                this.ObservableList.remove(new Integer(n));
            }
        }
        if (this.db.on) {
            this.db.println("deleteObserver: Hash table size = " + this.ObservableList.size());
        }
    }

    public void deleteObserver(ObjectType objectType, int n, Observer observer) {
        if (this.db.on) {
            this.db.println("deleteObserver(type=" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Common$ObjectType == null ? (class$cerent$cms$idl$Common$ObjectType = EventDispatcher.class$("cerent.cms.idl.Common.ObjectType")) : class$cerent$cms$idl$Common$ObjectType))[objectType.value()] + ", i=" + Integer.toHexString(n) + ")");
        }
        this.deleteObserver(this.oidFromTypeAndIndex(objectType.value(), n), observer);
    }

    public void deleteObserver(int n, int n2, Observer observer) {
        this.deleteObserver(ObjectType.from_int(n), n2, observer);
    }

    public void deleteObserver(ObjectType objectType, Observer observer) {
        CmsObservable cmsObservable = null;
        cmsObservable = (CmsObservable)((Object)this.indexLessObservableList.get(objectType));
        if (cmsObservable != null) {
            cmsObservable.deleteObserver(observer);
            if (cmsObservable.countObservers() == 0) {
                this.indexLessObservableList.remove(objectType);
            }
        }
        if (this.db.on) {
            this.db.println("deleteObserver: Hash table size = " + this.indexLessObservableList.size());
        }
    }

    private void deleteObservers() {
        CmsObservable cmsObservable = null;
        Set set = this.ObservableList.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            cmsObservable = (CmsObservable)((Object)this.ObservableList.get(n));
            if (cmsObservable == null) continue;
            cmsObservable.deleteObservers();
            this.ObservableList.remove(n);
        }
    }

    public void dumpObservables() {
        Set set = this.ObservableList.keySet();
        this.db.println("----[EventDispatcher] Dump of ObservableList keys:");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            this.db.println("----[EventDispatcher]     key: " + Integer.toHexString(n));
        }
        this.db.println("----[EventDispatcher] End of Key Dump ---");
    }

    public synchronized void reset() {
        if (this.alarmEventActionClient != null) {
            this.alarmEventQueue.setActionClient(null);
            this.alarmEventActionClient = null;
            if (this.db.on()) {
                this.db.println("reset(): alarmEventActionClient = null");
            }
        }
        if (this.objectMessageActionClient != null) {
            this.objectMessageQueue.setActionClient(null);
            this.objectMessageActionClient = null;
            if (this.db.on()) {
                this.db.println("reset(): objectMessageActionClient = null");
            }
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose(): entered");
        }
        this.reset();
        if (this.db.on()) {
            this.db.println("dispose(): exited");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class StatsObservable
    extends CmsObservable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void sendUpdate(Observer observer, Object object, int n) {
            Object object2;
            String string = null;
            Exception exception = null;
            if (StatsMgr.instance().isUpdateStarted()) {
                IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object;
                object2 = StatsMgr.instance().beginOperation(EventDispatcher.this.nodeModel.getName(), ((EventDispatcher)EventDispatcher.this).db.objectTypeNames[iObjectMessageInfo.getObjectType()], iObjectMessageInfo.getUpdateType(), iObjectMessageInfo.getIndex());
                string = this.getRealObserverClassName(observer);
                if (n > 1) {
                    string = string + " #" + n;
                }
            } else {
                object2 = null;
            }
            try {
                try {
                    if (observer instanceof IObserver) {
                        ((IObserver)observer).update((IObservable)this, object);
                    } else {
                        if (!(observer instanceof Observer)) throw new Exception("target: " + observer.getClass().getName() + " must be an observer type");
                        observer.update((Observable)((Object)this), object);
                    }
                    Object var9_9 = null;
                    if (object2 == null) return;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    this.handleException(exception2, observer, object);
                    Object var9_10 = null;
                    if (object2 == null) return;
                    StatsMgr.instance().endOperation(object2, string, exception);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (object2 == null) throw throwable;
                StatsMgr.instance().endOperation(object2, string, exception);
                throw throwable;
            }
            StatsMgr.instance().endOperation(object2, string, exception);
        }
    }

    public class DispatcherDebug
    extends SDebug {
        private boolean watchAllObjectTypes = false;
        private ArrayList objectTypesToWatch = new ArrayList();
        protected String[] objectTypeNames = EnumStrings.getStrings((Class)(class$cerent$cms$idl$Common$ObjectType == null ? (class$cerent$cms$idl$Common$ObjectType = EventDispatcher.class$("cerent.cms.idl.Common.ObjectType")) : class$cerent$cms$idl$Common$ObjectType));
        protected String[] updateTypeNames = EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = EventDispatcher.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType));
        public final String Hlisten = "Watch for a certain event type";
        public final String Hunlisten = "Stop watching for a certain event type";
        public final String HlistenAll = "Watch for all event types";
        public final String HlistenAllOff = "Stop watching for all event types";
        public final String HdumpAllObservables = "List observables";

        public DispatcherDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void listen(String string) {
            try {
                Field field;
                if (!string.startsWith("Object")) {
                    string = "Object" + string;
                }
                if ((field = (class$cerent$cms$model$IObjectType == null ? (class$cerent$cms$model$IObjectType = EventDispatcher.class$("cerent.cms.model.IObjectType")) : class$cerent$cms$model$IObjectType).getField(string)) != null) {
                    int n = field.getInt(class$cerent$cms$model$IObjectType == null ? (class$cerent$cms$model$IObjectType = EventDispatcher.class$("cerent.cms.model.IObjectType")) : class$cerent$cms$model$IObjectType);
                    this.objectTypesToWatch.add(new Integer(n));
                    EventDispatcher.this.db.println("Added EventDispatcher listener: " + string);
                } else {
                    EventDispatcher.this.db.println("Invalid ObjectType entered.");
                }
            }
            catch (Exception exception) {
                EventDispatcher.this.db.println("Exception Occurred - unable to add EventDispatcher listener: " + string);
            }
        }

        public final void unlisten(String string) {
            try {
                Field field;
                if (!string.startsWith("Object")) {
                    string = "Object" + string;
                }
                if ((field = (class$cerent$cms$model$IObjectType == null ? (class$cerent$cms$model$IObjectType = EventDispatcher.class$("cerent.cms.model.IObjectType")) : class$cerent$cms$model$IObjectType).getField(string)) != null) {
                    int n = field.getInt(class$cerent$cms$model$IObjectType == null ? (class$cerent$cms$model$IObjectType = EventDispatcher.class$("cerent.cms.model.IObjectType")) : class$cerent$cms$model$IObjectType);
                    this.unlisten(string, n);
                } else {
                    EventDispatcher.this.db.println("Invalid ObjectType entered.");
                }
            }
            catch (Exception exception) {
                EventDispatcher.this.db.println("Exception Occurred - unable to remove EventDispatcher listener: " + string);
            }
        }

        public final void listenAll() {
            this.watchAllObjectTypes = true;
            EventDispatcher.this.db.println("EventDispatcher ListenAll: On");
        }

        public final void listenAllOff() {
            this.watchAllObjectTypes = false;
            EventDispatcher.this.db.println("EventDispatcher ListenAll: Off");
        }

        public final void dumpAllObservables() {
            EventDispatcher.this.dumpObservables();
        }

        public boolean isWatchingFor(int n) {
            if (this.watchAllObjectTypes) {
                return true;
            }
            boolean bl = false;
            for (int i = 0; i < this.objectTypesToWatch.size(); ++i) {
                if ((Integer)this.objectTypesToWatch.get(i) != n) continue;
                bl = true;
            }
            return bl;
        }

        private void unlisten(String string, int n) {
            Integer n2 = null;
            for (int i = 0; i < this.objectTypesToWatch.size(); ++i) {
                Integer n3 = (Integer)this.objectTypesToWatch.get(i);
                if (n3 != n) continue;
                n2 = n3;
            }
            if (n2 != null) {
                this.objectTypesToWatch.remove(n2);
                EventDispatcher.this.db.println("Removed EventDispatcher listener: " + string);
            }
        }
    }

    public class AlarmEventActionClient
    implements IActionClient {
        private EventDispatcher theDisp = null;
        private NodeModelDelegate theNode = null;
        private Object acLock = null;
        private boolean destroyed = false;

        AlarmEventActionClient(EventDispatcher eventDispatcher2, NodeModelDelegate nodeModelDelegate) {
            this.theDisp = eventDispatcher2;
            this.theNode = nodeModelDelegate;
            this.acLock = new Object();
            this.destroyed = false;
        }

        public void doAction() {
            ArrayList<EventInfo> arrayList = new ArrayList<EventInfo>();
            Object object = this.acLock;
            synchronized (object) {
                while (true) {
                    try {
                        while (true) {
                            if (this.destroyed || EventDispatcher.this.alarmEventQueue.size() == 0) {
                                return;
                            }
                            Object object2 = EventDispatcher.this.alarmEventQueue.dequeue();
                            if (object2 == null) {
                                if (EventDispatcher.this.db.on()) {
                                    EventDispatcher.this.db.println("AlarmEventQueue for " + this.theNode.getHostName() + " stopping...");
                                }
                                return;
                            }
                            EventInfo eventInfo = (EventInfo)object2;
                            if (!this.destroyed && ((EventDispatcher)EventDispatcher.this).db.on) {
                                AlarmDecoder alarmDecoder = this.theNode.getAlarmDecoder();
                                EventDispatcher.this.db.println("(EventDisp) (ALM) recv alarm: Index: " + Integer.toHexString(eventInfo.getIndex()) + "; cond: " + alarmDecoder.getConditionCode(eventInfo.getCondition()) + "; stat: " + eventInfo.getState());
                            }
                            if (!this.destroyed && eventInfo.getSeverity() >= 1) {
                                arrayList.add(eventInfo);
                            }
                            if (this.destroyed || arrayList.size() <= 100 && EventDispatcher.this.alarmEventQueue.size() != 0) continue;
                            if (((EventDispatcher)EventDispatcher.this).db.on) {
                                EventDispatcher.this.db.println("sending " + arrayList.size() + " events");
                            }
                            EventDispatcher.this.alarmStore.addEvents(arrayList);
                            EventDispatcher.this.eventStore.addEvents(arrayList);
                            arrayList.clear();
                        }
                    }
                    catch (Exception exception) {
                        if (EventDispatcher.this.db.on()) {
                            EventDispatcher.this.db.println("Exception in EventDispatcher update processing (2)");
                        }
                        EventDispatcher.this.db;
                        DispatcherDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        }

        public String toString() {
            return "Node " + this.theNode.getHostName() + ": Alm/Evt AC";
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }

        public void dispose() {
            this.destroyed = true;
        }
    }

    public class ObjectMessageActionClient
    implements IActionClient {
        private EventDispatcher theDisp = null;
        private NodeModelDelegate theNode = null;
        private Map theObservers;
        private Map theIndexLessObservers;
        private Object acLock = null;
        private boolean destroyed = false;

        ObjectMessageActionClient(EventDispatcher eventDispatcher2, NodeModelDelegate nodeModelDelegate, Map map, Map map2) {
            this.theDisp = eventDispatcher2;
            this.theNode = nodeModelDelegate;
            this.theObservers = map;
            this.theIndexLessObservers = map2;
            this.acLock = new Object();
            this.destroyed = false;
        }

        public void doAction() {
            Object object = this.acLock;
            synchronized (object) {
                block7: while (true) {
                    while (true) {
                        try {
                            while (true) {
                                if (this.destroyed || EventDispatcher.this.objectMessageQueue.size() == 0) {
                                    return;
                                }
                                Object object2 = EventDispatcher.this.objectMessageQueue.dequeue();
                                if (object2 == null) {
                                    if (EventDispatcher.this.db.on()) {
                                        EventDispatcher.this.db.println("ObjectMessageQueue for " + this.theNode.getHostName() + " stopping...");
                                    }
                                    return;
                                }
                                if (EventDispatcher.this.db.on()) {
                                    EventDispatcher.this.db.println("EventDispatcher: New Message not null");
                                }
                                if (EventDispatcher.this.db.on()) {
                                    EventDispatcher.this.db.println("EventDispatcher: eventReceived()");
                                }
                                try {
                                    int n;
                                    CmsObservable cmsObservable;
                                    IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object2;
                                    if (EventDispatcher.this.db.isWatchingFor(iObjectMessageInfo.getObjectType())) {
                                        GregorianCalendar gregorianCalendar = new GregorianCalendar();
                                        String string = gregorianCalendar.get(10) + ":" + gregorianCalendar.get(12) + ":" + gregorianCalendar.get(13) + "." + gregorianCalendar.get(14);
                                        EventDispatcher.this.db.println("(UPDATEMESSAGE): from=" + this.theNode.getName() + ";  ObjectType=" + ((EventDispatcher)EventDispatcher.this).db.objectTypeNames[iObjectMessageInfo.getObjectType()] + "; updateType= " + ((EventDispatcher)EventDispatcher.this).db.updateTypeNames[iObjectMessageInfo.getUpdateType()] + "; index= " + Integer.toHexString(iObjectMessageInfo.getIndex()) + "; childObjectType=" + ((EventDispatcher)EventDispatcher.this).db.objectTypeNames[iObjectMessageInfo.getChildObjectType()] + "; childIndex=" + Integer.toHexString(iObjectMessageInfo.getChildIndex()) + "; timestampe= " + string + "; moduleIndex=" + Integer.toHexString(iObjectMessageInfo.getModuleIndex()));
                                    }
                                    if ((cmsObservable = (CmsObservable)((Object)this.theObservers.get(new Integer(n = this.theDisp.oidFromTypeAndIndex(iObjectMessageInfo.getObjectType(), iObjectMessageInfo.getIndex()))))) != null) {
                                        cmsObservable.setChanged();
                                        cmsObservable.notifyObservers(iObjectMessageInfo);
                                    }
                                    cmsObservable = null;
                                    int n2 = iObjectMessageInfo.getObjectType();
                                    cmsObservable = (CmsObservable)((Object)this.theIndexLessObservers.get(ObjectType.from_int(n2)));
                                    if (cmsObservable == null) continue block7;
                                    if (EventDispatcher.this.db.on()) {
                                        EventDispatcher.this.db.println("EventDispatcher is notifying: " + (Object)((Object)cmsObservable));
                                    }
                                    cmsObservable.setChanged();
                                    cmsObservable.notifyObservers(iObjectMessageInfo);
                                    continue block7;
                                }
                                catch (Exception exception) {
                                    if (EventDispatcher.this.db.on()) {
                                        EventDispatcher.this.db.println("Exception in EventDispatcher update processing (1)");
                                    }
                                    EventDispatcher.this.db;
                                    DispatcherDebug.printStackTrace((Throwable)exception);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception exception) {
                            if (EventDispatcher.this.db.on()) {
                                EventDispatcher.this.db.println("Exception in EventDispatcher update processing (2)");
                            }
                            EventDispatcher.this.db;
                            DispatcherDebug.printStackTrace((Throwable)exception);
                            continue;
                        }
                        break;
                    }
                }
            }
        }

        public String toString() {
            return "Node " + this.theNode.getHostName() + ": Update AC";
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }

        public void dispose() {
            this.destroyed = true;
        }
    }
}

