/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Alarm.sAlarmMessage;
import cerent.cms.idl.Callback.EventHandlerPOA;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.clientId;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.Event.sObjectChange;
import cerent.cms.idl.Event.sObjectChangesListHolder;
import cerent.cms.model.AlarmEventQueue;
import cerent.cms.model.AlarmMessageFactory;
import cerent.cms.model.EventQueue;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ObjectMessageQueue;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.ui.event.IAlarmDecoder;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.ior.IiopProfile;
import cerent.util.ior.Ior;
import cerent.util.ior.IorFactory;
import cerent.util.orb.CtcIncarnationException;
import cerent.util.orb.OngORB;
import cerent.util.proxy.CtcProxy;
import cerent.util.proxy.CtcProxyFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class EventReceiver
extends EventHandlerPOA {
    private static final String EVENT_RECEIVER_POA_NAME = "EventReceiverPOA";
    private SDebug db;
    private EventUtilities eventUtilities;
    private EventQueue alarmEventQueue;
    private EventQueue objectMessageQueue;
    private NodeModelDelegate nmd;
    private Register register;
    private Reregister reregister;
    private IsRegistered isRegistered;
    private UnRegister unRegister;
    private String _ior;
    private String _sior;
    private long lastUpdateSeqProcessed;
    private static final String PREFS_PERSIST = "ctc.model.persist";
    private static ModelSingletonCollection eventReceiverSingletons;
    static /* synthetic */ Class class$cerent$cms$idl$Common$ObjectType;
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;

    public static synchronized EventReceiver getInstance(NodeModelDelegate nodeModelDelegate) {
        EventReceiver eventReceiver;
        if (eventReceiverSingletons == null) {
            eventReceiverSingletons = ModelSingletonCollection.getMSCInstanceByName("EventReceiver");
        }
        if ((eventReceiver = (EventReceiver)eventReceiverSingletons.get(nodeModelDelegate)) == null) {
            eventReceiver = new EventReceiver(nodeModelDelegate);
            eventReceiverSingletons.add(nodeModelDelegate, eventReceiver);
        }
        return eventReceiver;
    }

    private EventReceiver(NodeModelDelegate nodeModelDelegate) throws CtcIncarnationException {
        this.nmd = nodeModelDelegate;
        this.db = new SDebug((KDebug)nodeModelDelegate.getDebug(), "EventReceiver");
        this.lastUpdateSeqProcessed = 0L;
        this.eventUtilities = EventUtilities.getInstance(nodeModelDelegate);
        this.alarmEventQueue = AlarmEventQueue.getInstance(nodeModelDelegate);
        this.objectMessageQueue = ObjectMessageQueue.getInstance(nodeModelDelegate);
        this.register = new Register(nodeModelDelegate, "EventReceiver.register");
        this.reregister = new Reregister(nodeModelDelegate, "EventReceiver.reregister");
        this.isRegistered = new IsRegistered(nodeModelDelegate, "EventReceiver.isRegistered");
        this.unRegister = new UnRegister(nodeModelDelegate, "EventReceiver.unRegister");
        this.connectToORB();
    }

    public void updateAlarms(int n, sAlarmMessage[] sAlarmMessageArray) {
        block12: {
            int n2;
            java.lang.Object object;
            block11: {
                if (this.alarmEventQueue == null) {
                    return;
                }
                try {
                    if (this.db.on()) {
                        this.db.println("(ALM) received updateAlarms from " + Integer.toHexString(n));
                    }
                    long l = 0L;
                    object = null;
                    String string = null;
                    long l2 = System.currentTimeMillis();
                    for (int i = 0; i < sAlarmMessageArray.length; ++i) {
                        long l3 = sAlarmMessageArray[i].timeStamp;
                        if (l3 == 0L) {
                            l = l2;
                            object = this.eventUtilities.getLocalTime(l);
                            string = this.eventUtilities.getNeTime();
                        } else {
                            l = this.eventUtilities.convertSecondsToMilliSeconds(l3);
                            object = this.eventUtilities.formatAbsoluteNeTimeasCtcTimeZoneString(l);
                            string = this.eventUtilities.formatAbsoluteNeTimeasNeTimeZoneString(l);
                        }
                        EventInfo eventInfo = new EventInfo((INodeModel)this.nmd, l, (String)object, string, AlarmMessageFactory.getIAlarmMessage(sAlarmMessageArray[i]), (IAlarmDecoder)this.nmd.getAlarmDecoder());
                        this.alarmEventQueue.enqueue(eventInfo, i == sAlarmMessageArray.length - 1);
                    }
                }
                catch (Throwable throwable) {
                    if (!this.db.on()) break block11;
                    this.db.println("***** Throwable caught in updateAlarms *****");
                    this.db.println("\tSender is " + n + " Alarm List is\n\t");
                    for (n2 = 0; n2 < sAlarmMessageArray.length; ++n2) {
                        object = sAlarmMessageArray[n2];
                        this.db.print(object.toString());
                        if (n2 == sAlarmMessageArray.length - 1) continue;
                        this.db.print(", ");
                    }
                    SDebug.printStackTrace((Throwable)throwable);
                }
            }
            try {
                this.alarmEventQueue.enqueueActionClient();
            }
            catch (Throwable throwable) {
                if (!this.db.on()) break block12;
                this.db.println("***** Throwable caught queueing actionClient in updateAlarms *****");
                this.db.println("\tSender is " + n + " Alarm List is\n\t");
                for (n2 = 0; n2 < sAlarmMessageArray.length; ++n2) {
                    object = sAlarmMessageArray[n2];
                    this.db.print(object.toString());
                    if (n2 == sAlarmMessageArray.length - 1) continue;
                    this.db.print(", ");
                }
                SDebug.printStackTrace((Throwable)throwable);
            }
        }
    }

    public void update(int n, ObjectType objectType, int n2, eUpdateType eUpdateType2) {
    }

    public void update(int n, ObjectType objectType, int n2, ObjectType objectType2, int n3, int n4, eUpdateType eUpdateType2, long l, long l2) {
        try {
            if (this.db.on) {
                this.db.print("(EVT) received update with a moduleIndex from " + Integer.toHexString(n) + "; type: ");
                if (objectType == null) {
                    this.db.print("null");
                } else {
                    this.db.print(EnumStrings.getStrings((Class)(class$cerent$cms$idl$Common$ObjectType == null ? (class$cerent$cms$idl$Common$ObjectType = EventReceiver.class$("cerent.cms.idl.Common.ObjectType")) : class$cerent$cms$idl$Common$ObjectType))[objectType.value()]);
                }
                this.db.print("; childIndex: " + Integer.toHexString(n3) + "; childType: ");
                if (objectType2 == null) {
                    this.db.print("null");
                } else {
                    this.db.print(EnumStrings.getStrings((Class)(class$cerent$cms$idl$Common$ObjectType == null ? (class$cerent$cms$idl$Common$ObjectType = EventReceiver.class$("cerent.cms.idl.Common.ObjectType")) : class$cerent$cms$idl$Common$ObjectType))[objectType2.value()]);
                }
                this.db.print("; index: " + Integer.toHexString(n2) + "; moduleIndex: " + Integer.toHexString(n4) + "; updateType: ");
                if (eUpdateType2 == null) {
                    this.db.println("null ; typeSeqNum: " + l2);
                } else {
                    this.db.println(EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = EventReceiver.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType))[eUpdateType2.value()] + " ; typeSeqNum: " + l2);
                }
            }
            if (objectType2 != null && objectType != null && eUpdateType2 != null) {
                this.objectMessageQueue.enqueue(new ObjectMessageInfo(this.nmd, objectType.value(), n2, objectType2.value(), n3, eUpdateType2.value(), l, n4, l2));
            }
            this.lastUpdateSeqProcessed = l;
        }
        catch (Throwable throwable) {
            this.db.println("Throwable caught in update()\nParms: sender = " + n + "; type = " + objectType.toString() + "; index = " + n2 + "; childType = " + objectType2.toString() + "; childIndex = " + n3 + "; updateType = " + eUpdateType2.toString());
            SDebug.printStackTrace((Throwable)throwable);
        }
    }

    public void updateObjects(int n, sObjectChange[] sObjectChangeArray) {
        if (this.objectMessageQueue == null) {
            return;
        }
        if (sObjectChangeArray == null) {
            if (this.db.on()) {
                this.db.println("changeList is NULL in UpdateObjects.");
            }
            return;
        }
        int n2 = 0;
        try {
            if (this.db.on()) {
                this.db.println("updateObjects: " + sObjectChangeArray.length + " update(s) from 0x" + Integer.toHexString(n));
                if (sObjectChangeArray.length > 0) {
                    this.db.println("updateObjects: seq #'s: " + sObjectChangeArray[0].objChangeSeq + " - " + sObjectChangeArray[sObjectChangeArray.length - 1].objChangeSeq);
                } else {
                    this.db.println("changeList is empty!!!.");
                }
            }
        }
        catch (Throwable throwable) {
            this.db.println("updateObjects: Throwable in debug info print");
            SDebug.printStackTrace((Throwable)throwable);
        }
        for (n2 = 0; n2 < sObjectChangeArray.length; ++n2) {
            try {
                this.update(n, sObjectChangeArray[n2].objType, sObjectChangeArray[n2].objIndex, sObjectChangeArray[n2].childObjType, sObjectChangeArray[n2].childIndex, sObjectChangeArray[n2].moduleIndex, sObjectChangeArray[n2].updateType, sObjectChangeArray[n2].objChangeSeq, sObjectChangeArray[n2].typeSeqNum);
                continue;
            }
            catch (Throwable throwable) {
                this.db.println("Throwable caught in updateObjects(): " + sObjectChangeArray.length + " update(s) from 0x" + Integer.toHexString(n) + ", seq #'s: " + sObjectChangeArray[0].objChangeSeq + " - " + sObjectChangeArray[sObjectChangeArray.length - 1].objChangeSeq);
                this.db.println("Thrown when i = " + n2 + ", lastUpdateSeqProcessed = " + this.lastUpdateSeqProcessed);
                SDebug.printStackTrace((Throwable)throwable);
            }
        }
        try {
            this.objectMessageQueue.enqueueActionClient();
        }
        catch (Throwable throwable) {
            this.db.println("Throwable caught in updateObjects(): " + sObjectChangeArray.length + " update(s) from 0x" + Integer.toHexString(n));
            this.db.println("Thrown when enqueueing actionClient");
            SDebug.printStackTrace((Throwable)throwable);
        }
    }

    private clientId getClientId(String string) {
        String string2 = this.nmd.getCorbaHost();
        this._sior = this.getIor(this._ior, string2);
        clientId clientId2 = new clientId();
        clientId2.name = string;
        clientId2.locator = this._sior;
        if (this.db.on) {
            try {
                this.db.println("node           = " + string2);
                this.db.println("IorRepository  = " + this.nmd.getIorRepository().getNodeRootRef());
                this.db.println("EventRef       = " + this.nmd.getIorRepository().getEventRef());
                this.db.println("myself.name    = " + clientId2.name);
                this.db.println("myself.locator = " + clientId2.locator);
            }
            catch (IOException iOException) {
                this.db.println("failed to get the node root ref: " + iOException);
            }
        }
        return clientId2;
    }

    private boolean reregisterCMS(String string) throws UnsupportedEncodingException, UnknownHostException, UserException, NO_IMPLEMENT {
        java.lang.Object[] objectArray = new java.lang.Object[2];
        java.lang.Object[] objectArray2 = new java.lang.Object[2];
        if (this.db.on()) {
            this.db.println("calling reregisterCMS for node " + this.nmd.getHostName());
            this.db.println("lastUpdateSeqProcessed = " + this.lastUpdateSeqProcessed);
        }
        try {
            objectArray[0] = this.getClientId(string);
            objectArray[1] = new Integer((int)this.lastUpdateSeqProcessed);
            objectArray2 = (java.lang.Object[])this.reregister.get(objectArray);
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)nO_IMPLEMENT);
            }
            throw nO_IMPLEMENT;
        }
        catch (UserException userException) {
            this.db.println("Caught a CORBA.UserException in EventReceiver.registerCMS. This should not happen.");
            SDebug.printStackTrace((Throwable)userException);
            throw userException;
        }
        boolean bl = false;
        sObjectChange[] sObjectChangeArray = null;
        if (objectArray2 != null) {
            if (objectArray2[0] != null && objectArray2[0] instanceof Boolean && objectArray2[1] instanceof sObjectChange[]) {
                bl = (Boolean)objectArray2[0];
                if (this.db.on()) {
                    this.db.println("reregisterCMS:  valid = " + bl);
                }
                if ((sObjectChangeArray = (sObjectChange[])objectArray2[1]) == null) {
                    if (this.db.on()) {
                        this.db.println("Received list is null.");
                    }
                    return false;
                }
                if (sObjectChangeArray.length == 0) {
                    if (this.db.on()) {
                        this.db.println("Received list zero length");
                    }
                    return bl;
                }
                if ((long)sObjectChangeArray[0].objChangeSeq != this.lastUpdateSeqProcessed + 1L) {
                    bl = false;
                    if (this.db.on()) {
                        this.db.println("UpdateSeq mismatch, last seen = " + this.lastUpdateSeqProcessed + ", first in list = " + sObjectChangeArray[0].objChangeSeq + ", valid is now false");
                    }
                } else if (this.db.on()) {
                    this.db.println("Received list contains " + sObjectChangeArray.length + " items");
                    this.db.println("Received list seq number = {" + sObjectChangeArray[0].objChangeSeq + "," + sObjectChangeArray[sObjectChangeArray.length - 1].objChangeSeq + "}");
                }
            } else if (this.db.on()) {
                this.db.println("Return value is null or does not contain expected values");
            }
        } else if (this.db.on()) {
            this.db.println("Return value is null -- expected an array");
        }
        if (bl && sObjectChangeArray != null && sObjectChangeArray.length > 0) {
            ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.nmd.getElementAlarmStore();
            this.updateObjects(2130706433, sObjectChangeArray);
            elementAlarmStore.flushAlarmStore();
            elementAlarmStore.getPendingAlarms();
            ElementEventStore elementEventStore = (ElementEventStore)this.nmd.getElementEventStore();
            if (this.db.on()) {
                this.db.println("Event Receiver:  sending alarm store flush notification " + elementEventStore);
            }
            elementEventStore.sendReregisterNotification();
        }
        return bl;
    }

    public void registerCMS(String string) throws UnsupportedEncodingException, UnknownHostException {
        try {
            Long l = (Long)this.register.get(this.getClientId(string));
            this.lastUpdateSeqProcessed = l;
            if (this.db.on) {
                this.db.println("  sequence Num from NE = " + l);
            }
        }
        catch (UserException userException) {
            this.db.println("Caught a CORBA.UserException in EventReceiver.registerCMS. This should not happen.");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean isCMSRegistered(String string) {
        boolean bl;
        block15: {
            clientId clientId2 = new clientId();
            bl = false;
            clientId2.name = string;
            clientId2.locator = this._sior;
            try {
                bl = (Boolean)this.isRegistered.get(clientId2);
                if (bl) break block15;
                if (this.db.on()) {
                    this.db.println("isCMSRegistered: the call to isRegistered(myself) return false.");
                    this.db.println("Calling reregisterCMS(name)");
                }
                try {
                    bl = this.reregisterCMS(string);
                    if (!bl) {
                        if (this.db.on()) {
                            this.db.println("isCMSregistered: re-register failed");
                        }
                        this.unRegisterCMS(string);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (this.db.on()) {
                        this.db.println("isCMSRegistered: " + unsupportedEncodingException.toString());
                        SDebug.printStackTrace((Throwable)unsupportedEncodingException);
                    }
                    bl = false;
                }
                catch (UnknownHostException unknownHostException) {
                    if (this.db.on()) {
                        this.db.println("isCMSRegistered: " + unknownHostException.toString());
                        SDebug.printStackTrace((Throwable)unknownHostException);
                    }
                    bl = false;
                }
                catch (UserException userException) {
                    if (this.db.on()) {
                        this.db.println("isCMSRegistered: " + userException.toString());
                        SDebug.printStackTrace((Throwable)userException);
                    }
                    bl = false;
                }
                catch (NO_IMPLEMENT nO_IMPLEMENT) {
                    bl = false;
                }
            }
            catch (UserException userException) {
                if (this.db.on()) {
                    this.db.println("Caught a CORBA.UserException in EventReceiver.isCmsRegistered. This should not happen.");
                    SDebug.printStackTrace((Throwable)userException);
                }
                bl = false;
            }
        }
        if (!bl) {
            this.db.println("isCMSRegistered returning false");
        }
        return bl;
    }

    public void unRegisterCMS(String string) throws UnsupportedEncodingException, UnknownHostException {
        try {
            clientId clientId2 = new clientId();
            clientId2.name = string;
            clientId2.locator = this._sior;
            this._sior = null;
            this.unRegister.set(clientId2);
        }
        catch (UserException userException) {
            this.db.println("Caught a CORBA.UserException in EventReceiver.unRegisterCMS. This should not happen.");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose(): start");
        }
        this.disconnectFromORB();
        this.eventUtilities = null;
        this.alarmEventQueue.clear();
        this.alarmEventQueue = null;
        this.objectMessageQueue = null;
        this.lastUpdateSeqProcessed = 0L;
        this._set_delegate(null);
        this.nmd = null;
        this.db.dispose();
    }

    public POA _default_POA() {
        return this.getEventReceiverPOA();
    }

    private String getIor(String string, String string2) {
        String string3 = string;
        try {
            if (CtcHttpRetriever.useProxy()) {
                boolean bl = false;
                Ior ior = IorFactory.parse(string);
                for (int i = 0; i < ior.profiles(); ++i) {
                    IiopProfile iiopProfile;
                    CtcProxy ctcProxy;
                    if (!ior.profile(i).isIiop() || !(ctcProxy = CtcProxyFactory.accept((String)(iiopProfile = (IiopProfile)ior.profile(i).profile()).host(), (int)iiopProfile.port(), (String)string2)).isProxying()) continue;
                    if (this.db.on()) {
                        this.db.println("getIor(" + string2 + "): proxying " + ctcProxy.getHost() + ":" + ctcProxy.getPort() + "->" + iiopProfile.host() + ":" + iiopProfile.port());
                    }
                    bl = true;
                    iiopProfile.host(ctcProxy.getHost());
                    iiopProfile.port(ctcProxy.getPort());
                }
                if (bl) {
                    string3 = IorFactory.stringify(ior);
                } else if (this.db.on()) {
                    this.db.println("getIor(" + string2 + "): no proxy");
                }
            } else {
                String string4 = Preferences.instance().getProperty("ctc.proxy", "bindAddress", null);
                if (string4 != null) {
                    boolean bl = false;
                    Ior ior = IorFactory.parse(string);
                    for (int i = 0; i < ior.profiles(); ++i) {
                        IiopProfile iiopProfile;
                        if (!ior.profile(i).isIiop() || (iiopProfile = (IiopProfile)ior.profile(i).profile()).host().equals(string4)) continue;
                        if (this.db.on()) {
                            this.db.println("getIor(" + string2 + "): static " + string4 + ":" + iiopProfile.port() + "->" + iiopProfile.host() + ":" + iiopProfile.port());
                        }
                        bl = true;
                        iiopProfile.host(string4);
                    }
                    if (bl) {
                        string3 = IorFactory.stringify(ior);
                    } else if (this.db.on()) {
                        this.db.println("getIor(" + string2 + "): no change");
                    }
                }
            }
        }
        catch (Exception exception) {
            this.db.println("getIor() failed: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return string3;
    }

    private void connectToORB() throws CtcIncarnationException {
        try {
            this.getEventReceiverPOA().activate_object((Servant)this);
            this._ior = OngORB.instance().object_to_string((Object)this._this());
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            throw new CtcIncarnationException(servantAlreadyActive.toString());
        }
        catch (WrongPolicy wrongPolicy) {
            throw new CtcIncarnationException(wrongPolicy.toString());
        }
    }

    private void disconnectFromORB() throws CtcIncarnationException {
        this._sior = null;
        this._ior = null;
        try {
            POA pOA = this.getEventReceiverPOA();
            pOA.deactivate_object(pOA.servant_to_id((Servant)this));
        }
        catch (ObjectNotActive objectNotActive) {
            throw new CtcIncarnationException(objectNotActive.toString());
        }
        catch (WrongPolicy wrongPolicy) {
            throw new CtcIncarnationException(wrongPolicy.toString());
        }
        catch (ServantNotActive servantNotActive) {
            throw new CtcIncarnationException(servantNotActive.toString());
        }
    }

    private POA getEventReceiverPOA() {
        POA pOA;
        try {
            POA pOA2 = POAHelper.narrow((Object)OngORB.instance().resolve_initial_references("RootPOA"));
            pOA = pOA2.find_POA(EVENT_RECEIVER_POA_NAME, false);
        }
        catch (InvalidName invalidName) {
            throw new CtcIncarnationException(invalidName.toString());
        }
        catch (AdapterNonExistent adapterNonExistent) {
            pOA = this.createEventReceiverPOA();
        }
        return pOA;
    }

    private POA createEventReceiverPOA() {
        POA pOA;
        try {
            POA pOA2 = POAHelper.narrow((Object)OngORB.instance().resolve_initial_references("RootPOA"));
            POAManager pOAManager = pOA2.the_POAManager();
            Policy[] policyArray = new Policy[]{pOA2.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID), pOA2.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID), pOA2.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY), pOA2.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN), pOA2.create_lifespan_policy(LifespanPolicyValue.TRANSIENT)};
            pOA = pOA2.create_POA(EVENT_RECEIVER_POA_NAME, pOAManager, policyArray);
            pOAManager.activate();
        }
        catch (InvalidName invalidName) {
            throw new CtcIncarnationException(invalidName.toString());
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            throw new CtcIncarnationException(adapterAlreadyExists.toString());
        }
        catch (InvalidPolicy invalidPolicy) {
            throw new CtcIncarnationException(invalidPolicy.toString());
        }
        catch (AdapterInactive adapterInactive) {
            throw new CtcIncarnationException(adapterInactive.toString());
        }
        return pOA;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class UnRegister
    extends NonCachedValue {
        public UnRegister(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(java.lang.Object object) throws UserException {
            EventReceiver.this.nmd.getIorRepository().getEventRef().UnRegisterClient((clientId)object);
        }

        public java.lang.Object outer() {
            return EventReceiver.this;
        }
    }

    class IsRegistered
    extends NonCachedValue {
        public IsRegistered(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected java.lang.Object getValue(java.lang.Object object) throws UserException {
            return new Boolean(EventReceiver.this.nmd.getIorRepository().getEventRef().IsClientRegistered((clientId)object));
        }

        public java.lang.Object outer() {
            return EventReceiver.this;
        }
    }

    class Reregister
    extends NonCachedValue {
        public Reregister(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected java.lang.Object getValue(java.lang.Object object) throws UserException {
            java.lang.Object[] objectArray = (java.lang.Object[])object;
            java.lang.Object[] objectArray2 = new java.lang.Object[2];
            BooleanHolder booleanHolder = new BooleanHolder();
            sObjectChangesListHolder sObjectChangesListHolder2 = new sObjectChangesListHolder();
            EventReceiver.this.nmd.getIorRepository().getEventRef().registerCachingClient((clientId)objectArray[0], (Integer)objectArray[1], booleanHolder, sObjectChangesListHolder2);
            objectArray2[0] = new Boolean(booleanHolder.value);
            objectArray2[1] = sObjectChangesListHolder2.value;
            return objectArray2;
        }

        public java.lang.Object outer() {
            return EventReceiver.this;
        }
    }

    class Register
    extends NonCachedValue {
        public Register(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected java.lang.Object getValue(java.lang.Object object) throws UserException {
            return new Long(EventReceiver.this.nmd.getIorRepository().getEventRef().RegisterClient((clientId)object));
        }

        public java.lang.Object outer() {
            return EventReceiver.this;
        }
    }
}

