/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhTermModel;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;

public class LdccTermConnectionModel
extends AbstractTermConnectionModel {
    private static OhChannelType LDCC_TERM_CHANNEL = OhChannelType.LDCC_OBJ;
    private static OhChannelType LDCC_TUNNEL1_CHANNEL = OhChannelType.LDCC_TUNNEL1_OBJ;
    private static OhChannelType LDCC_TUNNEL2_CHANNEL = OhChannelType.LDCC_TUNNEL2_OBJ;
    private static OhChannelType LDCC_TUNNEL3_CHANNEL = OhChannelType.LDCC_TUNNEL3_OBJ;
    private static OhChannelType UDC_MS_CHANNEL = OhChannelType.UDC_MS_OBJ;
    private static ModelSingletonCollection dccConnectionModelSingletons;

    public static synchronized LdccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        LdccTermConnectionModel ldccTermConnectionModel;
        if (dccConnectionModelSingletons == null) {
            dccConnectionModelSingletons = ModelSingletonCollection.getMSCInstanceByName("LdccTermConnectionModel");
        }
        if ((ldccTermConnectionModel = (LdccTermConnectionModel)dccConnectionModelSingletons.get(nodeModelDelegate)) == null) {
            ldccTermConnectionModel = new LdccTermConnectionModel(nodeModelDelegate);
            dccConnectionModelSingletons.add(nodeModelDelegate, ldccTermConnectionModel);
        }
        return ldccTermConnectionModel;
    }

    private LdccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        LdccTermConnectionModel ldccTermConnectionModel = (LdccTermConnectionModel)nodeModelDelegate.getLdccTermConnectionModel();
        ldccTermConnectionModel.init();
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    public IEntityModel[] getTermCandidates() {
        Set set;
        HashSet<EntityModel> hashSet = new HashSet<EntityModel>();
        if (this.elementModels == null) {
            this.elementModels = this.nmd.getElementModelsDelegate();
        }
        Set set2 = this.getNonTransparentTermDwdmEntities();
        set2.removeAll(this.otnEnabledPorts(this.dwdmTrunkPorts(set2)));
        IFramingType iFramingType = FramingType.getFramingType((int)this.nmd.getFramingType());
        if (iFramingType.isSonet()) {
            set = this.elementModels.getNonProtectOpticalEntities();
            set.addAll(set2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    EntityModel entityModel = (EntityModel)iterator.next();
                    if (entityModel.getMediumType() != 1) continue;
                    if (this.db.on()) {
                        this.db.println("Found a Sonet port " + entityModel + " adding ...");
                    }
                    hashSet.add(entityModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        } else {
            hashSet.addAll(this.elementModels.getNonProtectOpticalEntities());
            hashSet.addAll(set2);
        }
        hashSet.removeAll(this.ocmd.getUsedOpticalPorts(LDCC_TERM_CHANNEL));
        hashSet.removeAll(this.ocmd.getUsedOpticalPorts(LDCC_TUNNEL1_CHANNEL));
        hashSet.removeAll(this.ocmd.getUsedOpticalPorts(LDCC_TUNNEL2_CHANNEL));
        hashSet.removeAll(this.ocmd.getUsedOpticalPorts(LDCC_TUNNEL3_CHANNEL));
        hashSet.removeAll(this.ocmd.getUsedOpticalPorts(UDC_MS_CHANNEL));
        hashSet.removeAll(this.getNotSupportedTdmPorts(hashSet));
        hashSet.removeAll(this.elementModels.getBlsrEntities());
        set = this.excludeUcpTerms(hashSet);
        return set.toArray(new IEntityModel[0]);
    }

    protected String getTypeName() {
        return "LDCC";
    }

    protected OhChannelType getChannelType(Object object) {
        return LDCC_TERM_CHANNEL;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return !this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addModels() {
        if (this.db.on()) {
            this.db.fine("add Models");
        }
        HashSet hashSet = new HashSet(this.ocmd.getOhTerms().getLdccTermModels());
        Object object = this.terms;
        synchronized (object) {
            hashSet.removeAll(this.terms);
        }
        if (this.db.on()) {
            this.db.fine("find " + hashSet.size() + " new DCC Terms");
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            OhTermModel ohTermModel = (OhTermModel)object.next();
            if (!this.termQualifies(ohTermModel)) continue;
            HashSet hashSet2 = this.terms;
            synchronized (hashSet2) {
                this.observableManager.addObservable((Observable)((Object)ohTermModel));
                this.terms.add(ohTermModel);
            }
            if (!this.db.on()) continue;
            this.db.println("Add new model - " + ohTermModel);
        }
    }

    private Set getNotSupportedTdmPorts(Set set) {
        HashSet<ITdmPortModel> hashSet = new HashSet<ITdmPortModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ITdmPortModel iTdmPortModel;
            ITdmLineModel iTdmLineModel;
            Object e = iterator.next();
            if (!(e instanceof ITdmPortModel) || (iTdmLineModel = (iTdmPortModel = (ITdmPortModel)e).getITdmLineModel()).supportsOhChannel(4)) continue;
            hashSet.add(iTdmPortModel);
        }
        return hashSet;
    }
}

