/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IModelPersistenceConstants;
import cerent.cms.model.IModelPersistenceStrategy;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NoOpModelPersistenceStrategy;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PersistenceException;
import cerent.cms.model.ReflectionUtil;
import cerent.cms.model.persistence.CORBAStreamer;
import cerent.util.EncryptionException;
import cerent.util.IDecrypter;
import cerent.util.PBEEncrypter;
import cerent.util.Preferences;
import cerent.util.SDebug;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class ModelPersistenceStrategyFactory
implements IModelPersistenceConstants {
    protected static Class[] argTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ModelPersistenceStrategyFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ModelPersistenceStrategyFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ModelPersistenceStrategyFactory.class$("java.lang.String")) : class$java$lang$String};
    private static IDecrypter decrypter = null;
    private static String DefaultSaltPhrase = "amaravenkata";
    private static String DefaultSecret = "koithan";
    private static String className = Preferences.instance().getProperty("ctc.model.persist", "class", "cerent.cms.model.persistence.StateDAO");
    private static String dbName = Preferences.instance().getProperty("ctc.model.persist", "db", null);
    private static String user = Preferences.instance().getProperty("ctc.model.persist", "user", null);
    private static String _password = Preferences.instance().getProperty("ctc.model.persist", "password", null);
    private static String dataSourceFactoryClass = Preferences.instance().getProperty("ctc.model.persist", "datasourcefactoryclass", "");
    private static boolean passwordEncrypted = Preferences.instance().getBoolean("ctc.model.persist", "password.encrypted", false);
    private static String password = ModelPersistenceStrategyFactory.getPlaintext(_password);
    private static final String getDataSourceMethod = "getDataSource";
    private static final Class[] getDataSourceMethodArgs = new Class[]{class$cerent$cms$model$INodeModel == null ? (class$cerent$cms$model$INodeModel = ModelPersistenceStrategyFactory.class$("cerent.cms.model.INodeModel")) : class$cerent$cms$model$INodeModel};
    protected static final ModelPersistenceStrategyFactory inst = new ModelPersistenceStrategyFactory();
    private static IModelPersistenceStrategy strategy = null;
    private static ModelSingletonCollection PersistenceSingletons;
    protected static SDebug db;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$cerent$cms$model$INodeModel;
    static /* synthetic */ Class class$cerent$cms$model$InterfaceModel;
    static /* synthetic */ Class class$cerent$util$SDebug;
    static /* synthetic */ Class class$cerent$cms$model$ModelPersistenceStrategyFactory;

    protected ModelPersistenceStrategyFactory() {
    }

    public static ModelPersistenceStrategyFactory instance() {
        return inst;
    }

    public IModelPersistenceStrategy createStrategy(NodeModelDelegate nodeModelDelegate, Class clazz) {
        return ModelPersistenceStrategyFactory._createStrategy(nodeModelDelegate, clazz);
    }

    private static IModelPersistenceStrategy _createStrategy(NodeModelDelegate nodeModelDelegate, Class clazz) {
        if (strategy != null) {
            return strategy;
        }
        IModelPersistenceStrategy iModelPersistenceStrategy = null;
        if (db.on()) {
            db.println("persist strategy db enable: " + IModelPersistenceConstants.ENABLE_PERSISTENCE);
            if (IModelPersistenceConstants.ENABLE_PERSISTENCE) {
                db.println("persist strategy className: " + className);
                db.println("persist strategy db: " + dbName);
                db.println("persist strategy user: " + user);
                db.println("persist strategy password: " + password);
            }
        }
        iModelPersistenceStrategy = ModelPersistenceStrategyFactory.getInstance(nodeModelDelegate, clazz);
        if (db.on()) {
            db.println("actual persist strategy class: " + iModelPersistenceStrategy.getClass().getName());
        }
        strategy = iModelPersistenceStrategy;
        return strategy;
    }

    private static synchronized IModelPersistenceStrategy getInstance(NodeModelDelegate nodeModelDelegate, Class clazz) {
        IModelPersistenceStrategy iModelPersistenceStrategy;
        block10: {
            if (PersistenceSingletons == null) {
                PersistenceSingletons = ModelSingletonCollection.getMSCInstanceByName("ModelPersistenceStrategy");
            }
            if ((iModelPersistenceStrategy = (IModelPersistenceStrategy)PersistenceSingletons.get(nodeModelDelegate)) == null && IModelPersistenceConstants.ENABLE_PERSISTENCE && className != null && dbName != null && user != null && password != null) {
                try {
                    Class clazz2 = ReflectionUtil.forName(className);
                    Constructor constructor = clazz2.getConstructor(argTypes);
                    if (constructor == null) break block10;
                    Object t = constructor.newInstance(dbName, user, password);
                    if (t instanceof IModelPersistenceStrategy) {
                        ModelPersistenceStrategyFactory.setDebug((IModelPersistenceStrategy)t, nodeModelDelegate);
                        PersistenceSingletons.add(nodeModelDelegate, iModelPersistenceStrategy);
                        if (!ReflectionUtil.doesExtend((Class)clazz, (Class)(class$cerent$cms$model$InterfaceModel == null ? (class$cerent$cms$model$InterfaceModel = ModelPersistenceStrategyFactory.class$("cerent.cms.model.InterfaceModel")) : class$cerent$cms$model$InterfaceModel))) {
                            throw new PersistenceException("don't know how to persist state of instances of type: " + clazz.getName(), null);
                        }
                        CORBAStreamer cORBAStreamer = CORBAStreamer.instance();
                        iModelPersistenceStrategy = (IModelPersistenceStrategy)t;
                        Object object = null;
                        try {
                            object = ModelPersistenceStrategyFactory.determineExternalDataSource(nodeModelDelegate);
                        }
                        catch (Exception exception) {
                            System.out.println("external data source creation error: " + exception);
                            exception.printStackTrace(System.out);
                        }
                        iModelPersistenceStrategy.init(cORBAStreamer, object);
                    }
                    if (db.on()) {
                        db.println("persist strategy className: " + className + " class does NOT implement the IModelPersistenceStrategy interface");
                    }
                }
                catch (Exception exception) {
                    iModelPersistenceStrategy = null;
                    System.out.println("persistence error (e.g. can't load DB driver)");
                    exception.printStackTrace(System.out);
                    System.out.println("...make sure the appropriate database JDBC driver is in your classpath");
                    System.out.println("falling back to all state in-memory mode");
                }
            }
        }
        if (iModelPersistenceStrategy == null) {
            iModelPersistenceStrategy = NoOpModelPersistenceStrategy.newInstance();
            PersistenceSingletons.add(nodeModelDelegate, iModelPersistenceStrategy);
        }
        return iModelPersistenceStrategy;
    }

    private static Object determineExternalDataSource(NodeModelDelegate nodeModelDelegate) throws Exception {
        Object object = null;
        if (dataSourceFactoryClass != null && dataSourceFactoryClass.length() > 0) {
            Class<?> clazz = Class.forName(dataSourceFactoryClass);
            Method method = clazz.getMethod(getDataSourceMethod, getDataSourceMethodArgs);
            object = method.invoke(null, nodeModelDelegate);
        }
        return object;
    }

    private static void setDebug(IModelPersistenceStrategy iModelPersistenceStrategy, NodeModelDelegate nodeModelDelegate) {
        Class<?> clazz = iModelPersistenceStrategy.getClass();
        Class clazz2 = ModelPersistenceStrategyFactory.findDebugClass(clazz);
        if (clazz2 != null) {
            try {
                iModelPersistenceStrategy.setDebug(nodeModelDelegate.getChildDebug(clazz, clazz2, iModelPersistenceStrategy));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Class findDebugClass(Class clazz) {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            if (!ReflectionUtil.doesExtend(clazz2, (Class)(class$cerent$util$SDebug == null ? ModelPersistenceStrategyFactory.class$("cerent.util.SDebug") : class$cerent$util$SDebug))) continue;
            return clazz2;
        }
        return null;
    }

    private static synchronized String getPlaintext(String string) {
        String string2 = string;
        if (passwordEncrypted) {
            try {
                if (decrypter == null) {
                    decrypter = new PBEEncrypter(DefaultSaltPhrase, DefaultSecret);
                }
                string2 = decrypter.decrypt(string);
            }
            catch (EncryptionException encryptionException) {
                SDebug.printStackTrace((Throwable)encryptionException);
            }
        }
        return string2;
    }

    public static synchronized void setDecrypter(IDecrypter iDecrypter) {
        decrypter = iDecrypter;
        if (decrypter == null) {
            password = _password;
        } else {
            try {
                password = decrypter.decrypt(password);
            }
            catch (EncryptionException encryptionException) {
                SDebug.printStackTrace((Throwable)encryptionException);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("usage: " + (class$cerent$cms$model$ModelPersistenceStrategyFactory == null ? (class$cerent$cms$model$ModelPersistenceStrategyFactory = ModelPersistenceStrategyFactory.class$("cerent.cms.model.ModelPersistenceStrategyFactory")) : class$cerent$cms$model$ModelPersistenceStrategyFactory).getName() + " <db password>");
            return;
        }
        try {
            PBEEncrypter pBEEncrypter = new PBEEncrypter(DefaultSaltPhrase, DefaultSecret);
            System.out.println("encrypted: " + pBEEncrypter.encrypt(stringArray[stringArray.length - 1]));
        }
        catch (EncryptionException encryptionException) {
            encryptionException.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        db = new SDebug("ModelPersistenceStrategyFactory");
    }
}

