/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.xCouldNotGenerateUniqueId;
import cerent.cms.idl.Circuits.xIdAlreadyPresent;
import cerent.cms.idl.Circuits.xInvalidCircuitInfoParameters;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.OverheadCircuits.OverheadCircuitFactory;
import cerent.cms.idl.OverheadCircuits.OverheadCircuitInfo;
import cerent.cms.idl.OverheadCircuits.sOverheadCircuitInfo;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.CouldNotGenerateUniqueId;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitFactoryModel;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.IdAlreadyPresent;
import cerent.cms.model.InvalidCircuitInfoParameters;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhCircuitInfoFactory;
import cerent.cms.model.OhCircuitModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OhCircuitFactoryModelDelegate
extends Model
implements IOhCircuitFactoryModel {
    private CreateCircuit createCircuit;
    private CircuitList circuitList;
    private NodeModelDelegate node;
    private EventDispatcher dispatcher;
    private Map circuitMap;
    private static ModelSingletonCollection ohCircuitFactoryModelDelegateSingletons;
    private static final String CF_DEBUG_KEY = "OhCircuitFactoryModelDelegate";
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;

    public static synchronized OhCircuitFactoryModelDelegate getInstance(NodeModelDelegate nodeModelDelegate) {
        OhCircuitFactoryModelDelegate ohCircuitFactoryModelDelegate;
        if (ohCircuitFactoryModelDelegateSingletons == null) {
            ohCircuitFactoryModelDelegateSingletons = ModelSingletonCollection.getMSCInstanceByName(CF_DEBUG_KEY);
        }
        if ((ohCircuitFactoryModelDelegate = (OhCircuitFactoryModelDelegate)ohCircuitFactoryModelDelegateSingletons.get(nodeModelDelegate)) == null) {
            ohCircuitFactoryModelDelegate = new OhCircuitFactoryModelDelegate(nodeModelDelegate);
            ohCircuitFactoryModelDelegateSingletons.add(nodeModelDelegate, ohCircuitFactoryModelDelegate);
        }
        return ohCircuitFactoryModelDelegate;
    }

    private OhCircuitFactoryModelDelegate(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.node = nodeModelDelegate;
        this.index = 0;
        this.createCircuit = new CreateCircuit("OhCircuitFactoryModelDelegate.createCircuit");
        this.circuitList = new CircuitList("OhCircuitFactoryModelDelegate.circuitList");
        this.circuitMap = Collections.synchronizedMap(new HashMap());
        if (this.db == null) {
            this.db = new CfDebug(nodeModelDelegate.db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.db.on()) {
            this.db.finer("OhCircuitFactoryModelDelegate::init");
        }
        super.init0();
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectOverheadCircuitList, 0, (Observer)this);
        }
        Map map = this.circuitMap;
        synchronized (map) {
            this.circuitMap.putAll(this.discoverCircuits());
            this.initializeCircuits();
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    private OhCircuitModel getCircuitById(ICircuitId iCircuitId) {
        return (OhCircuitModel)this.circuitMap.get(new Integer(iCircuitId.getUniquePart().getUniqueId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOhCircuitModel add(IOhCircuitModel iOhCircuitModel) {
        OhCircuitModel ohCircuitModel = null;
        Map map = this.circuitMap;
        synchronized (map) {
            ohCircuitModel = this.getCircuitById(iOhCircuitModel.getId());
            if (ohCircuitModel != null) {
                return ohCircuitModel;
            }
            ohCircuitModel = (OhCircuitModel)iOhCircuitModel;
            ohCircuitModel.init();
            this.circuitMap.put(new Integer(ohCircuitModel.getUniquePart()), ohCircuitModel);
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
        return ohCircuitModel;
    }

    private Map discoverCircuits() {
        try {
            return (Map)this.circuitList.get();
        }
        catch (UserException userException) {
            this.db.warning("UserException caught in OhCircuitFactoryModelDelegate::discoverCircuits");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCircuits() {
        Map map = this.circuitMap;
        synchronized (map) {
            Iterator iterator = this.circuitMap.values().iterator();
            while (iterator.hasNext()) {
                OhCircuitModel ohCircuitModel = (OhCircuitModel)iterator.next();
                ohCircuitModel.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.db.on()) {
            this.db.finer("OhCircuitFactoryModelDelegate::dispose");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOverheadCircuitList, 0, (Observer)this);
        }
        Map map = this.circuitMap;
        synchronized (map) {
            Iterator iterator = this.circuitMap.values().iterator();
            while (iterator.hasNext()) {
                OhCircuitModel ohCircuitModel = (OhCircuitModel)iterator.next();
                try {
                    ohCircuitModel.destroy();
                }
                catch (Exception exception) {
                    this.db.warning("Exception while destroying circuits" + exception);
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            this.circuitMap.clear();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStructure() {
        HashMap hashMap = new HashMap();
        boolean bl = false;
        if (this.db.on()) {
            this.db.fine("Update Structure Called ");
        }
        Map map = this.circuitMap;
        synchronized (map) {
            hashMap.putAll(this.discoverCircuits());
            if (this.db.on()) {
                this.db.fine("Size of new Circuits " + hashMap.size());
            }
            Map map2 = this.getAddedObjects(hashMap, this.circuitMap);
            if (this.db.on()) {
                this.db.fine("No. of added ckts " + map2.size());
            }
            Iterator iterator = map2.values().iterator();
            while (iterator.hasNext()) {
                OhCircuitModel ohCircuitModel = (OhCircuitModel)iterator.next();
                if (this.db.on()) {
                    this.db.fine("Adding new CircuitInfo " + ohCircuitModel);
                }
                ohCircuitModel.init();
                bl = true;
            }
            this.circuitMap.putAll(map2);
        }
        if (bl) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
    }

    public INodeModel getNodeModel() {
        if (this.db.on()) {
            this.db.finer("OhCircuitFactoryModelDelegate::getNodeModel");
        }
        return this.getNodeModelDelegate();
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOhCircuitModel[] getOhCircuits() {
        Map map = this.circuitMap;
        synchronized (map) {
            return this.circuitMap.values().toArray(new OhCircuitModel[0]);
        }
    }

    public IOhCircuitModel createOhCircuit(IOhCircuitInfo iOhCircuitInfo) throws InvalidCircuitInfoParameters, CouldNotGenerateUniqueId, IdAlreadyPresent {
        IOhCircuitModel iOhCircuitModel = null;
        if (this.db.on()) {
            this.db.fine("OhCircuitFactoryModelDelegate::createCircuit");
        }
        try {
            IOhCircuitModel iOhCircuitModel2 = (IOhCircuitModel)this.createCircuit.get(iOhCircuitInfo);
            iOhCircuitModel = this.add(iOhCircuitModel2);
        }
        catch (xInvalidCircuitInfoParameters xInvalidCircuitInfoParameters2) {
            throw new InvalidCircuitInfoParameters((UserException)xInvalidCircuitInfoParameters2);
        }
        catch (xCouldNotGenerateUniqueId xCouldNotGenerateUniqueId2) {
            throw new CouldNotGenerateUniqueId((UserException)xCouldNotGenerateUniqueId2);
        }
        catch (xIdAlreadyPresent xIdAlreadyPresent2) {
            throw new IdAlreadyPresent((UserException)xIdAlreadyPresent2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            this.db.warning("UserException caught in OhCircuitFactoryModelDelegate::createCircuit");
            SDebug.printStackTrace((Throwable)userException);
        }
        return iOhCircuitModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainee(Object object, boolean bl) {
        Map map = this.circuitMap;
        synchronized (map) {
            int n = ((OhCircuitModel)object).getUniquePart();
            this.circuitMap.remove(new Integer(n));
        }
        if (bl) {
            this.updateStructure();
        }
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.fine("OhCircuitFactoryModelDelegate::update");
        }
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.info("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = OhCircuitFactoryModelDelegate.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType))[n]);
            }
            switch (n) {
                case 2: {
                    if (this.db.on()) {
                        this.db.info("Making structural changes.");
                    }
                    this.updateStructure();
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.warning("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    protected Map getAddedObjects(Map map, Map map2) {
        HashMap hashMap = new HashMap(map);
        hashMap.keySet().removeAll(map2.keySet());
        return hashMap;
    }

    protected Map getDeletedObjects(Map map, Map map2) {
        HashMap hashMap = new HashMap(map2);
        hashMap.keySet().removeAll(map.keySet());
        return hashMap;
    }

    public String toString() {
        return "OhCircuitFactory";
    }

    private OverheadCircuitFactory getOhCircuitFactoryRef() {
        return this.getNodeModelDelegate().getIorRepository().getOhCircuitFactoryRef();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class CfDebug
    extends SDebug {
        CfDebug(KDebug kDebug) {
            super(kDebug, OhCircuitFactoryModelDelegate.CF_DEBUG_KEY);
        }

        public final void update() {
            OhCircuitFactoryModelDelegate.this.updateStructure();
        }

        public final void dumpCircuits() {
            Iterator iterator = OhCircuitFactoryModelDelegate.this.circuitMap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    this.println("============================================");
                    OhCircuitModel ohCircuitModel = (OhCircuitModel)iterator.next();
                    ohCircuitModel.printString(this);
                }
                catch (Exception exception) {
                    this.println("Caught exception " + exception);
                    CfDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private class CircuitList
    extends NonCachedValue {
        public CircuitList(String string) {
            super(OhCircuitFactoryModelDelegate.this.node, string);
        }

        protected Object getValue() throws UserException {
            OverheadCircuitInfo[] overheadCircuitInfoArray = OhCircuitFactoryModelDelegate.this.getOhCircuitFactoryRef().getAllCircuitInfos();
            HashMap<Integer, OhCircuitModel> hashMap = new HashMap<Integer, OhCircuitModel>(overheadCircuitInfoArray.length);
            for (int i = 0; i < overheadCircuitInfoArray.length; ++i) {
                OhCircuitModel ohCircuitModel = new OhCircuitModel(OhCircuitFactoryModelDelegate.this.getNodeModelDelegate(), overheadCircuitInfoArray[i]);
                hashMap.put(new Integer(ohCircuitModel.getUniquePart()), ohCircuitModel);
            }
            return hashMap;
        }
    }

    private class CreateCircuit
    extends NonCachedValue {
        public CreateCircuit(String string) {
            super(OhCircuitFactoryModelDelegate.this.node, string);
        }

        protected Object getValue(Object object) throws UserException {
            sOverheadCircuitInfo sOverheadCircuitInfo2 = OhCircuitInfoFactory.getOhCircuitInfo((IOhCircuitInfo)object);
            OverheadCircuitInfo overheadCircuitInfo = OhCircuitFactoryModelDelegate.this.getOhCircuitFactoryRef().createOverheadCircuit(sOverheadCircuitInfo2);
            return new OhCircuitModel(OhCircuitFactoryModelDelegate.this.getNodeModelDelegate(), overheadCircuitInfo);
        }
    }
}

