/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.xErrorWritingToDb;
import cerent.cms.idl.Circuits.xInvalidCircuitName;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.OverheadCircuits.OverheadCircuitInfo;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ErrorWritingToDb;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhCircuitEndFactory;
import cerent.cms.model.OhCircuitFactoryModelDelegate;
import cerent.cms.model.OhCircuitInfoFactory;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class OhCircuitModel
extends Model
implements IOhCircuitModel {
    private Id id;
    private Info info;
    private Rename rename;
    private AddDestination addDestination;
    private DeleteDestination deleteDestination;
    private Delete delete;
    private int uniqueId = -1;
    private NodeModelDelegate node;
    private EventDispatcher dispatcher;
    private OverheadCircuitInfo circuitRef;
    private String myString;
    static /* synthetic */ Class class$cerent$cms$model$OhCircuitModel;
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;

    public OhCircuitModel(NodeModelDelegate nodeModelDelegate, OverheadCircuitInfo overheadCircuitInfo) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$OhCircuitModel == null ? (class$cerent$cms$model$OhCircuitModel = OhCircuitModel.class$("cerent.cms.model.OhCircuitModel")) : class$cerent$cms$model$OhCircuitModel));
        this.node = nodeModelDelegate;
        this.circuitRef = overheadCircuitInfo;
        this.id = new Id("OhCircuitModel.id", nodeModelDelegate);
        this.info = new Info("OhCircuitModel.info", nodeModelDelegate);
        this.rename = new Rename("OhCircuitModel.setName", nodeModelDelegate);
        this.addDestination = new AddDestination("OhCircuitModel.addDestination", nodeModelDelegate);
        this.deleteDestination = new DeleteDestination("OhCircuitModel.deleteDestination", nodeModelDelegate);
        this.delete = new Delete("OhCircuitModel.delete", nodeModelDelegate);
        this.myString = null;
    }

    public void init() {
        this.dispatcher = this.getNodeModelDelegate().getDispatcher();
        if (this.dispatcher != null) {
            if (this.db.on()) {
                this.db.fine("OhCircuitModel::init() for : " + this.getName() + " on ID=" + this.uniqueId);
            }
            this.dispatcher.addObserver(ObjectType.ObjectOverheadCircuit, this.getUniquePart(), (Observer)this);
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectOverheadCircuit, this.getUniquePart(), (Observer)this);
        }
        this.info.dispose();
        this.id.dispose();
        this.myString = null;
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.fine("OhCircuitModel::destroy()");
        }
        super.destroy();
    }

    public INodeModel getNodeModel() {
        return this.getNodeModelDelegate();
    }

    protected NodeModelDelegate getNodeModelDelegate() {
        return this.node;
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.fine("OhCircuitModel::update()");
        }
        this.myString = null;
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.info("update(): this=" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = OhCircuitModel.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType))[n]);
            }
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.info("Object deleted.");
                    }
                    try {
                        ((OhCircuitFactoryModelDelegate)this.getNodeModelDelegate().getOhCircuitFactoryModel()).removeContainee(this, false);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        this.db.warning("Caught exception " + (Object)((Object)abstractCmsIOException) + " during delete");
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    this.destroy();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.info("Making local changes.");
                    }
                    this.id.update();
                    this.info.update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.warning("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            if (object instanceof OhCircuitModel) {
                return this.getUniquePart() == ((OhCircuitModel)object).getUniquePart();
            }
            return false;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.warning("Caught AbstractCmsIOException in OhCircuitModel::equals");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return false;
        }
    }

    public int hashCode() {
        return this.getUniquePart();
    }

    private IOhCircuitInfo getInfo() {
        try {
            return (IOhCircuitInfo)this.info.get();
        }
        catch (UserException userException) {
            this.db.severe("Caught UserException in OhCircuitModel::getInfo");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IOhCircuitEnd getSrcPoint() {
        return this.getInfo().getSrcPoint();
    }

    public IOhCircuitEnd[] getDestPoints() {
        return this.getInfo().getDestPoints();
    }

    public Integer getKey() {
        return new Integer(this.getId().getUniquePart().getUniqueId());
    }

    public int getCircuitType() {
        return this.getInfo().getCircuitType();
    }

    public String getName() {
        return this.getInfo().getCircuitName();
    }

    public void setName(String string) throws InvalidCircuitName {
        try {
            this.rename.set(string);
        }
        catch (xInvalidCircuitName xInvalidCircuitName2) {
            throw new InvalidCircuitName((UserException)xInvalidCircuitName2);
        }
        catch (UserException userException) {
            this.db.severe("UserException caught in OhCircuitModel::setName");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public ICircuitId getId() {
        try {
            return (ICircuitId)this.id.get();
        }
        catch (UserException userException) {
            this.db.severe("UserException caught in OhCircuitModel::getId");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getNodeId() {
        return this.getId().getNodeId();
    }

    public int getUniquePart() {
        if (this.uniqueId == -1) {
            this.uniqueId = this.getId().getUniquePart().getUniqueId();
        }
        return this.uniqueId;
    }

    public void addDestination(IOhCircuitEnd iOhCircuitEnd) {
        try {
            this.addDestination.set(iOhCircuitEnd);
            this.info.update();
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
        catch (UserException userException) {
            this.db.severe("UserException caught in OhCircuitModel::addDrop");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void delDestination(IOhCircuitEnd iOhCircuitEnd) {
        try {
            this.deleteDestination.set(iOhCircuitEnd);
            this.info.update();
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
        catch (UserException userException) {
            this.db.severe("UserException caught in OhCircuitModel::delDrop");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void delete() throws ErrorWritingToDb {
        try {
            this.delete.set();
        }
        catch (xErrorWritingToDb xErrorWritingToDb2) {
            throw new ErrorWritingToDb((UserException)xErrorWritingToDb2);
        }
        catch (UserException userException) {
            this.db.severe("UserException caught in OhCircuitModel::delete");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    protected void printString(KDebug kDebug) {
        kDebug.fine("OhCircuitModel info ");
        kDebug.fine("Circuit Name " + this.getName());
        kDebug.fine("Observers are :");
        this.printObservers();
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "Circuit[nodeId=" + Integer.toHexString(this.getNodeId()) + ", uniquePart=" + this.getUniquePart() + ",  name=" + this.getName() + "]";
            }
            catch (Exception exception) {
                return "Circuit[deleted/inaccessible]";
            }
        }
        return this.myString;
    }

    private OverheadCircuitInfo getOhCircuitRef() {
        return this.circuitRef;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Delete
    extends NonCachedValue {
        public Delete(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            OhCircuitModel.this.getOhCircuitRef().deleteCircuit();
        }
    }

    class DeleteDestination
    extends NonCachedValue {
        public DeleteDestination(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            OhCircuitModel.this.getOhCircuitRef().delDestination(OhCircuitEndFactory.getOhCircuitEnd((IOhCircuitEnd)object));
        }
    }

    class AddDestination
    extends NonCachedValue {
        public AddDestination(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            OhCircuitModel.this.getOhCircuitRef().addDestination(OhCircuitEndFactory.getOhCircuitEnd((IOhCircuitEnd)object));
        }
    }

    class Rename
    extends NonCachedValue {
        public Rename(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            OhCircuitModel.this.getOhCircuitRef().renameOverheadCircuit((String)object);
        }
    }

    class Info
    extends CachedValue {
        public Info(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return OhCircuitInfoFactory.getIOhCircuitInfo(OhCircuitModel.this.getOhCircuitRef().cktInfo());
        }
    }

    private class Id
    extends CachedValue {
        public Id(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return CircuitIdFactory.getICircuitId(OhCircuitModel.this.getOhCircuitRef().circuitId());
        }
    }
}

