/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.AmplifiedOpticalLine;
import cerent.cms.idl.Optics.eOpticalAmplifierControlMode;
import cerent.cms.idl.Optics.sActualOpticalLineAmplifierAttributes;
import cerent.cms.idl.Optics.sOpticalLineAmplifierAttributes;
import cerent.cms.idl.Optics.xProvisioningError;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import org.omg.CORBA.UserException;

public class OpticsAmplifiedLineModel
extends AbstractOpticsLineModel {
    private AmplifiedOpticalLine amplifiedOpticalLine;
    private TiltCalibration tiltCal;
    private AmplifierAttributes ampAttributes;
    private ActualAmplifierAttributes ampActualAttributes;
    private GainSetPoint gainSetPoint;
    private ChnPower chnPower;
    private static final SDebug db = new SDebug("OpticsAmplifiedLineModel");

    protected OpticsAmplifiedLineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public OpticsAmplifiedLineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2, nodeModelDelegate.getIorRepository().getOpticsAmpliRef(), db);
        this.amplifiedOpticalLine = nodeModelDelegate.getIorRepository().getOpticsAmpliRef();
        this.tiltCal = new TiltCalibration(nodeModelDelegate, "TiltCalibration");
        this.ampAttributes = new AmplifierAttributes(nodeModelDelegate, "AmplifierAttributes");
        this.ampActualAttributes = new ActualAmplifierAttributes(nodeModelDelegate, "ActualAmplifierAttributes");
        this.gainSetPoint = new GainSetPoint(nodeModelDelegate, "GainSetPoint");
        this.chnPower = new ChnPower(nodeModelDelegate, "ChnPower");
    }

    public void destroy() {
        super.destroy();
    }

    public void dispose() {
        this.ampAttributes.dispose();
        super.dispose();
    }

    protected void updateLocal(long l) {
        this.ampAttributes.update();
        super.updateLocal(l);
    }

    public void setAttributes(sOpticalLineAmplifierAttributes sOpticalLineAmplifierAttributes2, long l) {
        this.ampAttributes.setValueExternally(sOpticalLineAmplifierAttributes2);
        super.setAttributes(sOpticalLineAmplifierAttributes2.general.base, l);
    }

    public int getGainSetPoint() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticalLineAmplifierAttributes)this.ampAttributes.get()).gainSetPoint;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GET_GAINSETPOINT), userException);
        }
    }

    public eOpticalAmplifierControlMode getControlMode() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticalLineAmplifierAttributes)this.ampAttributes.get()).controlMode;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GET_CONTROLMODE), userException);
        }
    }

    public void setTiltCalibration(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError, InternalCommError {
        try {
            this.tiltCal.set(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_SET_TILTCALIB), userException);
        }
    }

    public void setGainSetPoint(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError, InternalCommError {
        try {
            this.gainSetPoint.set(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_SET_GAINSETPOINT), userException);
        }
    }

    public void setChnPower(int n) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError, InternalCommError {
        try {
            this.chnPower.set(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_SET_GAINSETPOINT), userException);
        }
    }

    public int getCalibratedTilt() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticalLineAmplifierAttributes)this.ampAttributes.get()).calibratedTilt;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GET_CONTROLMODE), userException);
        }
    }

    public int getReferenceTilt() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticalLineAmplifierAttributes)this.ampAttributes.get()).referenceTilt;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GET_CONTROLMODE), userException);
        }
    }

    public int getChnPowerRef() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sOpticalLineAmplifierAttributes)this.ampAttributes.get()).perChPowerReference;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GET_CONTROLMODE), userException);
        }
    }

    public int getGain() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            return ((sActualOpticalLineAmplifierAttributes)this.ampActualAttributes.get()).gain;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GET_CONTROLMODE), userException);
        }
    }

    public int getAsePower() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            return ((sActualOpticalLineAmplifierAttributes)this.ampActualAttributes.get()).compAsePower;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GET_CONTROLMODE), userException);
        }
    }

    public int getDCULoss() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            return ((sActualOpticalLineAmplifierAttributes)this.ampActualAttributes.get()).dcuLoss;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown(ErrorMsg.getString((EID)EMC.EID_EXCEPTION_GET_CONTROLMODE), userException);
        }
    }

    public String toString() {
        return "OpticsAmplifiedLineModel" + super.toString();
    }

    private class ActualAmplifierAttributes
    extends NonCachedValue {
        private ActualAmplifierAttributes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OpticsAmplifiedLineModel.this.amplifiedOpticalLine.getActualAmplifierOpticsAttributes(OpticsAmplifiedLineModel.this.getIndex());
        }
    }

    private class AmplifierAttributes
    extends CachedValue {
        private AmplifierAttributes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return OpticsAmplifiedLineModel.this.amplifiedOpticalLine.getOpticsAttributes(OpticsAmplifiedLineModel.this.getIndex());
        }
    }

    private class ChnPower
    extends NonCachedValue {
        public ChnPower(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            OpticsAmplifiedLineModel.this.amplifiedOpticalLine.setGainSetPoint(OpticsAmplifiedLineModel.this.getIndex(), (Integer)object);
        }
    }

    private class GainSetPoint
    extends NonCachedValue {
        public GainSetPoint(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            OpticsAmplifiedLineModel.this.amplifiedOpticalLine.setGainSetPoint(OpticsAmplifiedLineModel.this.getIndex(), (Integer)object);
        }
    }

    private class TiltCalibration
    extends NonCachedValue {
        public TiltCalibration(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            OpticsAmplifiedLineModel.this.amplifiedOpticalLine.setTiltCalibration(OpticsAmplifiedLineModel.this.getIndex(), (Integer)object);
        }
    }
}

