/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.DeletionToken;
import cerent.cms.model.ISlotNumAccessor;
import cerent.cms.model.QueuedSequenceNumberAdjuster;
import cerent.util.SDebug;
import cerent.util.TimeLRUMap;

public class SequenceNumberLRUMap
extends TimeLRUMap {
    private QueuedSequenceNumberAdjuster adjuster = new QueuedSequenceNumberAdjuster();
    private static final long UNINITIALIZED_SEQ_NUM = -1L;

    public SequenceNumberLRUMap(int n, SDebug sDebug) {
        super(n, sDebug);
    }

    protected void enqueued(Object object) {
        if (object instanceof AbstractPersistableModelState) {
            AbstractPersistableModelState abstractPersistableModelState = (AbstractPersistableModelState)object;
            Long l = abstractPersistableModelState.getSequenceNumber();
            ISlotNumAccessor iSlotNumAccessor = (ISlotNumAccessor)((Object)abstractPersistableModelState.getModel());
            if (iSlotNumAccessor != null) {
                short s = iSlotNumAccessor.getSlotNum();
                if (this.db != null && this.db.on() && l != UNINITIALIZED_SEQ_NUM_OBJ) {
                    this.db.println("enqueue of I/F state: " + s + "/" + SequenceNumberLRUMap.display(l) + " - " + abstractPersistableModelState);
                }
                this.adjuster.enqueue(l, s);
            } else if (this.db != null && this.db.on()) {
                this.db.println("(no) enqueue of I/F state w/ null model: " + abstractPersistableModelState);
            }
        } else if (object instanceof DeletionToken) {
            DeletionToken deletionToken = (DeletionToken)object;
            Long l = deletionToken.getSequenceNumber();
            short s = deletionToken.getSlotNum();
            if (this.db != null && this.db.on()) {
                this.db.println("enqueue of deletion token: " + s + "/" + SequenceNumberLRUMap.display(l));
            }
            this.adjuster.enqueue(l, s);
        } else if (object != null && this.db != null && this.db.on()) {
            this.db.println("(enqueue) unhandled object of type: " + object.getClass().getName());
        }
    }

    public Long dequeued(Object object) {
        return this.dequeued(object, UNINITIALIZED_SEQ_NUM_OBJ);
    }

    protected Long dequeued(Object object, Long l) {
        Long l2 = l;
        if (object instanceof AbstractPersistableModelState) {
            ISlotNumAccessor iSlotNumAccessor;
            AbstractPersistableModelState abstractPersistableModelState = (AbstractPersistableModelState)object;
            if (l2 == UNINITIALIZED_SEQ_NUM_OBJ) {
                l2 = abstractPersistableModelState.getSequenceNumber();
            }
            if ((iSlotNumAccessor = (ISlotNumAccessor)((Object)abstractPersistableModelState.getModel())) != null) {
                short s = iSlotNumAccessor.getSlotNum();
                Long l3 = l2;
                l2 = this.dequeue(l2, s);
                if (this.db != null && this.db.on()) {
                    this.db.println(s + " - dQ seq #: " + SequenceNumberLRUMap.display(l3) + " / persist seq #: " + SequenceNumberLRUMap.display(l2) + " - " + abstractPersistableModelState);
                }
            }
        } else if (object instanceof DeletionToken) {
            DeletionToken deletionToken = (DeletionToken)object;
            if (l2 == UNINITIALIZED_SEQ_NUM_OBJ) {
                l2 = deletionToken.getSequenceNumber();
            }
            short s = deletionToken.getSlotNum();
            Long l4 = l2;
            l2 = this.dequeue(l2, s);
            if (this.db != null && this.db.on()) {
                this.db.println(s + " - deletion dQ seq #: " + SequenceNumberLRUMap.display(l4) + " / persist seq #: " + SequenceNumberLRUMap.display(l2));
            }
        } else if (object != null && this.db != null && this.db.on()) {
            this.db.println("(deque) unhandled object of type: " + object.getClass().getName());
        }
        return l2;
    }

    private Long dequeue(Long l, short s) {
        Long l2;
        block2: {
            l2 = UNINITIALIZED_SEQ_NUM_OBJ;
            try {
                l2 = this.adjuster.dequeue(l, s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!this.db.on()) break block2;
                this.db.println("dequeue skipped for " + SequenceNumberLRUMap.display(l) + " / " + s);
            }
        }
        return l2;
    }

    protected void requeued(Object object, Long l) {
        AbstractPersistableModelState abstractPersistableModelState;
        Long l2;
        if (object instanceof AbstractPersistableModelState && !(l2 = (abstractPersistableModelState = (AbstractPersistableModelState)object).getSequenceNumber()).equals(l) && l2 != UNINITIALIZED_SEQ_NUM_OBJ) {
            if (this.db != null && this.db.on()) {
                this.db.println("requeue: " + SequenceNumberLRUMap.display(l2) + "/" + SequenceNumberLRUMap.display(l) + " - " + abstractPersistableModelState);
            }
            this.dequeued(object, l);
            this.enqueued(object);
        }
    }

    public String prettyString(String string) {
        return this.adjuster.prettyString(string);
    }

    private static String display(Long l) {
        return l == UNINITIALIZED_SEQ_NUM_OBJ ? "uninit" : l.toString();
    }
}

