/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.eNodeSide;
import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.idl.OpticsTopology.sSpanLossInfo;
import cerent.cms.idl.OpticsTopology.xCannotPerform;
import cerent.cms.model.AnsParamModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;

public class SpanCheckModel
extends Model {
    private NodeModelDelegate nmd;
    protected static final SDebug db = new SDebug("SpanCheckModel");
    private EventDispatcher dispatcher;
    private eNodeSide nodeSide;
    private CalculateSpanLoss calcSpanLossRef;
    private int obsIndex;
    private sSpanLossInfo[] spanLossList;
    private SpanLossInfo spanLossInfoRef;
    private static final int MEASURED_SPAN_LOSS = 0;
    private static final int EXPECTED_MIN_SPAN_LOSS = 1;
    private static final int EXPECTED_MAX_SPAN_LOSS = 2;
    private static final int RESOLUTION = 3;
    private static final int DIFFERENCE = 4;
    public static final String UNDEFINED = "N/A";
    private boolean calcResponseStatus = false;
    private static final int VAL_UNDEF = -1000000;
    public static final String[] sides = new String[]{"Unknown", "East", "West"};
    private AnsParamModel spanMinExpElem;
    private AnsParamModel spanMaxExpElem;
    private sParameterKey spanExpKey;
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;

    SpanCheckModel(NodeModelDelegate nodeModelDelegate, eNodeSide eNodeSide2, int n) {
        super(db);
        this.nmd = nodeModelDelegate;
        this.nodeSide = eNodeSide2;
        this.obsIndex = n;
        this.dispatcher = null;
        this.calcSpanLossRef = new CalculateSpanLoss(this.nmd, "SpanCheckModel::CalculateSpanLoss");
        this.spanLossInfoRef = new SpanLossInfo(this.nmd, "SpanCheckModel::SpanLossInfo");
    }

    public int getIdx() {
        return this.obsIndex;
    }

    protected void updateLocal() {
        this.spanLossInfoRef.update();
        super.updateLocal();
    }

    public void forceUpdate() {
        this.localInit();
        this.updateLocal();
        this.setChanged();
    }

    public String getSide() {
        return sides[this.nodeSide.value()];
    }

    public synchronized void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Got update from " + observable + " arg=" + object);
        }
        if (observable instanceof CmsObservable) {
            int n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
            if (db.on()) {
                db.println("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = SpanCheckModel.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType))[n]);
            }
            switch (n) {
                case 2: {
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.ADDED);
                    break;
                }
                case 0: {
                    this.calcResponseStatus = false;
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.DELETED);
                    break;
                }
                case 1: {
                    this.calcResponseStatus = true;
                    this.updateLocal();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
            }
        } else if (db.on()) {
            db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    public void init() {
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalSetup, this.obsIndex, (Observer)this);
        }
        this.localInit();
    }

    private void localInit() {
        if (this.spanMinExpElem != null && this.spanMaxExpElem != null) {
            return;
        }
        AnsParamModel[] ansParamModelArray = this.nmd.getANSManager().getNeANSModel().getAnsParamList();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < ansParamModelArray.length && !(bl && bl2); ++i) {
            this.spanExpKey = ansParamModelArray[i].getParamKey();
            if (this.spanExpKey == null || this.spanExpKey.side != this.nodeSide) continue;
            if (this.spanExpKey.type == eParamType.TY_MINEXPSPANLOSS) {
                this.spanMinExpElem = ansParamModelArray[i];
                this.spanMinExpElem.addObserver(this);
                bl = true;
                continue;
            }
            if (this.spanExpKey.type != eParamType.TY_MAXEXPSPANLOSS) continue;
            this.spanMaxExpElem = ansParamModelArray[i];
            this.spanMaxExpElem.addObserver(this);
            bl2 = true;
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalSetup, this.obsIndex, (Observer)this);
            this.dispatcher = null;
        }
        if (this.spanMinExpElem != null) {
            this.spanMinExpElem.deleteObserver(this);
            this.spanMinExpElem = null;
        }
        if (this.spanMaxExpElem != null) {
            this.spanMaxExpElem.deleteObserver(this);
            this.spanMaxExpElem = null;
        }
        this.spanLossInfoRef.dispose();
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public String getMeasuredSpanLoss() {
        int n = this.getSpanAttribute(0);
        if (n != -1000000) {
            this.calcResponseStatus = true;
            return Float.toString((float)n / 10.0f);
        }
        this.calcResponseStatus = false;
        return UNDEFINED;
    }

    public void calculateSpanLoss() throws CannotPerform {
        try {
            this.calcSpanLossRef.setValue();
        }
        catch (xCannotPerform xCannotPerform2) {
            this.calcResponseStatus = false;
            throw new CannotPerform("calculateSpanLoss Error");
        }
    }

    public String[] getSpanLoss() {
        String[] stringArray = new String[3];
        sSpanLossInfo sSpanLossInfo2 = this.getSpanLossInfo();
        if (sSpanLossInfo2 != null) {
            stringArray[2] = sSpanLossInfo2.value == -1000000 ? UNDEFINED : Float.toString((float)sSpanLossInfo2.value / 10.0f);
            stringArray[0] = this.getMinExpectedSpanLoss();
            stringArray[1] = this.getMaxExpectedSpanLoss();
            return stringArray;
        }
        stringArray[0] = UNDEFINED;
        stringArray[1] = UNDEFINED;
        stringArray[2] = UNDEFINED;
        return stringArray;
    }

    public String getExpectedSpanLoss() {
        return UNDEFINED;
    }

    public String getMinExpectedSpanLoss() {
        int n = this.getSpanAttribute(1);
        if (n == -1000000) {
            return UNDEFINED;
        }
        return Float.toString((float)n / 10.0f);
    }

    public String getMaxExpectedSpanLoss() {
        int n = this.getSpanAttribute(2);
        if (n == -1000000) {
            return UNDEFINED;
        }
        return Float.toString((float)n / 10.0f);
    }

    public void setExpectedSpanLoss(String string) {
        this.setMinExpectedSpanLoss(string);
        this.setMaxExpectedSpanLoss(string);
    }

    public void setMinExpectedSpanLoss(String string) {
        this.nmd.getANSManager().getNeANSModel().setParam(this.spanMinExpElem.getParamKey(), (int)(Float.parseFloat(string) * 10.0f));
    }

    public void setMaxExpectedSpanLoss(String string) {
        this.nmd.getANSManager().getNeANSModel().setParam(this.spanMaxExpElem.getParamKey(), (int)(Float.parseFloat(string) * 10.0f));
    }

    public String getResolution() {
        int n = this.getSpanAttribute(3);
        if (n != -1000000) {
            return Float.toString((float)n / 10.0f);
        }
        return UNDEFINED;
    }

    public String getDifference() {
        int n = this.getSpanAttribute(4);
        if (n != -1000000) {
            return Float.toString((float)n / 10.0f);
        }
        return UNDEFINED;
    }

    eNodeSide getNodeSide() {
        return this.nodeSide;
    }

    private DwdmOpticalSetup getDwdmOpticalSetupRef() {
        return this.nmd.getIorRepository().getDwdmOpticalSetupRef();
    }

    private int getSpanAttribute(int n) {
        int n2 = -1000000;
        switch (n) {
            case 0: {
                sSpanLossInfo sSpanLossInfo2 = this.getSpanLossInfo();
                if (sSpanLossInfo2 == null) break;
                n2 = sSpanLossInfo2.value;
                break;
            }
            case 1: {
                if (this.spanMinExpElem == null) break;
                n2 = this.spanMinExpElem.getParamInfo().value.currentValue;
                break;
            }
            case 2: {
                if (this.spanMaxExpElem == null) break;
                n2 = this.spanMaxExpElem.getParamInfo().value.currentValue;
                break;
            }
            case 3: {
                sSpanLossInfo sSpanLossInfo3 = this.getSpanLossInfo();
                if (sSpanLossInfo3 == null) break;
                n2 = sSpanLossInfo3.resolution;
                break;
            }
        }
        return n2;
    }

    private sSpanLossInfo getSpanLossInfo() {
        sSpanLossInfo[] sSpanLossInfoArray = (sSpanLossInfo[])this.spanLossInfoRef.getValue();
        for (int i = 0; i < sSpanLossInfoArray.length; ++i) {
            if (sSpanLossInfoArray[i].side != this.nodeSide) continue;
            return sSpanLossInfoArray[i];
        }
        return null;
    }

    public boolean isCalcSuccessful() {
        return this.calcResponseStatus;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CalculateSpanLoss
    extends NonCachedValue {
        public CalculateSpanLoss(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws xCannotPerform {
            if (SpanCheckModel.db.on) {
                db.println(this.getClass() + "::getValue");
            }
            SpanCheckModel.this.getDwdmOpticalSetupRef().calulateSpanLoss(SpanCheckModel.this.nodeSide);
        }

        public Object outer() {
            return SpanCheckModel.this;
        }
    }

    private class SpanLossInfo
    extends CachedValue {
        public SpanLossInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            if (SpanCheckModel.db.on) {
                db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getSpanLoss();
        }

        protected Object cloneValue() {
            sSpanLossInfo sSpanLossInfo2 = (sSpanLossInfo)this.value;
            sSpanLossInfo sSpanLossInfo3 = new sSpanLossInfo(sSpanLossInfo2.index, sSpanLossInfo2.side, sSpanLossInfo2.resolution, sSpanLossInfo2.value);
            return sSpanLossInfo3;
        }

        public Object outer() {
            return SpanCheckModel.this;
        }
    }
}

