/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Ucp.sIpcc;
import cerent.cms.idl.Ucp.xInvalidParams;
import cerent.cms.idl.Ucp.xNoMoreIpccs;
import cerent.cms.idl.Ucp.xObjDuplicate;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NoMoreIpccs;
import cerent.cms.model.NoSuchIpcc;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ucp.AbstractUcpContainers;
import cerent.cms.model.ucp.IpccModel;
import cerent.util.AnnotatedException;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.UserException;

public class Ipccs
extends AbstractUcpContainers {
    private static final String MY_DEBUG_KEY = "Ipccs";
    private IpccList ipccList;
    private CreateIpcc createIpcc;
    private static ModelSingletonCollection ipccsSingletons;

    public static synchronized Ipccs getInstance(NodeModelDelegate nodeModelDelegate) {
        Ipccs ipccs;
        if (ipccsSingletons == null) {
            ipccsSingletons = ModelSingletonCollection.getMSCInstanceByName(MY_DEBUG_KEY);
        }
        if ((ipccs = (Ipccs)ipccsSingletons.get(nodeModelDelegate)) == null) {
            ipccs = new Ipccs(nodeModelDelegate);
            ipccsSingletons.add(nodeModelDelegate, ipccs);
        }
        return ipccs;
    }

    private Ipccs(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate, nodeModelDelegate.getDebug());
        this.ipccList = new IpccList(nodeModelDelegate, "Ipccs::ipccList");
        this.createIpcc = new CreateIpcc(nodeModelDelegate, "Ipccs::createIpcc");
        this.db = new IpccsDebug(nodeModelDelegate.getDebug());
    }

    public IpccModel create(sIpcc sIpcc2) throws ObjDuplicate, InvalidParams, NoMoreIpccs {
        Object object;
        int n = -1;
        try {
            object = new Object[]{sIpcc2};
            n = (Integer)this.createIpcc.get(object);
        }
        catch (xObjDuplicate xObjDuplicate2) {
            throw new ObjDuplicate(AnnotatedException.getString((Exception)((Object)xObjDuplicate2)));
        }
        catch (xInvalidParams xInvalidParams2) {
            throw new InvalidParams(AnnotatedException.getString((Exception)((Object)xInvalidParams2)));
        }
        catch (xNoMoreIpccs xNoMoreIpccs2) {
            throw new NoMoreIpccs(AnnotatedException.getString((Exception)((Object)xNoMoreIpccs2)));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        if (n != -1) {
            if (this.db.on()) {
                this.db.println("Created IpccModel with ccid = " + n);
            }
            sIpcc2.localCCId = n;
            object = new IpccModel(this.node, this, sIpcc2, null);
            ((IpccModel)object).init();
            this.itemsByIndex.put(new Integer(n), object);
            this.createProcessed = true;
            return object;
        }
        if (this.db.on()) {
            this.db.println("Unable to create IpccModel (ccid==0)");
        }
        return null;
    }

    public IpccModel getByIndex(int n) throws NoSuchIpcc {
        IpccModel ipccModel = (IpccModel)this.itemsByIndex.get(new Integer(n));
        if (ipccModel == null) {
            throw new NoSuchIpcc("ccId = " + n + " not found.");
        }
        return ipccModel;
    }

    public IpccModel[] getIpccsList() {
        IpccModel[] ipccModelArray = new IpccModel[this.itemsByIndex.values().size()];
        ipccModelArray = this.itemsByIndex.values().toArray(ipccModelArray);
        return ipccModelArray;
    }

    public void init() {
        super.init();
        this.discover(this.itemsByIndex);
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            ((IpccModel)iterator.next()).init();
        }
    }

    private void discover(Map map) {
        sIpcc[] sIpccArray = null;
        sIpccArray = this.getIpccs();
        if (sIpccArray == null) {
            this.db.println("ERROR in getting Ipccs (null) Ipccs::discover");
            return;
        }
        for (int i = 0; i < sIpccArray.length; ++i) {
            if (sIpccArray[i] == null) continue;
            Integer n = new Integer(sIpccArray[i].localCCId);
            map.put(n, new IpccModel(this.node, this, sIpccArray[i], null));
        }
    }

    private sIpcc[] getIpccs() {
        sIpcc[] sIpccArray = new sIpcc[]{};
        try {
            sIpccArray = (sIpcc[])this.ipccList.get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Error in getting ipccs " + (Object)((Object)abstractCmsIOException));
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return null;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sIpccArray;
    }

    private void discoverIpccs(HashMap hashMap) {
        sIpcc[] sIpccArray = this.getIpccs();
        if (sIpccArray == null) {
            return;
        }
        for (int i = 0; i < sIpccArray.length; ++i) {
            hashMap.put(new Integer(sIpccArray[i].localCCId), sIpccArray[i]);
        }
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectIpccList;
    }

    protected boolean updateStructure() {
        IpccModel ipccModel;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        boolean bl = false;
        this.discoverIpccs(hashMap);
        Collection collection = Ipccs.getAddedObjects(hashMap.keySet(), this.itemsByIndex.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                object = (sIpcc)hashMap.get(object2);
                ipccModel = new IpccModel(this.node, this, (sIpcc)object, null);
                this.itemsByIndex.put(object2, ipccModel);
                ipccModel.init();
            }
            bl = true;
        }
        if (this.createProcessed) {
            bl = true;
            this.createProcessed = false;
        }
        if ((object2 = Ipccs.getDeletedObjects(hashMap.keySet(), this.itemsByIndex.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                ipccModel = (IpccModel)this.itemsByIndex.get(object);
                if (ipccModel == null) continue;
                this.itemsByIndex.remove(object);
            }
        }
        return bl;
    }

    public void remove(IpccModel ipccModel) {
        this.itemsByIndex.remove(new Integer(ipccModel.getLocalCCId()));
    }

    protected void disposeItems(ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((IpccModel)iterator.next()).dispose();
            }
            catch (Exception exception) {}
        }
    }

    protected void printIpccString(SDebug sDebug) {
        if (this.itemsByIndex == null || this.itemsByIndex.size() == 0) {
            sDebug.println("No IpccModel's contained in Ipccs");
            return;
        }
        sDebug.println("IPCCS total size: " + this.itemsByIndex.values().size());
        Iterator iterator = this.itemsByIndex.values().iterator();
        while (iterator.hasNext()) {
            try {
                IpccModel ipccModel = (IpccModel)iterator.next();
                sDebug.println("===============================================");
                ipccModel.printString(sDebug);
            }
            catch (Exception exception) {
                sDebug.println("Got Exception " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public class IpccsDebug
    extends SDebug {
        IpccsDebug(KDebug kDebug) {
            super(kDebug, Ipccs.MY_DEBUG_KEY);
        }

        public final void dumpAllIpccModels() {
            Ipccs.this.printIpccString(this);
        }
    }

    private class CreateIpcc
    extends NonCachedValue {
        public CreateIpcc(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return new Integer(this.node.getIorRepository().getIpccsRef().create((sIpcc)objectArray[0]));
        }

        public Object outer() {
            return Ipccs.this;
        }
    }

    private class IpccList
    extends NonCachedValue {
        public IpccList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return this.node.getIorRepository().getIpccsRef().getIpccs();
        }

        public Object outer() {
            return Ipccs.this;
        }
    }
}

