/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ISecurityPolicy;
import cerent.cms.model.SecurityPolicy;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.AbstractProvPane;
import cerent.util.EnumStrings;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.TimePeriodPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SecurityPolicyPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private AbstractProvPane parent;
    private TimePeriodPropertyEditor[] idleTimeouts;
    private SpinPropertyEditor lockoutThreshold;
    private JCheckBox lockoutPermanently;
    private TimePeriodPropertyEditor lockoutDuration;
    private SpinPropertyEditor passwordReuseThreshold;
    private JCheckBox singleSessionCB;
    private JCheckBox forcePasswordChangeCB;
    private JCheckBox passwordFlippingCB;
    private SpinPropertyEditor passwordFlippingDuration;
    private JCheckBox disableInactiveUserPolicyCB;
    private SpinPropertyEditor maxInactiveDuration;
    private JCheckBox passwordExprPolicyCB;
    private SpinPropertyEditor[] passwordExprPeriod;
    private SpinPropertyEditor[] passwordWarningPeriod;
    private boolean isDirty;
    private static final String[] security = EnumStrings.getStrings((Class)(class$cerent$cms$model$SecurityLevel == null ? (class$cerent$cms$model$SecurityLevel = SecurityPolicyPanel.class$("cerent.cms.model.SecurityLevel")) : class$cerent$cms$model$SecurityLevel));
    static /* synthetic */ Class class$cerent$cms$model$SecurityLevel;

    private static JPanel createAttributePanel(String string, String string2, Dimension dimension, JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (string != null) {
            JLabel jLabel = new JLabel(string);
            if (dimension != null) {
                jLabel.setPreferredSize(dimension);
            }
            jPanel.add(jLabel);
        }
        jPanel.add(jComponent);
        jPanel.add(new JLabel(string2));
        return jPanel;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    private synchronized void notifyParent() {
        if (this.parent != null) {
            this.parent.setDirty();
        }
    }

    private JPanel createPasswordAgingPanel() {
        JPanel jPanel = AbstractPane.createVerticalPanel("Password Aging");
        this.passwordExprPolicyCB = new JCheckBox("Enforce Password Aging");
        this.passwordExprPolicyCB.setAlignmentX(0.0f);
        this.passwordExprPolicyCB.addActionListener(this);
        jPanel.add(this.passwordExprPolicyCB);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(5, 3));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.add(new JLabel(""));
        jPanel2.add(new JLabel("Aging Period"));
        jPanel2.add(new JLabel("Warning Period"));
        this.passwordExprPeriod = new SpinPropertyEditor[security.length];
        this.passwordWarningPeriod = new SpinPropertyEditor[security.length];
        for (int i = 0; i < security.length; ++i) {
            jPanel2.add(new JLabel("     " + security[i] + ":"));
            this.passwordExprPeriod[i] = new SpinPropertyEditor("", 1, 20, 90);
            jPanel2.add(SecurityPolicyPanel.createAttributePanel(null, " days", null, this.passwordExprPeriod[i]));
            this.passwordWarningPeriod[i] = new SpinPropertyEditor("", 1, 2, 20);
            jPanel2.add(SecurityPolicyPanel.createAttributePanel(null, " days", null, this.passwordWarningPeriod[i]));
            this.passwordExprPeriod[i].addPropertyChangeListener(this);
            this.passwordWarningPeriod[i].addPropertyChangeListener(this);
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    public SecurityPolicyPanel() {
        this.setLayout(new GridLayout(3, 2));
        JPanel jPanel = AbstractPane.createVerticalPanel("Idle User Timeout");
        Dimension dimension = new Dimension(100, 20);
        this.idleTimeouts = new TimePeriodPropertyEditor[security.length];
        for (int i = 0; i < security.length; ++i) {
            this.idleTimeouts[i] = new TimePeriodPropertyEditor(security[i] + ":", dimension, TimePeriodPropertyEditor.DEFAULT_HIGH_ORDER, 60, 0, 59940);
            jPanel.add(this.idleTimeouts[i]);
            this.idleTimeouts[i].addPropertyChangeListener(this);
        }
        this.add(jPanel);
        jPanel = AbstractPane.createVerticalPanel("User Lockout");
        dimension = new Dimension(180, 20);
        this.lockoutThreshold = new SpinPropertyEditor("", 1, 0, 10);
        jPanel.add(SecurityPolicyPanel.createAttributePanel("Failed Logins Before Lockout:", " (times)", dimension, this.lockoutThreshold));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.lockoutPermanently = new JCheckBox("Manual Unlock By Superuser");
        jPanel2.add(this.lockoutPermanently);
        jPanel.add(jPanel2);
        this.lockoutDuration = new TimePeriodPropertyEditor("    Lockout Duration:", dimension, TimePeriodPropertyEditor.DEFAULT_HIGH_ORDER, 5, 0, 600);
        jPanel.add(this.lockoutDuration);
        this.lockoutPermanently.addActionListener(this);
        this.lockoutDuration.addPropertyChangeListener(this);
        this.lockoutThreshold.addPropertyChangeListener(this);
        this.add(jPanel);
        jPanel = AbstractPane.createVerticalPanel("Password Change");
        this.passwordReuseThreshold = new SpinPropertyEditor("", 1, 1, 10);
        jPanel.add(SecurityPolicyPanel.createAttributePanel("Prevent Reusing Last ", " Password(s)", null, this.passwordReuseThreshold));
        this.passwordReuseThreshold.addPropertyChangeListener(this);
        this.passwordFlippingDuration = new SpinPropertyEditor("", 1, 20, 95);
        jPanel2 = SecurityPolicyPanel.createAttributePanel("Cannot Change New Password For ", " days", null, this.passwordFlippingDuration);
        this.passwordFlippingCB = new JCheckBox("");
        jPanel2.add((Component)this.passwordFlippingCB, 0);
        this.passwordFlippingCB.addActionListener(this);
        this.passwordFlippingDuration.addPropertyChangeListener(this);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.forcePasswordChangeCB = new JCheckBox("Require Password Change on First Login to New Account");
        jPanel2.add(this.forcePasswordChangeCB);
        this.forcePasswordChangeCB.addActionListener(this);
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.add(this.createPasswordAgingPanel());
        jPanel = AbstractPane.createVerticalPanel("Other");
        this.singleSessionCB = new JCheckBox("Single Session Per User");
        jPanel.add(this.singleSessionCB);
        this.singleSessionCB.setAlignmentX(0.0f);
        this.singleSessionCB.addActionListener(this);
        this.disableInactiveUserPolicyCB = new JCheckBox("Disable Inactive User");
        jPanel.add(this.disableInactiveUserPolicyCB);
        this.disableInactiveUserPolicyCB.setAlignmentX(0.0f);
        this.disableInactiveUserPolicyCB.addActionListener(this);
        this.maxInactiveDuration = new SpinPropertyEditor("", 1, 45, 90);
        JPanel jPanel3 = SecurityPolicyPanel.createAttributePanel("    Inactive Duration: ", " days", null, this.maxInactiveDuration);
        jPanel3.setAlignmentX(0.0f);
        this.maxInactiveDuration.addPropertyChangeListener(this);
        jPanel.add(jPanel3);
        this.add(jPanel);
        this.isDirty = false;
    }

    public void setSecurityPolicy(ISecurityPolicy iSecurityPolicy) {
        for (int i = 0; i < security.length; ++i) {
            this.idleTimeouts[i].setValue(iSecurityPolicy.getIdleTimeout(i) * 60);
            this.passwordExprPeriod[i].setValue(Integer.toString(iSecurityPolicy.getPasswordExprPeriod(i)));
            this.passwordWarningPeriod[i].setValue(Integer.toString(iSecurityPolicy.getPasswordExprWarningPeriod(i)));
        }
        this.lockoutThreshold.setValue(Integer.toString(iSecurityPolicy.getLockoutThreshold()));
        this.lockoutDuration.setValue(iSecurityPolicy.getLockoutDuration());
        this.lockoutPermanently.setSelected(iSecurityPolicy.isManualUnlock());
        this.passwordReuseThreshold.setValue(Integer.toString(iSecurityPolicy.getPasswordReuseThreshold()));
        this.singleSessionCB.setSelected(iSecurityPolicy.isSingleSessionPerUser());
        this.forcePasswordChangeCB.setSelected(iSecurityPolicy.getForcePasswordChange());
        this.passwordFlippingDuration.setValue(Integer.toString(iSecurityPolicy.getPasswordFlippingPolicyThreshold()));
        this.passwordFlippingCB.setSelected(iSecurityPolicy.getPasswordFlippingPolicyEnabled());
        this.disableInactiveUserPolicyCB.setSelected(iSecurityPolicy.getDisableInactiveUserPolicyEnabled());
        this.maxInactiveDuration.setValue(Integer.toString(iSecurityPolicy.getMaxInactiveDaysBeforeDisable()));
        this.passwordExprPolicyCB.setSelected(iSecurityPolicy.isPasswordExprPolicyEnabled());
        this.updateControls();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.lockoutPermanently || object == this.passwordFlippingCB || object == this.disableInactiveUserPolicyCB || object == this.passwordExprPolicyCB) {
            this.updateControls();
        }
        this.notifyParent();
        this.isDirty = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyParent();
        this.isDirty = true;
    }

    public ISecurityPolicy getSecurityPolicy() {
        SecurityPolicy securityPolicy = new SecurityPolicy();
        for (int i = 0; i < this.idleTimeouts.length; ++i) {
            securityPolicy.setIdleTimeout(i, TimePeriodPropertyEditor.toIntValue((String)this.idleTimeouts[i].getValue()) / 60);
            securityPolicy.setPasswordExprPolicy(i, this.getIntValue((String)this.passwordExprPeriod[i].getValue()), this.getIntValue((String)this.passwordWarningPeriod[i].getValue()));
        }
        securityPolicy.setLockoutThreshold(this.getIntValue((String)this.lockoutThreshold.getValue()));
        securityPolicy.setManualUnlock(this.lockoutPermanently.isSelected());
        securityPolicy.setLockoutDuration(TimePeriodPropertyEditor.toIntValue((String)this.lockoutDuration.getValue()));
        securityPolicy.setPasswordReuseThreshold(this.getIntValue((String)this.passwordReuseThreshold.getValue()));
        securityPolicy.setSingleSessionPerUser(this.singleSessionCB.isSelected());
        securityPolicy.setForcePasswordChange(this.forcePasswordChangeCB.isSelected());
        securityPolicy.setPasswordFlippingPolicyEnabled(this.passwordFlippingCB.isSelected());
        securityPolicy.setPasswordFlippingPolicyThreshold(this.getIntValue((String)this.passwordFlippingDuration.getValue()));
        securityPolicy.setDisableInactiveUserPolicyEnabled(this.disableInactiveUserPolicyCB.isSelected());
        securityPolicy.setMaxInactiveDaysBeforeDisable(this.getIntValue((String)this.maxInactiveDuration.getValue()));
        securityPolicy.setPasswordExprPolicyEnabled(this.passwordExprPolicyCB.isSelected());
        return securityPolicy;
    }

    public synchronized void setParent(AbstractProvPane abstractProvPane) {
        this.parent = abstractProvPane;
    }

    private int getIntValue(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void updateControls() {
        this.lockoutDuration.setEnabled(!this.lockoutPermanently.isSelected());
        this.passwordFlippingDuration.setEnabled(this.passwordFlippingCB.isSelected());
        this.maxInactiveDuration.setEnabled(this.disableInactiveUserPolicyCB.isSelected());
        boolean bl = this.passwordExprPolicyCB.isSelected();
        for (int i = 0; i < security.length; ++i) {
            this.passwordExprPeriod[i].setEnabled(bl);
            this.passwordWarningPeriod[i].setEnabled(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

