/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.event.IAlarmStore;
import cerent.cms.ui.AlarmCounters;
import cerent.cms.ui.IVitalStatsPane;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class VitalStatsPane
extends JPanel
implements IVitalStatsPane {
    private UScrollPane scrollPane = null;
    protected JTextArea textArea = null;
    private JLabel titleLabel = new JLabel();
    private AlarmCounters counters;
    private String title;
    private String text;
    private String appended;
    private JPanel upper = new JPanel(new BorderLayout());

    public VitalStatsPane(IAlarmStore iAlarmStore) {
        super(new BorderLayout());
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.upper.add((Component)this.titleLabel, "North");
        this.upper.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setAlarmStore(iAlarmStore);
        this.textArea = new JTextArea();
        this.textArea.setName("Vital Stats");
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(5, 5, 5, 0));
        this.scrollPane = new UScrollPane((Component)this.textArea);
        this.add((Component)this.scrollPane);
        Font font = this.textArea.getFont();
        this.textArea.setFont(font.deriveFont(12.0f));
        this.add((Component)this.upper, "North");
    }

    public synchronized void setTitle(String string) {
        this.title = string;
        SwingUtilities.invokeLater(new Updater(this));
    }

    public synchronized void setText(String string) {
        this.text = string;
        this.appended = null;
        SwingUtilities.invokeLater(new Updater(this));
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 0);
    }

    public synchronized void updateVitalStats() {
        if (this.title != null) {
            this.titleLabel.setText(this.title);
            this.title = null;
            this.titleLabel.revalidate();
        }
        if (this.text != null) {
            this.textArea.setText(this.text);
            this.textArea.revalidate();
            this.text = null;
        } else if (this.appended != null) {
            this.textArea.append(this.appended);
            this.textArea.revalidate();
            this.appended = null;
        }
    }

    public void setAlarmStore(IAlarmStore iAlarmStore) {
        if (this.counters == null) {
            if (iAlarmStore != null) {
                this.counters = new AlarmCounters(iAlarmStore);
                this.upper.add((Component)this.counters, "South");
                this.counters.revalidate();
            }
        } else {
            this.counters.setAlarmStore(iAlarmStore);
        }
    }

    public void dispose() {
        if (this.counters != null) {
            this.counters.destroy();
        }
        this.scrollPane.getViewport().remove(this.textArea);
    }

    public Dimension getPreferredSize() {
        return new Dimension(150, 300);
    }

    private static class Updater
    implements Runnable {
        VitalStatsPane _vsp;

        Updater(VitalStatsPane vitalStatsPane) {
            this._vsp = vitalStatsPane;
        }

        public void run() {
            this._vsp.updateVitalStats();
            this._vsp = null;
        }
    }
}

