/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.aic;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.model.Attribute;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.aic.AbstractAicEnvControlTableModel;
import cerent.cms.ui.aic.EnvCtrlSetting;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;

public class AicEnvControlTableModel
extends AbstractAicEnvControlTableModel {
    public static final int LINENUMBER_INDEX = 0;
    public static final int ENABLED_INDEX = 1;
    public static final int TYPE_INDEX = 2;
    public static final int TRIGGERINFO_INDEX = 3;
    public static final int DESCRIPTION_INDEX = 4;
    private static final SDebug dbProv = new SDebug("EnvCtrlProv");
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEnvCtrlType;

    public AicEnvControlTableModel(EnvControlModel[] envControlModelArray, int n) {
        super(envControlModelArray[0].getNodeModel(), envControlModelArray);
        this.commonInit();
    }

    public AicEnvControlTableModel(INodeModel iNodeModel, EnvControlModel[] envControlModelArray) {
        super(iNodeModel, envControlModelArray);
        this.settings = new EnvCtrlSetting[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.settings[i] = new EnvCtrlSetting(envControlModelArray[i]);
        }
        this.commonInit();
    }

    private void commonInit() {
        this.db = dbProv;
        this.columnNames = new String[]{"Control #", "Enabled", "Control Type", "Trigger Type", "Description"};
    }

    public boolean isCellEditable(int n, int n2) {
        if (!this.enabled || n2 == 0 || this.settings[n] == null) {
            return false;
        }
        if (this.models != null && this.numLines > 0) {
            try {
                if (((ModuleModel)this.models[0].getAncestorOfType(eClass.E_MODULE)).isProtectModule()) {
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }
        return n2 == 1 || this.settings[n].outputConfig.enabled;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = AicEnvControlTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = AicEnvControlTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object getValueAt(int n, int n2) {
        if (this.settings[n] == null) {
            return this.getDefaultValue(n2);
        }
        try {
            switch (n2) {
                case 0: {
                    return Integer.toString(n + 1);
                }
                case 1: {
                    return this.getBoolean(this.settings[n].outputConfig.enabled);
                }
                case 2: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].getType();
                }
                case 3: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].getTrigger();
                }
                case 4: {
                    if (!this.settings[n].outputConfig.enabled) break;
                    return this.settings[n].outputConfig.description;
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return this.getDefaultValue(n2);
    }

    private Object getDefaultValue(int n) {
        if (n == 1) {
            return this.getBoolean(false);
        }
        return "";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null || this.settings[n] == null) {
            return;
        }
        switch (n2) {
            case 1: {
                this.settings[n].outputConfig.enabled = (Boolean)object;
                this.setValueAt(this.getAttributeFor((class$cerent$cms$idl$Equipment$eEnvCtrlType == null ? (class$cerent$cms$idl$Equipment$eEnvCtrlType = AicEnvControlTableModel.class$("cerent.cms.idl.Equipment.eEnvCtrlType")) : class$cerent$cms$idl$Equipment$eEnvCtrlType).getName(), 7), n, 2);
                break;
            }
            case 4: {
                String string = (String)object;
                if (string.length() > 40) {
                    ErrorMsg.displayWarning((Component)this.getFrame(), (EID)EMC.WID_ENV_ALARM_DESC_TOOLONG_PARAM_1, Integer.toString(40));
                    string = string.substring(0, 40);
                }
                this.settings[n].outputConfig.description = string;
                break;
            }
            case 2: {
                this.settings[n].setType((Attribute)object);
                break;
            }
            case 3: {
                this.settings[n].setTrigger((Attribute)object);
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableRowsUpdated(n, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

