/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ampli;

import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ampli.AmpliOpticalThresholdTableModel;
import cerent.cms.ui.muxdemux.MuxDmuxOpticalThresholdProvPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class AmpliOpticalThresholdPane
extends AbstractPane {
    protected AbstractOpticsLineModel[] models;
    protected MuxDmuxOpticalThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    protected static final String WARNING_15MIN_TH_PANEL = "WARN_15MIN_TH";
    protected static final String WARNING_1DAY_TH_PANEL = "WARN_1DAY_TH";
    protected static final String ALARM_TH_PANEL = "ALARM_TH";
    protected static final int WARNING_15MIN_TH = 0;
    protected static final int WARNING_1DAY_TH = 1;
    protected static final int ALARM_TH = 2;
    private JLabel tableLabel = new JLabel("TEST LABEL...");
    private String tableLabelString = new String();
    private JPanel labeledTablePanel = null;
    private int selection_type = 0;
    private static final SDebug db = new SDebug("AmpliOpticalThresholdPane");

    public AmpliOpticalThresholdPane(String string, TabbedView tabbedView, AbstractOpticsLineModel[] abstractOpticsLineModelArray) {
        super(string, tabbedView);
        this.models = abstractOpticsLineModelArray;
        this.panes = new Pane[4];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "South");
        this.add(this.getTablePanel(), "Center");
    }

    protected MuxDmuxOpticalThresholdButtonPanel getButtonPanel() {
        if (null == this.buttonPanel) {
            this.buttonPanel = new MuxDmuxOpticalThresholdButtonPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(new Dimension(800, 300));
        this.panes[0] = this.getOpticalThresholdProvPane(WARNING_15MIN_TH_PANEL, 0);
        this.tablePanel.add((Component)this.panes[0], WARNING_15MIN_TH_PANEL);
        this.panes[1] = this.getOpticalThresholdProvPane(WARNING_1DAY_TH_PANEL, 1);
        this.tablePanel.add((Component)this.panes[1], WARNING_1DAY_TH_PANEL);
        this.panes[2] = this.getOpticalThresholdProvPane(ALARM_TH_PANEL, 2);
        this.tablePanel.add((Component)this.panes[2], ALARM_TH_PANEL);
        this.cl.show(this.tablePanel, WARNING_15MIN_TH_PANEL);
        this.currentPane = this.panes[0];
        jPanel.add((Component)this.tableLabel, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return jPanel;
    }

    protected MuxDmuxOpticalThresholdProvPane getOpticalThresholdProvPane(String string, int n) {
        return new MuxDmuxOpticalThresholdProvPane(string, this.getParentView(), this.models, n);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        this.getButtonPanel().refreshAction();
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (null == this.panes[i]) continue;
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + '_' + this.panes[i].getName());
            if (this.panes[i] instanceof MuxDmuxOpticalThresholdProvPane) {
                ((MuxDmuxOpticalThresholdProvPane)this.panes[i]).dispose();
            }
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected void adjustColumn(int n) {
        if (n != 2) {
            this.removeColumn(2);
            this.removeColumn(1);
            this.removeColumn(5);
            this.removeColumn(4);
            this.removeColumn(3);
            this.removeColumn(6);
            this.removeColumn(7);
            this.removeColumn(8);
            this.removeColumn(9);
            this.removeColumn(10);
            this.removeColumn(11);
            this.removeColumn(12);
            this.removeColumn(13);
            this.addColumn(2);
            this.addColumn(1);
            this.setColumnW(3);
        } else {
            this.removeColumn(2);
            this.removeColumn(1);
            this.removeColumn(5);
            this.removeColumn(4);
            this.removeColumn(3);
            this.removeColumn(6);
            this.removeColumn(7);
            this.removeColumn(8);
            this.removeColumn(9);
            this.removeColumn(10);
            this.removeColumn(11);
            this.removeColumn(12);
            this.removeColumn(13);
            this.addColumn(3);
            this.addColumn(6);
            this.addColumn(7);
            this.addColumn(12);
            this.addColumn(13);
            this.setColumnW(5);
        }
    }

    protected void removeColumn(int n) {
        String string = AmpliOpticalThresholdTableModel.columnNames[n];
        try {
            TableColumn tableColumn = this.currentPane.getTable().getColumn(string);
            this.currentPane.getTable().removeColumn(tableColumn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addColumn(int n) {
        TableColumn tableColumn = new TableColumn(n);
        String string = AmpliOpticalThresholdTableModel.columnNames[n];
        tableColumn.setHeaderValue(string);
        this.currentPane.getTable().getColumnModel().addColumn(tableColumn);
    }

    protected void setColumnW(int n) {
        TableColumn tableColumn = null;
        block4: for (int i = 0; i < n; ++i) {
            tableColumn = this.currentPane.getTable().getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    tableColumn.setPreferredWidth(140);
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    tableColumn.setPreferredWidth(120);
                }
            }
        }
    }

    protected class MuxDmuxOpticalThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JRadioButton buttonWarning;
        public JRadioButton buttonAlarm;
        public JButton showButton = new JButton("Refresh");
        public ButtonGroup periodButtonGroup;
        public ButtonGroup warningAlarmButtonGroup;
        protected int ALARM_MASK = 2;
        protected int ONE_DAY_MASK = 1;

        public MuxDmuxOpticalThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.buttonWarning = new JRadioButton("Warning", true);
            this.buttonAlarm = new JRadioButton("Alarm");
            this.warningAlarmButtonGroup = new ButtonGroup();
            this.warningAlarmButtonGroup.add(this.buttonWarning);
            this.warningAlarmButtonGroup.add(this.buttonAlarm);
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.showButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ MuxDmuxOpticalThresholdButtonPanel this$1;
                {
                    this.this$1 = muxDmuxOpticalThresholdButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.refreshAction();
                }
            });
            this.buttonWarning.addItemListener(new ItemListener(this){
                private final /* synthetic */ MuxDmuxOpticalThresholdButtonPanel this$1;
                {
                    this.this$1 = muxDmuxOpticalThresholdButtonPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (((JRadioButton)itemEvent.getSource()).isSelected()) {
                        this.this$1.button15Min.setEnabled(true);
                        this.this$1.button1Day.setEnabled(true);
                        AmpliOpticalThresholdPane.access$102(MuxDmuxOpticalThresholdButtonPanel.access$000(this.this$1), 0);
                    } else {
                        this.this$1.button15Min.setEnabled(false);
                        this.this$1.button1Day.setEnabled(false);
                        AmpliOpticalThresholdPane.access$102(MuxDmuxOpticalThresholdButtonPanel.access$000(this.this$1), 2);
                    }
                }
            });
            Dimension dimension = new Dimension(90, 70);
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(BorderFactory.createTitledBorder(" Types "));
            jPanel.setPreferredSize(dimension);
            jPanel.add((Component)this.buttonWarning, "North");
            jPanel.add((Component)this.buttonAlarm, "South");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createTitledBorder(" Intervals "));
            jPanel2.setPreferredSize(dimension);
            jPanel2.add((Component)this.button15Min, "North");
            jPanel2.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(jPanel2);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 75));
        }

        public void refreshAction() {
            int n = 0;
            AmpliOpticalThresholdPane.this.selection_type = 0;
            AmpliOpticalThresholdPane.this.tableLabelString = " ";
            if (this.warningAlarmButtonGroup.getSelection() == this.buttonAlarm.getModel()) {
                if (db.on()) {
                    db.println("Alarm Thresholds");
                }
                n = this.ALARM_MASK;
                AmpliOpticalThresholdPane.this.selection_type = this.ALARM_MASK;
                AmpliOpticalThresholdPane.this.tableLabelString = AmpliOpticalThresholdPane.this.tableLabelString + "Alarm Thresholds";
            } else {
                AmpliOpticalThresholdPane.this.tableLabelString = AmpliOpticalThresholdPane.this.tableLabelString + "Warning Thresholds";
                if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                    if (db.on()) {
                        db.println("1 Day");
                    }
                    AmpliOpticalThresholdPane.this.selection_type = (n |= this.ONE_DAY_MASK) | this.ONE_DAY_MASK;
                    AmpliOpticalThresholdPane.this.tableLabelString = AmpliOpticalThresholdPane.this.tableLabelString + ", 1 Day";
                } else {
                    AmpliOpticalThresholdPane.this.tableLabelString = AmpliOpticalThresholdPane.this.tableLabelString + ", 15 Min";
                }
            }
            switch (n) {
                case 0: {
                    if (db.on()) {
                        db.println("WARNING 15MIN");
                    }
                    AmpliOpticalThresholdPane.this.showPanel(AmpliOpticalThresholdPane.this.panes[0]);
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("WARNING 1DAY");
                    }
                    AmpliOpticalThresholdPane.this.showPanel(AmpliOpticalThresholdPane.this.panes[1]);
                    break;
                }
                case 2: {
                    if (db.on()) {
                        db.println("ALARM TH");
                    }
                    AmpliOpticalThresholdPane.this.showPanel(AmpliOpticalThresholdPane.this.panes[2]);
                }
            }
            AmpliOpticalThresholdPane.this.tableLabel.setText(AmpliOpticalThresholdPane.this.tableLabelString);
            AmpliOpticalThresholdPane.this.adjustColumn(n);
        }

        static /* synthetic */ AmpliOpticalThresholdPane access$000(MuxDmuxOpticalThresholdButtonPanel muxDmuxOpticalThresholdButtonPanel) {
            return muxDmuxOpticalThresholdButtonPanel.AmpliOpticalThresholdPane.this;
        }
    }
}

