/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.model.ANS.IANSElement;
import cerent.cms.model.ProvisionError;
import cerent.cms.ui.ans.ANSController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.awt.Component;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ANSTableModel
extends AbstractTableModel {
    private IANSElement[] rows = null;
    private ANSController dfc;
    private static final String[] COL_NAMES = new String[]{"Parameter", "Value"};

    public ANSTableModel(ANSController aNSController) {
        this.dfc = aNSController;
    }

    public synchronized int getRowCount() {
        if (this.rows != null) {
            return this.rows.length;
        }
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return COL_NAMES[n];
    }

    public synchronized Object getValueAt(int n, int n2) {
        try {
            return this.rows[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            String string = (String)object;
            this.rows[n].setValue(string);
            if (this.rows[n].isDirty()) {
                this.dfc.setDirty(this.rows[n]);
                this.fireTableRowsUpdated(n, n);
            }
        }
        catch (ProvisionError provisionError) {
            SDebug.printStackTrace((Throwable)provisionError);
            ErrorMsg.displayError((Component)this.dfc.getParentComponent(), (EID)EMC.EID_ERROR_SET_VALUEAT_PARAM_1, (Object)this.rows[n].getFullName());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            SDebug.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
            ErrorMsg.displayError((Component)this.dfc.getParentComponent(), (EID)EMC.EID_ERROR_SET_VALUEAT_PARAM_1, (Object)this.rows[n].getFullName());
        }
    }

    public synchronized void setScope(JTable jTable, Map map) {
        jTable.setRowHeight(jTable.getRowHeight());
        this.rows = map.values().toArray(new IANSElement[0]);
        for (int i = 0; i < this.rows.length; ++i) {
            int n = this.rows[i].getDefElemClass();
            if (n == 1) {
                jTable.setRowHeight(i, 128);
                continue;
            }
            if (n != 5) continue;
            jTable.setRowHeight(i, 320);
        }
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1 && this.dfc.isAuthorized() && !this.rows[n].isReadOnly();
    }
}

