/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ans;

import cerent.cms.idl.OpticsTopology.sNodeSetupPort;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Busy;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmOpticalSetupModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.MissingEquipment;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.ui.ans.AnsConnColumnRenderer;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;

public class AnsPathDataSource
extends AbstractRowDataSource
implements Observer {
    private DwdmOpticalSetupModel dwdmOpticalSetupModel;
    private sNodeSetupPort[] OptLinkList = new sNodeSetupPort[0];
    private static final SDebug db = new SDebug("OnsPathDataSource");

    public AnsPathDataSource(DwdmOpticalSetupModel dwdmOpticalSetupModel) {
        this.dwdmOpticalSetupModel = dwdmOpticalSetupModel;
        this.dwdmOpticalSetupModel.addObserver(this);
    }

    public void startONS() throws MissingEquipment, FeatureUnsupported, Busy, CannotPerform {
        this.dwdmOpticalSetupModel.ansSetUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOpticalLinkList() {
        try {
            sNodeSetupPort[] sNodeSetupPortArray = this.dwdmOpticalSetupModel.getNodeSetupPorts();
            ArrayList<sNodeSetupPort> arrayList = new ArrayList<sNodeSetupPort>();
            for (int i = 0; i < sNodeSetupPortArray.length; ++i) {
                sNodeSetupPort sNodeSetupPort2 = sNodeSetupPortArray[i];
                arrayList.add(sNodeSetupPort2);
            }
            this.OptLinkList = arrayList.toArray(new sNodeSetupPort[0]);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.finest("Exception in getOpticalLinkList() " + (Object)((Object)abstractCmsIOException));
            }
        }
        catch (CannotPerform cannotPerform) {
            if (db.on()) {
                db.finest("Exception in getOpticalLinkList() " + (Object)((Object)cannotPerform));
            }
        }
        finally {
            this.fireDataSourceChanged();
        }
    }

    private boolean validSlotPort(OptLinkModel optLinkModel) {
        int n;
        block2: {
            n = -1;
            try {
                NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.dwdmOpticalSetupModel.getNodeModel();
                n = AnsConnColumnRenderer.getSlotInt(nodeModelDelegate, optLinkModel.getIndex());
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                db.println("validSlotPort encountered exception for " + optLinkModel);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return n != -1;
    }

    public void dispose() {
        if (db.on()) {
            db.println("AnsPathDataSource Dispose");
        }
    }

    public void update(Observable observable, Object object) {
    }

    public Object getObjectAtRow(int n) {
        return this.OptLinkList[n];
    }

    public int getRowCount() {
        return this.OptLinkList.length;
    }

    public Collection getAllObjects() {
        return Arrays.asList(this.OptLinkList);
    }

    public NodeModelDelegate getNodeModel() {
        return (NodeModelDelegate)this.dwdmOpticalSetupModel.getNodeModel();
    }
}

