/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds1;

import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds1LineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.ds123.Ds123LineTableModel;
import cerent.util.SDebug;

public class Ds1LineTableModel
extends Ds123LineTableModel {
    private sLineSyncConfig[] syncConfig;
    private Boolean[] retimingEnabled;
    public static final int PROVIDESSYNC_INDEX = 14;
    public static final int SYNCMESSAGEIN_INDEX = 15;
    public static final int SENDDONOTUSE_INDEX = 16;
    public static final int ENABLERETIMING_INDEX = 17;
    public static final int DS1_LAST_COLUMN = 17;
    public static final String[] ds1ColumnNames = new String[18];
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public Ds1LineTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        super(iNodeModel, ds123LineModelArray);
        this.syncConfig = new sLineSyncConfig[this.numLines];
        this.retimingEnabled = new Boolean[this.numLines];
    }

    public int getRangeFor(int n) {
        if (Ds1LineTableModel.between(0, 131, n)) {
            return 131;
        }
        if (Ds1LineTableModel.between(131, 262, n)) {
            return 262;
        }
        if (Ds1LineTableModel.between(262, 393, n)) {
            return 393;
        }
        if (Ds1LineTableModel.between(393, 524, n)) {
            return 524;
        }
        return 655;
    }

    protected Attribute getLineLengthAttributeFor(int n) {
        return ElementDefaults.getAttributeMap((IModel)this.node).getAttributeForVal("DS1_LINE_CARD.Line Length", n);
    }

    protected Attribute getDetectedAttributeFor(Object object, int n) {
        db.println("=" + n);
        return this.getAttributeMap().getAttributeForVal("DS1_LINE_CARD." + object.getClass().getName() + ".detected", n);
    }

    public int getColumnCount() {
        return ds1ColumnNames.length;
    }

    public String getColumnName(int n) {
        return ds1ColumnNames[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = Ds1LineTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = Ds1LineTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 14: {
                    return this.getProvidesSyncFromCard(n);
                }
                case 15: {
                    return this.getSyncMessageIn(n);
                }
                case 16: {
                    return this.getSendDoNotUse(n);
                }
                case 17: {
                    return this.getRetimingEnabled(n);
                }
            }
            return super.getValueAt(n, n2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught exception in getValueAt");
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 15: {
                boolean bl = (Boolean)object;
                if (bl == this.syncConfig[n].syncMessageIn) {
                    return;
                }
                this.syncConfig[n].syncMessageIn = bl;
                break;
            }
            case 16: {
                boolean bl = (Boolean)object;
                if (bl == this.syncConfig[n].sendDoNotUse) {
                    return;
                }
                this.syncConfig[n].sendDoNotUse = bl;
                break;
            }
            case 17: {
                if ((Boolean)object == this.retimingEnabled[n]) {
                    return;
                }
                this.retimingEnabled[n] = (Boolean)object;
                break;
            }
        }
        super.setValueAt(object, n, n2);
    }

    protected sLineSyncConfig getSyncConfig(int n) throws NoSuchInterface, UnsupportedOperation {
        if (this.syncConfig[n] == null) {
            this.syncConfig[n] = ((Ds1LineModel)this.model[n]).getSyncConfig();
        }
        return this.syncConfig[n];
    }

    private Boolean getProvidesSyncFromCard(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).providesSyncFromCard);
    }

    private Boolean getSyncMessageIn(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).syncMessageIn);
    }

    private Boolean getSendDoNotUse(int n) throws NoSuchInterface, UnsupportedOperation {
        return new Boolean(this.getSyncConfig((int)n).sendDoNotUse);
    }

    protected Boolean getRetimingEnabled(int n) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType {
        if (this.retimingEnabled[n] == null) {
            this.retimingEnabled[n] = new Boolean(((Ds1LineModel)this.model[n]).getDs1RetimingEnabled());
        }
        return this.retimingEnabled[n];
    }

    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 14: {
                return false;
            }
            case 17: {
                return !this.isSyncReference(n);
            }
        }
        return super.isCellEditable(n, n2);
    }

    private boolean isSyncReference(int n) {
        try {
            return this.getSyncConfig((int)n).providesSyncFromCard;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void refreshFromModel() throws NoSuchInterface {
        for (int i = 0; i < this.numLines; ++i) {
            this.syncConfig[i] = null;
            this.retimingEnabled[i] = null;
        }
        super.refreshFromModel();
    }

    public void refreshLineFromModel(int n) {
        this.syncConfig[n] = null;
        this.retimingEnabled[n] = null;
        super.refreshLineFromModel(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.arraycopy(Ds123LineTableModel.columnNames, 0, ds1ColumnNames, 0, Ds123LineTableModel.columnNames.length);
        Ds1LineTableModel.ds1ColumnNames[14] = "ProvidesSync";
        Ds1LineTableModel.ds1ColumnNames[15] = "SyncMsgIn";
        Ds1LineTableModel.ds1ColumnNames[16] = "Send DoNotUse";
        Ds1LineTableModel.ds1ColumnNames[17] = "Enable Retiming";
    }
}

