/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Ds123Media.eSendCode;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.IAdminTableAccess;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class Ds123LineMaintTableModel
extends AbstractTableModel
implements IAdminTableAccess {
    private Frame _frame;
    protected Ds123LineModel[] model;
    protected boolean[][] isDirty;
    protected int numLines;
    private AdminState[] adminState;
    private IServiceState[] serviceState;
    protected Attribute[] loopbackVal;
    protected Attribute[] sendCode;
    protected Boolean[] facLoopAis;
    protected Boolean[] termLoopAis;
    private EntityCellRenderer myPortRenderer;
    protected static final int LINENUMBER_INDEX = 0;
    protected static final int ADMIN_STATE_INDEX = 1;
    protected static final int SERVICE_STATE_INDEX = 2;
    protected static final int LOOPBACK_INDEX = 3;
    public static final int SENDCODE_INDEX = 4;
    protected static final int FACILITY_AIS_INDEX = 5;
    protected static final int TERMINAL_AIS_INDEX = 6;
    protected static final int DS123_LAST_COL = 6;
    protected String[] columnNames = new String[]{"Port ", "Admin State", "Service State", "Loopback Type", "Send Code", "Send AIS on Facility Loopback", "Send AIS on Terminal Loopback"};
    protected int framingType;
    protected TDMTerminology terms;
    private static final SDebug db = new SDebug("Ds123LineMaintTableModel");
    static /* synthetic */ Class class$cerent$cms$idl$If$eLoopback;
    static /* synthetic */ Class class$cerent$cms$idl$Ds123Media$eSendCode;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public Ds123LineMaintTableModel(INodeModel iNodeModel, Ds123LineModel[] ds123LineModelArray) {
        this._frame = iNodeModel.getUiToolkit().getApplicationFrame();
        this.model = ds123LineModelArray;
        this.terms = iNodeModel.getTDMTerminology();
        this.framingType = iNodeModel.getFramingType();
        this.myPortRenderer = new EntityCellRenderer(true);
        this.setColumnNames();
        this.init();
    }

    protected void init() {
        this.numLines = this.model == null ? 0 : this.model.length;
        this.adminState = new AdminState[this.numLines];
        this.serviceState = new IServiceState[this.numLines];
        this.loopbackVal = new Attribute[this.numLines];
        this.sendCode = new Attribute[this.numLines];
        this.facLoopAis = new Boolean[this.numLines];
        this.termLoopAis = new Boolean[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    protected void setColumnNames() {
    }

    protected String getLineNumber(int n) throws AbstractCmsNoSuchEntityException {
        return this.getPortDescriptionFor(n);
    }

    public AdminState getAdminState(int n) throws NoSuchInterface, WrongInterfaceType {
        db.info("getAdminState() line " + n);
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.model[n].getAdminStateEnum();
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    protected IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.model[n].getServiceState();
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    protected Attribute getLoopback(int n) throws NoSuchInterface, WrongInterfaceType {
        db.info("getLoopback() line " + n);
        eLoopback eLoopback2 = this.model[n].getLoopback();
        if (this.loopbackVal[n] == null) {
            this.loopbackVal[n] = this.getAttributeFor((class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = Ds123LineMaintTableModel.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName(), eLoopback2.value());
        }
        if (!AdminState.admitsLoopback(this.getAdminStateFor(n)) && !eLoopback2.equals(eLoopback.FE_LINE_LOOPBACK)) {
            this.loopbackVal[n] = this.getAttributeFor((class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = Ds123LineMaintTableModel.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName(), 0);
        }
        return this.loopbackVal[n];
    }

    protected AttributeMaps getAttributeMap() {
        return ElementDefaults.getAttributeMap(this.framingType, this.terms);
    }

    private Attribute getSendCode(int n) {
        if (this.sendCode[n] == null) {
            eSendCode eSendCode2 = this.model[n].getSendCode();
            this.sendCode[n] = this.getAttributeFor((class$cerent$cms$idl$Ds123Media$eSendCode == null ? (class$cerent$cms$idl$Ds123Media$eSendCode = Ds123LineMaintTableModel.class$("cerent.cms.idl.Ds123Media.eSendCode")) : class$cerent$cms$idl$Ds123Media$eSendCode).getName(), eSendCode2.value());
        }
        return this.sendCode[n];
    }

    public Boolean getFacLoopbackAis(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.facLoopAis[n] == null) {
            this.facLoopAis[n] = new Boolean(this.model[n].getFacLoopbackAis());
        }
        return this.facLoopAis[n];
    }

    public Boolean getTermLoopbackAis(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.termLoopAis[n] == null) {
            this.termLoopAis[n] = new Boolean(this.model[n].getTermLoopbackAis());
        }
        return this.termLoopAis[n];
    }

    protected Attribute getAttributeFor(String string, int n) {
        return this.getAttributeMap().getAttributeForVal("DS123." + string, n);
    }

    public void setValueAt(Object object, int n, int n2) {
        db.info("Change in value " + n + " " + n2);
        try {
            switch (n2) {
                case 1: {
                    this.adminState[n] = (AdminState)object;
                    break;
                }
                case 3: {
                    this.loopbackVal[n] = (Attribute)object;
                    break;
                }
                case 4: {
                    this.sendCode[n] = (Attribute)object;
                    break;
                }
                case 5: {
                    if (this.facLoopAis[n] == (Boolean)object) {
                        return;
                    }
                    this.facLoopAis[n] = (Boolean)object;
                    break;
                }
                case 6: {
                    if (this.termLoopAis[n] == (Boolean)object) {
                        return;
                    }
                    this.termLoopAis[n] = (Boolean)object;
                    break;
                }
            }
        }
        catch (Exception exception) {
            db.severe("Caught exception in setValueAt");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this._frame, (EID)EMC.EID_SETTING_VALUES);
        }
        db.info("Setting row to dirty " + n);
        this.isDirty[n][n2] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 5: 
            case 6: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = Ds123LineMaintTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = Ds123LineMaintTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public eAdminState getAdminStateFor(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public eLoopback getLoopbackValFor(int n) throws NoSuchInterface, WrongInterfaceType {
        return eLoopback.from_int(this.getLoopback(n).getIntValue());
    }

    public eSendCode getSendCodeValFor(int n) {
        return eSendCode.from_int(this.getSendCode(n).getIntValue());
    }

    public boolean isCellEditable(int n, int n2) {
        block8: {
            if (this.model != null && this.numLines > 0 && n < this.numLines && n2 != 2) {
                try {
                    if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.MAINTENANCE) && !this.model[0].getModuleModel().isProtectModule()) {
                        if (n2 == 1) {
                            return this.canEditAdminState(n);
                        }
                        if (n2 == 3) {
                            return this.canEditLoopback(n);
                        }
                        if (n2 == 4) {
                            return this.canEditSendCode(n);
                        }
                        if (n2 == 5 || n2 == 6) {
                            return this.canEditDownstreamAis(n);
                        }
                        return n2 > 0;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block8;
                    db.severe("Caught exception in isCellEditable");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return false;
    }

    protected boolean canEditAdminState(int n) {
        return true;
    }

    protected boolean canEditLoopback(int n) {
        try {
            return AdminState.admitsLoopback(this.getAdminStateFor(n));
        }
        catch (Exception exception) {
            db.fine("Unimportant exception");
            return false;
        }
    }

    protected boolean canEditSendCode(int n) {
        try {
            return AdminState.admitsSendCode(this.getAdminState(n).getAdminStateEnum());
        }
        catch (Exception exception) {
            db.severe("Exception in Ds123LineMaintTableModel.canEditSendCode " + exception);
            return false;
        }
    }

    protected boolean canEditDownstreamAis(int n) {
        try {
            return this.getLoopbackValFor(n) == eLoopback.NO_LOOPBACK || this.model[n].getLoopback() == eLoopback.NO_LOOPBACK;
        }
        catch (Exception exception) {
            db.severe("Exception in Ds123LineMaintTableModel.canEditDownstreamAis " + exception);
            return false;
        }
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumber(n);
                }
                case 1: {
                    return this.getAdminState(n).toString(this.terms);
                }
                case 2: {
                    return this.getServiceState(n).toString(this.terms);
                }
                case 3: {
                    return this.getLoopback(n);
                }
                case 4: {
                    return this.getSendCode(n);
                }
                case 5: {
                    return this.getFacLoopbackAis(n);
                }
                case 6: {
                    return this.getTermLoopbackAis(n);
                }
            }
        }
        catch (Exception exception) {
            db.severe("Error in getValueAt in Ds123LineMaintTableModel");
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this._frame, (EID)EMC.EID_SETTING_VALUES);
        }
        this.isDirty[n][n2] = true;
        return null;
    }

    public void refreshLineFromModel(int n) {
        db.info("refreshing line in model");
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.loopbackVal[n] = null;
        this.sendCode[n] = null;
        this.facLoopAis[n] = null;
        this.termLoopAis[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        db.info("refreshing in model");
        for (int i = 0; i < this.numLines; ++i) {
            this.adminState[i] = null;
            this.serviceState[i] = null;
            this.loopbackVal[i] = null;
            this.sendCode[i] = null;
            this.facLoopAis[i] = null;
            this.termLoopAis[i] = null;
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isDirty(n, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public boolean isAdminStateDirty(int n) {
        boolean bl = false;
        try {
            bl = this.isRowDirty(n) && this.getAdminStateFor(n) != this.model[n].getAdminStateEnum();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

