/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds123;

import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3LineUpdate;
import cerent.cms.model.Ds3xmLineUpdate;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ds123.Ds123PmThresholdsPane;
import cerent.util.SDebug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class Ds123LinePmThresholdsPane
extends AbstractPane {
    Ds123LineModel[] models = null;
    protected Ds123LineThresholdButtonPanel buttonPanel = null;
    protected JPanel tablePanel = null;
    protected Pane[] panes = null;
    protected Pane currentPane = null;
    protected CardLayout cl = null;
    public static final int ONE_DAY = 1;
    public static final int MIN_15 = 0;
    public static final String ONE_DAY_PANEL = "1Day";
    public static final String MIN_15_PANEL = "MIN_15";
    private CSHelpID helpID = null;
    private static final SDebug db = new SDebug("Pane.Ds123LinePmThresholdsPane");

    public Ds123LinePmThresholdsPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, CSHelpID cSHelpID) {
        super(string, tabbedView);
        this.models = ds123LineModelArray;
        this.helpID = cSHelpID;
        this.panes = new Pane[2];
        this.initializeLayout();
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
    }

    protected void initializeLayout() {
        this.setLayout(new BorderLayout());
        this.add(this.getButtonPanel(), "North");
        this.add(this.getTablePanel(), "Center");
    }

    protected Ds123LineThresholdButtonPanel getButtonPanel() {
        this.buttonPanel = new Ds123LineThresholdButtonPanel();
        return this.buttonPanel;
    }

    protected JPanel getTablePanel() {
        this.tablePanel = new JPanel();
        this.cl = new CardLayout();
        this.tablePanel.setLayout(this.cl);
        this.tablePanel.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.panes[1] = this.getDs123PmThresholdsPane(ONE_DAY_PANEL, eThresholdType.THRESHOLD_1_DAY);
        this.tablePanel.add((Component)this.panes[1], ONE_DAY_PANEL);
        this.panes[0] = this.getDs123PmThresholdsPane(MIN_15_PANEL, eThresholdType.THRESHOLD_15_MIN);
        this.tablePanel.add((Component)this.panes[0], MIN_15_PANEL);
        this.cl.show(this.tablePanel, MIN_15_PANEL);
        this.currentPane = this.panes[0];
        return this.tablePanel;
    }

    protected Ds123PmThresholdsPane getDs123PmThresholdsPane(String string, eThresholdType eThresholdType2) {
        return new Ds123PmThresholdsPane(string, this.getParentView(), this.models, eThresholdType2, this.helpID);
    }

    protected void showPanel(Pane pane) {
        block4: {
            try {
                TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
                this.currentPane.leavingPage();
            }
            catch (Exception exception) {
                if (!db.on()) break block4;
                db.println("Error in leaving page");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        try {
            pane.enteringPage();
            TablePropertyMgr.getColumnPrefs(pane.getTable(), ((Object)((Object)this)).getClass().getName() + pane.getName());
        }
        catch (Exception exception) {
            db.finer("Exception in showPanel() " + exception);
        }
        this.cl.show(this.tablePanel, pane.getName());
        this.currentPane = pane;
    }

    public JTable getTable() {
        JTable jTable = null;
        if (this.currentPane != null) {
            jTable = this.currentPane.getTable();
        }
        return jTable;
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
        if (this.currentPane != null) {
            this.currentPane.leavingPage();
        }
    }

    public void enteringPage() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.enteringPage();
        }
        TablePropertyMgr.getColumnPrefs(this.currentPane.getTable(), ((Object)((Object)this)).getClass().getName() + this.currentPane.getName());
    }

    protected void refreshMyLines(Object object) {
        if (db.on()) {
            db.println("Received Ds3LineUpdate...");
        }
        if (object instanceof Ds3LineUpdate) {
            this.models = (Ds123LineModel[])((Ds3LineUpdate)object).getModels();
        } else if (object instanceof Ds3xmLineUpdate) {
            this.models = ((Ds3xmLineUpdate)object).getFilteredDs3s();
        }
    }

    public void refresh() throws Exception {
        if (this.currentPane != null) {
            this.currentPane.refresh();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.panes.length; ++i) {
            TablePropertyMgr.setColumnPrefs(this.panes[i].getTable(), ((Object)((Object)this)).getClass().getName() + this.panes[i].getName());
            this.panes[i].destroy();
            this.panes[i] = null;
        }
        this.cl = null;
        this.buttonPanel = null;
        super.destroy();
    }

    protected class Ds123LineThresholdButtonPanel
    extends JPanel {
        public JRadioButton button15Min;
        public JRadioButton button1Day;
        public JButton showButton = new JButton("Show Thresholds");
        public ButtonGroup periodButtonGroup;

        public Ds123LineThresholdButtonPanel() {
            this.initialize();
        }

        protected void initialize() {
            this.button15Min = new JRadioButton("15 Min", true);
            this.button1Day = new JRadioButton("1 Day");
            this.periodButtonGroup = new ButtonGroup();
            this.periodButtonGroup.add(this.button15Min);
            this.periodButtonGroup.add(this.button1Day);
            this.showButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Ds123LineThresholdButtonPanel this$1;
                {
                    this.this$1 = ds123LineThresholdButtonPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.refreshAction();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.button15Min, "North");
            jPanel.add((Component)this.button1Day, "South");
            this.setLayout(new FlowLayout(0));
            this.add(jPanel);
            this.add(this.showButton);
            this.setPreferredSize(new Dimension(800, 50));
        }

        protected void refreshAction() {
            if (this.periodButtonGroup.getSelection() == this.button1Day.getModel()) {
                Ds123LinePmThresholdsPane.this.showPanel(Ds123LinePmThresholdsPane.this.panes[1]);
            } else {
                Ds123LinePmThresholdsPane.this.showPanel(Ds123LinePmThresholdsPane.this.panes[0]);
            }
        }
    }
}

