/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ds3;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.CardTabbedView;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.SubTabbedView;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ds123.Ds123LinePmThresholdsPane;
import cerent.cms.ui.ds3.Ds3LineProvPane;
import cerent.cms.ui.ds3.Ds3SonetPmThresholdsPane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;

public class Ds3ProvPane
extends NodeProvPane
implements ITabName {
    Ds123LineModel[] lineModels = null;
    private static final SDebug dbg = new SDebug("Ds3ProvPane");

    public Ds3ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray) {
        this(string, tabbedView, ds123LineModelArray, true);
    }

    public Ds3ProvPane(String string, TabbedView tabbedView, Ds123LineModel[] ds123LineModelArray, boolean bl) {
        super(string, tabbedView);
        INodeModel iNodeModel = tabbedView.getUiModel().getNodeModel();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        this.lineModels = ds123LineModelArray;
        this.subTabs = new SubTabbedView(this.getUiModel(), tabbedView);
        this.subTabs.addTab("Line", (Component)this.getLineProvTab());
        this.subTabs.addTab("Line Thresholds", (Component)this.getLineThreshold());
        boolean bl2 = FramingType.getFramingType((int)iNodeModel.getFramingType()).isSonet();
        if (bl2) {
            this.subTabs.addTab("SONET Thresholds", (Component)this.getSonetThreshold());
        } else {
            this.subTabs.addTab("SDH Thresholds", (Component)this.getSonetThreshold());
        }
        if (bl) {
            this.subTabs.addTab("Alarm Profiles", (Component)CardTabbedView.getCardProvAlarmsPane(this.subTabs, true));
        }
        this.add((Component)this.subTabs);
    }

    private Pane getLineProvTab() {
        CSHelpID cSHelpID = CSHelpConst.Ds3LineProvPane;
        int n = this.getModuleType(this.lineModels[0]);
        if (n == 47) {
            cSHelpID = CSHelpConst.XtcDs3LineProvPane;
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3LineProvPane("Line", this.getParentView(), this.lineModels, cSHelpID));
    }

    private Pane getLineThreshold() {
        CSHelpID cSHelpID = CSHelpConst.Ds3LineThresholdsPane;
        int n = this.getModuleType(this.lineModels[0]);
        if (n == 47) {
            cSHelpID = CSHelpConst.XtcDs3LineThresholdsPane;
        }
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds123LinePmThresholdsPane("Line Thresholds", this.getParentView(), this.lineModels, cSHelpID));
    }

    private Pane getSonetThreshold() {
        return new ProtCardDualPane(this.subTabs, (ModuleModel)this.getUiModel(), new Ds3SonetPmThresholdsPane("SONET Thresholds", this.getParentView(), this.lineModels));
    }

    private int getModuleType(InterfaceModel interfaceModel) {
        try {
            return interfaceModel.getModuleModel().getEqType();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return -1;
        }
    }

    public boolean hasSubTabs() {
        return true;
    }
}

