/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.dwdm.DwdmLineProvTableModel;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.MacAddrCellEditor;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class DwdmLinePane
extends NodeProvPane
implements TableModelListener,
PropertyChangeListener {
    protected DwdmLineProvTableModel dataModel;
    protected DwdmModuleModel eqpmtModel;
    protected AbstractDwdmLineModel[] lineModels;
    protected int numLines;
    protected PaneType pt;
    private boolean notInited = true;
    protected static final SDebug db = new SDebug("DwdmLinePane");

    public DwdmLinePane(String string, TabbedView tabbedView, AbstractDwdmLineModel[] abstractDwdmLineModelArray, PaneType paneType) {
        super(string, tabbedView);
        this.lineModels = abstractDwdmLineModelArray;
        this.numLines = abstractDwdmLineModelArray.length;
        this.eqpmtModel = (DwdmModuleModel)this.getUiModel();
        this.pt = paneType;
        this.dataModel = this.getDataModel();
        this.registerWithModel();
    }

    public void refreshMyLines(Object object) {
        if (!(object instanceof DwdmLineUpdate)) {
            return;
        }
        DwdmLineUpdate dwdmLineUpdate = (DwdmLineUpdate)object;
        this.stopObserving();
        switch (this.pt.value()) {
            case 1: {
                this.lineModels = dwdmLineUpdate.getDwdmTrkLineModels();
                break;
            }
            case 2: {
                this.lineModels = dwdmLineUpdate.getDwdmCliLineModels();
                break;
            }
            default: {
                this.lineModels = dwdmLineUpdate.getDwdmLineModels();
            }
        }
        this.numLines = this.lineModels.length;
        this.startObserving();
        if (this.dataModel != null) {
            this.dataModel.refreshMyLines(this.lineModels);
            try {
                this.refreshFromModel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void init() {
        this.dataModel.addTableModelListener(this);
        this.table = new UTableExt(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.prepareColumns();
        this.startObserving();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.notInited = false;
    }

    protected void prepareColumns() {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(50);
        tableColumn.setCellRenderer(PORT_CELL_RENDERER);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(1));
        tableColumn.setPreferredWidth(150);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(2));
        tableColumn.setPreferredWidth(100);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(3));
        tableColumn.setPreferredWidth(100);
        if (this.is10GEPayload()) {
            this.setAttrCellEditor(5, "G1000 Port Max Size");
            tableColumn = this.table.getColumn(this.dataModel.getColumnName(6));
            tableColumn.setCellEditor(new MacAddrCellEditor());
            tableColumn.sizeWidthToFit();
        } else {
            this.removeColumn(5);
            this.removeColumn(6);
        }
        if (this.eqpmtModel.getEqType() != 182) {
            this.removeColumn(7);
        }
    }

    private boolean is10GEPayload() {
        try {
            return this.lineModels.length > 0 && this.lineModels[0].getFramingType() == 2;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    protected void setAttrCellEditor(int n, String string) {
        this.setAttrCellEditor(n, string, -1);
    }

    protected void setAttrCellEditor(int n, String string, int n2) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        try {
            Object[] objectArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(objectArray)));
            tableColumn.sizeWidthToFit();
            if (n2 == -1) {
                tableColumn.setPreferredWidth(tableColumn.getWidth());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            db.println("WARNING: cannot find attributes for " + string + "\nPlease edit ElementDefaults.java");
            this.table.removeColumn(tableColumn);
        }
    }

    protected void removeColumn(int n) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.getColumnName(n));
        this.table.removeColumn(tableColumn);
    }

    private JComboBox getComboBoxFor(Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected DwdmLineProvTableModel getDataModel() {
        return new DwdmLineProvTableModel(this.lineModels);
    }

    private int getFramingType() {
        return this.eqpmtModel.getNodeModel().getFramingType();
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    protected List getAttributeList(Class clazz) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeList("DWDM." + clazz.getName());
    }

    protected Attribute getAttribute(Class clazz, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal("DWDM." + clazz.getName(), n);
    }

    protected boolean queryRemainDirty() {
        return true;
    }

    public void applyChangesToModel() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (AdminState.adminStateChangedToFormOfOOS(this.dataModel, this.lineModels)) {
            stringBuffer.append(AdminState.getBaseOosWarning(this.terms)).append('\n');
            bl = true;
        }
        if (bl) {
            String string = AdminState.getSevWarningMsg(this.dataModel, this.lineModels, false, true);
            stringBuffer.append(string).append("\n\n").append(this.getApplyString(false));
            if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)stringBuffer.toString(), (String)"Confirmation Dialog")) {
                return;
            }
        }
        this.dataModel.applyToModel();
        this.resetDirty();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                DwdmLinePane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1 && this.dataModel != null) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In DwdmLinePane changeMessage cannot find Model " + observable);
        }
    }

    protected void startObserving() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        this.stopObserving();
    }

    protected void stopObserving() {
        for (int i = 0; i < this.numLines; ++i) {
            if (this.lineModels[i] == null) continue;
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.dispose();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        if (this.notInited) {
            this.init();
        }
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.DwdmLinePane;
    }

    private class UTableExt
    extends UTable {
        private DefaultCellEditor tdmStateEditor;
        private DefaultCellEditor nonTdmStateEditor;
        private DefaultCellEditor tdmAlsEditor;
        private DefaultCellEditor nonTdmAlsEditor;

        public UTableExt(DwdmLineProvTableModel dwdmLineProvTableModel) {
            super((TableModel)dwdmLineProvTableModel);
            boolean bl = AdminState.isANSI(this.getFramingType());
            this.tdmStateEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(AdminState.getDefaultAdminStates(bl)));
            this.nonTdmStateEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(AdminState.getAdminStatesNoAINS(bl)));
            this.tdmAlsEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(DwdmLinePane.this.getAttributeArray("AlsMode")));
            this.nonTdmAlsEditor = new DefaultCellEditor(DwdmLinePane.this.getComboBoxFor(DwdmLinePane.this.getAttributeArray("NoAutoAlsMode")));
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            boolean bl = DwdmLinePane.this.lineModels[n] != null && DwdmLinePane.this.lineModels[n].isSonetSdhPayload();
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 == 2) {
                return bl ? this.tdmStateEditor : this.nonTdmStateEditor;
            }
            if (n3 == 4) {
                if (DwdmLinePane.this.eqpmtModel.getEqType() == 181) {
                    return this.tdmAlsEditor;
                }
                return bl ? this.tdmAlsEditor : this.nonTdmAlsEditor;
            }
            return super.getCellEditor(n, n2);
        }

        private int getFramingType() {
            return DwdmLinePane.this.eqpmtModel.getNodeModel().getFramingType();
        }
    }

    public static class PaneType {
        public static final int _DEFAULT = 0;
        public static final int _TRUNK = 1;
        public static final int _COMBO = 2;
        public static final PaneType DEFAULT = new PaneType(0);
        public static final PaneType TRUNK = new PaneType(1);
        public static final PaneType COMBO = new PaneType(2);
        private int _val;

        private PaneType(int n) {
            this._val = n;
        }

        public int value() {
            return this._val;
        }
    }
}

