/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.cms.ui.sonet.TdmLineTableModel;
import cerent.util.SDebug;

public class DwdmSonetLineTableModel
extends TdmLineTableModel {
    protected AbstractDwdmLineModel[] dwdmModel;
    protected EntityCellRenderer myPortRenderer;
    private static final SDebug db = new SDebug("DwdmSonetLineTableModel");

    public DwdmSonetLineTableModel(NodeModelDelegate nodeModelDelegate, TdmLineModel[] tdmLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super(nodeModelDelegate, tdmLineModelArray);
        this.dwdmModel = abstractDwdmLineModelArray;
        this.myPortRenderer = new EntityCellRenderer(false);
    }

    public boolean isCellEditable(int n, int n2) {
        if (super.isCellEditable(n, n2)) {
            switch (n2) {
                case 20: {
                    return !DwdmTableModel.isProtectedTrunkPort(this.dwdmModel[n]);
                }
                case 5: 
                case 6: {
                    return !this.dwdmModel[n].isProtectLine();
                }
                case 10: 
                case 13: {
                    try {
                        if (this.dwdmModel[n].getPortModel().getEqType() == 123 && this.dwdmModel[n].getModuleModel().getEqType() == 181) {
                            return false;
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        return false;
                    }
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    protected String getPortNum(int n) {
        if (this.portNums[n] == null) {
            try {
                IPortModel iPortModel = this.model[n].getPortModel();
                this.portNums[n] = this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return this.portNums[n];
    }

    protected boolean isSplitterProtectedLine(int n) {
        return this.dwdmModel[n].isSplitterProtectedLine();
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray, AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        if (db.on()) {
            db.println("In refreshMyLines, new tdm lines = " + tdmLineModelArray.length + " and new dwdm models = " + abstractDwdmLineModelArray.length);
        }
        this.dwdmModel = abstractDwdmLineModelArray;
        super.refreshMyLines(tdmLineModelArray);
    }
}

