/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.dwdm;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Dwdm.eMonitorType;
import cerent.cms.idl.Dwdm.sOTNThresholds;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.dwdm.DwdmTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;

public class OtnThresholdTableModel
extends DwdmTableModel {
    public static final String[] columnNames = new String[]{"Port", "ES", "SES", "UAS", "BBE", "FC"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int ES_INDEX = 1;
    public static final int SES_INDEX = 2;
    public static final int UAS_INDEX = 3;
    public static final int BBE_INDEX = 4;
    public static final int FC_INDEX = 5;
    eIntervalType intervalType = null;
    boolean nearEnd = false;
    eMonitorType monitorType = null;
    protected sOTNThresholds[] thresholdsVal;
    private boolean[] isDirty;
    private static final SDebug db = new SDebug("OtnThresholdTableModel");
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Object;

    public OtnThresholdTableModel(DwdmTrkLineModel[] dwdmTrkLineModelArray, eIntervalType eIntervalType2, boolean bl, eMonitorType eMonitorType2) {
        super(db, dwdmTrkLineModelArray);
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.monitorType = eMonitorType2;
        this.refreshMyLines(dwdmTrkLineModelArray);
    }

    public void refreshMyLines(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        super.refreshMyLines(abstractDwdmLineModelArray);
        this.isDirty = new boolean[this.numLines];
        this.thresholdsVal = new sOTNThresholds[this.numLines];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = OtnThresholdTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = OtnThresholdTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0 && AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.isProtectedTrunkPort(n)) {
            return n2 > 0;
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.isDirty[n];
    }

    public boolean isDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.isRowDirty(i)) continue;
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.thresholdsVal[n].es);
                }
                case 2: {
                    return new Integer(this.thresholdsVal[n].ses);
                }
                case 3: {
                    return new Integer(this.thresholdsVal[n].uas);
                }
                case 4: {
                    return new Integer(this.thresholdsVal[n].bbe);
                }
                case 5: {
                    return new Integer(this.thresholdsVal[n].fc);
                }
            }
            return "";
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("OtnThresholdTableModel: error in getValueAt" + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        int n3 = (Integer)object;
        sOTNThresholds sOTNThresholds2 = this.thresholdsVal[n];
        try {
            switch (n2) {
                case 1: {
                    if (sOTNThresholds2.es == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_0 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "ES", object.toString());
                    sOTNThresholds2.es = n3;
                    break;
                }
                case 2: {
                    if (sOTNThresholds2.ses == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_1 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "SES", object.toString());
                    sOTNThresholds2.ses = n3;
                    break;
                }
                case 3: {
                    if (sOTNThresholds2.uas == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_2 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "UAS", object.toString());
                    sOTNThresholds2.uas = n3;
                    break;
                }
                case 4: {
                    if (sOTNThresholds2.bbe == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_3 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "BBE", object.toString());
                    sOTNThresholds2.bbe = n3;
                    break;
                }
                case 5: {
                    if (sOTNThresholds2.fc == n3) {
                        return;
                    }
                    AbstractDwdmLineModel cfr_ignored_4 = this.model[n];
                    this.validate(this.model[n].getValidationPrefix(2, this.nearEnd, this.intervalType, this.monitorType) + "FC", object.toString());
                    sOTNThresholds2.fc = n3;
                    break;
                }
                default: {
                    return;
                }
            }
            this.isDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (ProvisionError provisionError) {
            this.presentProvisionError(this.getColumnName(n2), provisionError);
        }
    }

    public void refreshFromModel() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            this.refreshLineFromModel(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void refreshLineFromModel(int n) throws Exception {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        try {
            this.thresholdsVal[n] = ((DwdmTrkLineModel)this.model[n]).getOTNThresholds(this.nearEnd, this.intervalType, this.monitorType);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Error refreshing row " + (n + 1), exception);
        }
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.portNames[n] = null;
        this.thresholdsVal[n] = null;
        this.isDirty[n] = false;
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        int n = 0;
        try {
            for (n = 0; n < this.numLines; ++n) {
                if (!this.isRowDirty(n)) continue;
                ((DwdmTrkLineModel)this.model[n]).setOTNThresholds(this.thresholdsVal[n], this.nearEnd, this.intervalType, this.monitorType);
                this.isDirty[n] = false;
            }
        }
        catch (ConfigError configError) {
            throw new AnnotatedException("Value(s) entered for row " + (n + 1) + " is not in a valid range", (Exception)((Object)configError));
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

