/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherPmModel;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ML2EtherLineModel;
import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.ML2PosLineModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.ether.AbstractPmHistTableModel;
import cerent.cms.ui.ether.EtherCardPortRenderer;
import cerent.cms.ui.ether.EtherPmCellRenderer;
import cerent.util.SDebug;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class AbstractPmHistPane
extends AbstractPane
implements ActionListener {
    private int[] widths = new int[]{200, 80};
    private JButton retrieveButton;
    private JLabel retrievalTime;
    private UComboBox seriesCB;
    protected UComboBox portCB;
    private EtherPmStatsSeries[] etherPmStatsSeriesList = new EtherPmStatsSeries[0];
    private EtherPmModel etherPmModel;
    private EtherPmCellRenderer pmCellRenderer;
    private AbstractPmHistTableModel dataModel;
    protected ModuleModel eqpmtModel;
    protected EtherLineModel[] lineModels;
    private static final SDebug db = new SDebug("EtherPmHistPane");
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractPmHistPane(String string, TabbedView tabbedView, ModuleModel moduleModel, EtherLineModel[] etherLineModelArray) {
        super(string, tabbedView);
        Serializable serializable;
        this.lineModels = etherLineModelArray;
        this.eqpmtModel = moduleModel;
        NodeModelDelegate nodeModelDelegate = moduleModel.getNodeModelDelegate();
        this.etherPmModel = ((EtherBridgeModel)nodeModelDelegate.getEtherBridgeModel()).getEtherPmModel();
        this.setLayout(new BorderLayout());
        this.dataModel = this.getDataModel();
        this.retrievalTime = new JLabel(" ");
        this.retrievalTime.setHorizontalAlignment(0);
        this.pmCellRenderer = new EtherPmCellRenderer();
        this.table = new UTable((TableModel)this.dataModel);
        this.table.getTableHeader().setUpdateTableInRealTime(true);
        this.table.setDefaultRenderer(class$java$lang$Long == null ? (class$java$lang$Long = AbstractPmHistPane.class$("java.lang.Long")) : class$java$lang$Long, this.pmCellRenderer);
        this.table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = AbstractPmHistPane.class$("java.lang.String")) : class$java$lang$String, this.pmCellRenderer);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        UTable uTable = new UTable((TableModel)this.dataModel);
        uTable.setExportable(false);
        uTable.getTableHeader().setUpdateTableInRealTime(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        for (int i = 0; i < 1; ++i) {
            serializable = tableColumnModel.getColumn(0);
            tableColumnModel.removeColumn((TableColumn)serializable);
            ((TableColumn)serializable).setPreferredWidth(this.widths[i]);
            ((TableColumn)serializable).setResizable(false);
            ((TableColumn)serializable).setMinWidth(this.widths[i]);
            ((TableColumn)serializable).setMaxWidth(this.widths[i]);
            defaultTableColumnModel.addColumn((TableColumn)serializable);
        }
        this.table.setColumnModel(tableColumnModel);
        uTable.setColumnModel(defaultTableColumnModel);
        uTable.setPreferredScrollableViewportSize(uTable.getPreferredSize());
        uTable.getTableHeader().setReorderingAllowed(false);
        uTable.setAutoCreateColumnsFromModel(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowSelectionAllowed(false);
        uTable.setCellSelectionEnabled(false);
        uTable.setRowSelectionAllowed(false);
        uScrollPane.setRowHeaderView((Component)uTable);
        uScrollPane.setCorner("UPPER_LEFT_CORNER", (Component)uTable.getTableHeader());
        JPanel jPanel = AbstractPmHistPane.createVerticalPanel(null);
        this.retrievalTime.setAlignmentX(0.0f);
        uScrollPane.setAlignmentX(0.0f);
        serializable = AbstractPmHistPane.createHorizontalPanel(null);
        ((Container)serializable).setLayout(new FlowLayout(0, 5, 5));
        ((Container)serializable).add(this.retrievalTime);
        jPanel.add(this.makeControlPanel());
        jPanel.add((Component)serializable);
        this.add(jPanel, "South");
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void fixedUpColumn() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < 1; ++i) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        this.table.repaint();
    }

    private JPanel makeControlPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = AbstractPmHistPane.createHorizontalPanel(null);
        this.etherPmStatsSeriesList = this.etherPmModel.getEtherPmStatsSeries();
        this.seriesCB = new UComboBox(this.statsSeriesToVector(this.etherPmStatsSeriesList));
        this.portCB = new UComboBox(this.getPortList());
        this.portCB.setRenderer((ListCellRenderer)new EtherCardPortRenderer());
        this.portCB.setPreferredSize(new Dimension(150, 50));
        if (this.portCB.getItemCount() > 0) {
            this.portCB.setSelectedIndex(0);
        }
        if (this.etherPmStatsSeriesList != null && this.etherPmStatsSeriesList.length > 0) {
            this.seriesCB.setSelectedIndex(0);
            this.dataModel.refreshCols(this.etherPmStatsSeriesList[this.seriesCB.getSelectedIndex()]);
        }
        this.retrieveButton = new JButton("Refresh");
        this.retrieveButton.addActionListener(this);
        jPanel2.add(new JLabel("Interval:"));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this.seriesCB);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(new JLabel("Port:"));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this.portCB);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.retrieveButton);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(new CSHelpButton(CSHelpConst.EtherPmHistPane));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 50, 5, 50));
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)new JLabel(), "East");
        return jPanel;
    }

    private Vector statsSeriesToVector(EtherPmStatsSeries[] etherPmStatsSeriesArray) {
        Vector<String> vector = new Vector<String>();
        if (etherPmStatsSeriesArray != null) {
            for (int i = 0; i < etherPmStatsSeriesArray.length; ++i) {
                vector.add(etherPmStatsSeriesArray[i].getSeriesDescription());
            }
        }
        return vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.retrieveButton) {
            this.refreshNow();
        }
    }

    protected Vector getPortList() {
        EtherLineModel etherLineModel;
        EtherLineModel etherLineModel2 = etherLineModel = this.lineModels == null || this.lineModels.length == 0 ? null : this.lineModels[0];
        List<PortModel> list = etherLineModel == null ? null : (etherLineModel instanceof ML2EtherLineModel ? Arrays.asList(((ML2ModuleModel)this.eqpmtModel).getEtherPortModels()) : (etherLineModel instanceof ML2PosLineModel ? Arrays.asList(((ML2ModuleModel)this.eqpmtModel).getPosPortModels()) : (etherLineModel instanceof AsapEtherLineModel ? this.getPortListFromLineModels() : (etherLineModel instanceof AsapPosLineModel ? this.getPortListFromLineModels() : this.eqpmtModel.getChildren()))));
        return list == null ? new Vector() : new Vector(list);
    }

    protected List getPortListFromLineModels() {
        ArrayList<IPortModel> arrayList = new ArrayList<IPortModel>();
        for (int i = 0; i < this.lineModels.length; ++i) {
            try {
                arrayList.add(this.lineModels[i].getPortModel());
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return arrayList;
    }

    public void enteringPage() {
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.refreshNow();
    }

    public void leavingPage() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
    }

    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshNow() {
        try {
            this.setCursor(3);
            if (this.seriesCB.getSelectedIndex() != -1) {
                int n = this.portCB.getSelectedIndex();
                EtherPmStatsSeries etherPmStatsSeries = this.etherPmStatsSeriesList[this.seriesCB.getSelectedIndex()];
                if (this.portCB.getSelectedIndex() != -1) {
                    this.dataModel.refresh(this.lineModels[n], etherPmStatsSeries);
                    String string = this.dataModel.getLastIntervalTimeStamp();
                    if (string.length() > 0) {
                        this.retrievalTime.setText("The " + etherPmStatsSeries.getSeriesDescription() + " interval, for Port# " + this.getPortName(this.lineModels[n]) + ", labeled \"PREV\" ended " + string);
                    } else {
                        this.retrievalTime.setText(" ");
                    }
                } else {
                    this.dataModel.refreshWithoutLines(etherPmStatsSeries);
                    this.retrievalTime.setText(" ");
                }
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (db.on()) {
                db.println("Caught exception in EtherPmHistPane.refreshNow: " + (Object)((Object)noSuchInterface));
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in EtherPmHistPane.refreshNow: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.setCursor(0);
        }
    }

    private String getPortName(EtherLineModel etherLineModel) {
        String string = "?????";
        try {
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getPortString((IEntityModel)etherLineModel.getPortModel(), false);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return string;
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    protected abstract AbstractPmHistTableModel getDataModel();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

