/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.ui.ether.EtherPortPm;
import cerent.util.IAsyncObserver;
import cerent.util.SDebug;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.job.JobStatus;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractPmStatTableModel
extends AbstractTableModel
implements Runnable,
IFixedColumnsTableModel {
    protected EtherPortPm[] portPms;
    protected boolean baselined = false;
    protected int numLines;
    protected int numRows;
    protected String[] parmNames;
    private IAsyncObserver jobObserver;
    private int numString = 0;
    protected boolean jobInProgress = false;
    protected static final SDebug db = new SDebug("AbstractPmStatTableModel");
    static /* synthetic */ Class class$java$lang$String;

    public AbstractPmStatTableModel(String[] stringArray, int n, int n2) {
        this.parmNames = stringArray;
        this.numRows = stringArray.length;
        this.numLines = n;
        this.numString = n2;
        this.updatePortPMColumns();
    }

    protected void updatePortPMColumns() {
        this.portPms = new EtherPortPm[this.numLines];
        int n = this.parmNames.length - this.numString;
        for (int i = 0; i < this.numLines; ++i) {
            this.portPms[i] = new EtherPortPm(this, this.numString, n, i + 1);
        }
    }

    public void refreshData(IAsyncObserver iAsyncObserver) {
        if (this.jobInProgress) {
            if (iAsyncObserver != null) {
                iAsyncObserver.asyncUpdate((Object)this, null);
            }
        } else {
            this.jobInProgress = true;
            this.jobObserver = iAsyncObserver;
            for (int i = 0; i < this.portPms.length; ++i) {
                this.portPms[i].invalidate(false);
            }
            this.fireTableDataChanged();
            new Thread((Runnable)this, "PmTableModel retrieve PM").start();
        }
    }

    public String widestParmName() {
        String string = "";
        for (int i = 0; i < this.parmNames.length; ++i) {
            if (this.parmNames[i].length() <= string.length()) continue;
            string = this.parmNames[i];
        }
        return string;
    }

    public void clearStats(int[] nArray) {
    }

    public void setBaseline(int n) {
        int n2 = n - 1;
        if (n2 >= 0 && n2 < this.numLines) {
            this.portPms[n2].setBaselined(true, true);
        }
    }

    public void setBaseline() {
        for (int i = 0; i < this.numLines; ++i) {
            this.portPms[i].setBaselined(true, false);
        }
        this.fireTableDataChanged();
    }

    public void resetBaseline(int n) {
        int n2 = n - 1;
        if (n2 >= 0 && n2 < this.numLines) {
            this.portPms[n2].setBaselined(false, true);
        }
    }

    public void resetBaseline() {
        for (int i = 0; i < this.numLines; ++i) {
            this.portPms[i].setBaselined(false, false);
        }
        this.fireTableDataChanged();
    }

    public void dispose() {
        this.jobInProgress = false;
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n < this.numRows) {
            if (n2 == 0) {
                object = this.parmNames[n];
            } else {
                int n3 = n2 - 1;
                if (n3 < this.portPms.length) {
                    object = this.portPms[n3].getObjectAtRow(n);
                }
            }
        }
        return object;
    }

    protected boolean isPmClearingSupported() {
        return false;
    }

    protected boolean isNeTimestampPresent() {
        return false;
    }

    protected final long s32To64(int n) {
        long l = (long)n & 0xFFFFFFFFL;
        return l;
    }

    public int getColumnCount() {
        return this.numLines + 1;
    }

    public String getColumnName(int n) {
        if (n < 1) {
            return "Param";
        }
        if (this.portPms[n - 1].isBaselined()) {
            return "Port " + n + "(b)";
        }
        return "Port " + n;
    }

    public int getFixedColumnCount() {
        return 1;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isRowDirty(int n) {
        return false;
    }

    public void resetDirtyBits() {
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public Class getColumnClass(int n) {
        return class$java$lang$String == null ? (class$java$lang$String = AbstractPmStatTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getRowCount() {
        return this.numRows;
    }

    public void run() {
        for (int i = 0; i < this.numLines && this.jobInProgress; ++i) {
            this.updateRetrieveLabel("data for port " + (i + 1));
            this.retrievePm(i);
        }
        this.jobInProgress = false;
        if (this.jobObserver != null) {
            this.jobObserver.asyncUpdate(null, JobStatus.JOB_COMPLETE);
            this.jobObserver = null;
        }
    }

    protected void updateRetrieveLabel(String string) {
        if (this.jobObserver != null) {
            this.jobObserver.asyncUpdate((Object)string, new JobStatus(1));
        }
    }

    protected abstract void retrievePm(int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

