/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Epos.eCardMode;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.model.EtherModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ether.LinearVlanPane;
import cerent.util.SDebug;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;

public class DualEtherVlanProvPane
extends AbstractPane {
    private static final SDebug db = new SDebug("DualEtherVlanProvPane");
    private Pane mainPane;
    private Pane linearPane;
    private CardLayout layout;
    private EtherModuleModel module;
    private TabbedView parent;
    private eCardMode currentCardMode = eCardMode.MULTI_CARD_SWITCH;

    public DualEtherVlanProvPane(TabbedView tabbedView, EtherModuleModel etherModuleModel, Pane pane) {
        super(pane.getName(), etherModuleModel, tabbedView);
        this.mainPane = pane;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.parent = tabbedView;
        this.module = etherModuleModel;
        this.initPane();
    }

    public String getName() {
        return this.mainPane.getName();
    }

    public JTable getTable() {
        JTable jTable;
        block3: {
            jTable = null;
            try {
                if (this.module.getEtherCardMode() != eCardMode.LINEAR_NO_SWITCH) {
                    jTable = this.mainPane.getTable();
                }
            }
            catch (xNoSuchEquipment xNoSuchEquipment2) {
                if (!DualEtherVlanProvPane.db.on) break block3;
                db.println("Error in getting connectionList " + (Object)((Object)xNoSuchEquipment2));
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            }
        }
        return jTable;
    }

    public void initPane() {
        this.linearPane = new LinearVlanPane("LinearVlanPane", this.parent);
        this.add(this.mainPane.getName(), (Component)this.mainPane);
        this.add(this.linearPane.getName(), (Component)this.linearPane);
        try {
            this.refresh();
        }
        catch (Exception exception) {
            System.err.println("Caught Exception " + exception);
            exception.printStackTrace(System.err);
        }
        this.module.addObserver((Observer)((Object)this));
    }

    public void showOnTop(Pane pane) {
        this.layout.show((Container)((Object)this), pane.getName());
    }

    public void refresh() throws Exception {
        block6: {
            try {
                eCardMode eCardMode2 = this.module.getEtherCardMode();
                if (eCardMode2 == this.currentCardMode) {
                    return;
                }
                if (this.module.getEtherCardMode() == eCardMode.LINEAR_NO_SWITCH) {
                    this.currentCardMode = eCardMode2;
                    this.showOnTop(this.linearPane);
                } else {
                    this.currentCardMode = eCardMode2;
                    this.showOnTop(this.mainPane);
                    if (db.on()) {
                        db.println("mainpane is " + this.mainPane.getName());
                    }
                    this.mainPane.refresh();
                }
            }
            catch (xNoSuchEquipment xNoSuchEquipment2) {
                if (!DualEtherVlanProvPane.db.on) break block6;
                db.println("Error in getting connectionList " + (Object)((Object)xNoSuchEquipment2));
                SDebug.printStackTrace((Throwable)((Object)xNoSuchEquipment2));
            }
        }
    }

    public void destroy() {
        this.module.deleteObserver((Observer)((Object)this));
        if (this.linearPane != null) {
            this.linearPane.destroy();
        }
        if (this.mainPane != null) {
            this.mainPane.destroy();
        }
        this.layout = null;
        super.destroy();
    }

    public void update(Observable observable, Object object) {
        if (object.equals(ModelUpdateType.CHANGED)) {
            this.requestRefresh((Object)this, null);
        }
    }

    public void enteringPage() throws Exception {
        if (db.on()) {
            db.println("enteringPage; mainPane is " + this.mainPane.getName());
        }
        this.mainPane.enteringPage();
        this.table = this.mainPane.getTable();
        this.requestRefresh((Object)this, null);
    }

    public void leavingPage() throws Exception {
        this.mainPane.leavingPage();
    }
}

