/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sTimedStats;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.ui.ether.AbstractPmHistTableModel;
import cerent.cms.ui.ether.EtherPmHistPane;

public class EtherPmHistTableModel
extends AbstractPmHistTableModel {
    protected static final int TX_COLLISIONS = 10;
    protected static final int TX_LATE_COLLISIONS = 11;
    protected static final int TX_EXCESSIVE_COLLISIONS = 12;
    protected static final int TX_DEFERRED = 13;
    private static String[] eposParmNames = new String[]{"Rx Packets", "Rx Bytes", "Tx Packets", "Tx Bytes", "Rx Total Errors", "Rx FCS", "Rx Alignment", "Rx Runts", "Rx Shorts", "Rx Oversized+Jabbers", "Tx Collisions", "Tx Late Collisions", "Tx Excessive Collisions", "Tx Deferred"};

    public EtherPmHistTableModel(EtherPmHistPane etherPmHistPane, ModuleModel moduleModel) {
        super(etherPmHistPane, moduleModel);
        this.parmNames = eposParmNames;
        this.numLines = this.parmNames.length;
    }

    public void refresh(EtherLineModel etherLineModel, EtherPmStatsSeries etherPmStatsSeries) throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface {
        this.etherLineModel = etherLineModel;
        this.refresh = false;
        this.nCols = this.getStatsColCount(etherPmStatsSeries);
        this.timedStats = new sTimedStats[this.numLines][];
        this.lastIntervalTimeStamp = "";
        block6: for (int i = 0; i < this.numLines; ++i) {
            this.timedStats[i] = this.createColsDefaultData(this.nCols);
            switch (i) {
                case 10: {
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_Dot3StatsSingleCollisionFrames);
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_Dot3StatsMultipleCollisionFrames);
                    continue block6;
                }
                case 11: {
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_Dot3StatsLateCollisions);
                    continue block6;
                }
                case 12: {
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_Dot3StatsExcessiveCollisions);
                    continue block6;
                }
                case 13: {
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_Dot3StatsDeferredTransmissions);
                    continue block6;
                }
                default: {
                    this.refreshStats(etherPmStatsSeries, i);
                }
            }
        }
        this.refresh = true;
        this.refreshCols(etherPmStatsSeries);
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (n2 == 0) {
                return this.parmNames[n];
            }
            if (this.refresh && n2 < this.timedStats[n].length + 1 && this.timedStats[n][n2 - 1] != null) {
                if (n == 0) {
                    return new Long(this.timedStats[n][n2 - 1].count + this.timedStats[4][n2 - 1].count);
                }
                return new Long(this.timedStats[n][n2 - 1].count);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

