/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ether;

import cerent.cms.idl.Rmon.sTimedStatsPair;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ether.EtherPmUtilPane;
import cerent.util.SDebug;
import cerent.util.gui.IFixedColumnsTableModel;
import cerent.util.gui.TransmitReceive;
import javax.swing.table.AbstractTableModel;

public class EtherPmUtilTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel {
    private static final String PREFIX = "ETHER.";
    private static final String PREFIX100 = "ETHER100.";
    private static final String PREFIX1000 = "ETHER1000.";
    protected EtherLineModel[] lineModels;
    protected ModuleModel eqpmtModel;
    private int numLines;
    private boolean refresh;
    private int nCols;
    private String[] colNames;
    private sTimedStatsPair[][] txRxTimedStats;
    private EtherPmUtilPane parent;
    private String lastIntervalTimeStamp;
    private int fixedColumns;
    private EventUtilities eventUtilities;
    private NodeModelDelegate nodeModel;
    private boolean isEpos;
    private static final SDebug db = new SDebug("EtherPmUtilTableModel");
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eMauType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$cerent$util$gui$TransmitReceive;

    public EtherPmUtilTableModel(EtherPmUtilPane etherPmUtilPane, ModuleModel moduleModel, EtherLineModel[] etherLineModelArray) {
        this.parent = etherPmUtilPane;
        this.eqpmtModel = moduleModel;
        this.lineModels = etherLineModelArray;
        this.numLines = etherLineModelArray.length;
        int n = moduleModel.getEqType();
        if (n == 14 || n == 15) {
            this.fixedColumns = 2;
            this.isEpos = true;
        } else {
            this.fixedColumns = 1;
            this.isEpos = false;
        }
        this.refresh = false;
        this.nCols = 0;
        this.colNames = new String[0];
        this.lastIntervalTimeStamp = "";
        this.nodeModel = moduleModel.getNodeModelDelegate();
        this.eventUtilities = EventUtilities.getInstance(this.nodeModel);
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (n2 == 0) {
                return this.getPortName(this.lineModels[n]);
            }
            if (n2 == 1 && this.fixedColumns == 2) {
                return this.getMauType(n);
            }
            if (this.refresh && n2 < this.txRxTimedStats[n].length + this.getFixedColumnCount()) {
                return new TransmitReceive(this.txRxTimedStats[n][n2 - this.getFixedColumnCount()]);
            }
            return "";
        }
        catch (Exception exception) {
            db.println("Caught exception in getValueAt");
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private String getPortName(EtherLineModel etherLineModel) {
        String string = "?????";
        try {
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            return entityCellRenderer.getPortString((IEntityModel)etherLineModel.getPortModel(), false);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return string;
        }
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshMyLines(EtherLineModel[] etherLineModelArray) {
        this.lineModels = etherLineModelArray;
        this.numLines = etherLineModelArray.length;
    }

    public void refreshCols(EtherPmStatsSeries etherPmStatsSeries) {
        this.setDisplayCols(etherPmStatsSeries);
        this.fireTableStructureChanged();
        this.parent.fixedUpColumn();
    }

    public void refresh(EtherPmStatsSeries etherPmStatsSeries) throws NoSuchStatsSeries, NoSuchInterface {
        this.refresh = false;
        this.nCols = this.getStatsColCount(etherPmStatsSeries);
        this.txRxTimedStats = new sTimedStatsPair[this.lineModels.length][];
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.txRxTimedStats[i] = this.getTxRxLineUtilSeries(etherPmStatsSeries, i);
        }
        this.lastIntervalTimeStamp = this.txRxTimedStats.length > 0 && this.txRxTimedStats[0].length > 0 ? this.eventUtilities.convertSecondsToLongDateFormat(this.txRxTimedStats[0][0].txStat.timeStamp) : "";
        this.refresh = true;
        this.refreshCols(etherPmStatsSeries);
    }

    public String getLastIntervalTimeStamp() {
        return this.lastIntervalTimeStamp;
    }

    private sTimedStatsPair[] getTxRxLineUtilSeries(EtherPmStatsSeries etherPmStatsSeries, int n) throws NoSuchStatsSeries, NoSuchInterface {
        return this.lineModels[n].getTxRxUtilizationSeries(etherPmStatsSeries);
    }

    private void setDisplayCols(EtherPmStatsSeries etherPmStatsSeries) {
        this.nCols = this.getStatsColCount(etherPmStatsSeries);
        this.colNames = new String[this.nCols];
        for (int i = 0; i < this.nCols; ++i) {
            this.colNames[i] = i > 0 ? "Prev-" + i : "Prev";
        }
    }

    private int getStatsColCount(EtherPmStatsSeries etherPmStatsSeries) {
        try {
            return etherPmStatsSeries.getMaxBuckets();
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private Attribute getMauType(int n) throws NoSuchInterface {
        return this.getAttributeFor((class$cerent$cms$idl$EtherMedia$eMauType == null ? (class$cerent$cms$idl$EtherMedia$eMauType = EtherPmUtilTableModel.class$("cerent.cms.idl.EtherMedia.eMauType")) : class$cerent$cms$idl$EtherMedia$eMauType).getName(), this.lineModels[n].getLineInfo().mauType.value(), this.eqpmtModel);
    }

    private Attribute getAttributeFor(String string, int n, ModuleModel moduleModel) {
        String string2 = PREFIX;
        switch (moduleModel.getEqType()) {
            case 14: {
                string2 = PREFIX100;
                break;
            }
            case 15: {
                string2 = PREFIX1000;
                break;
            }
        }
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string2 + string, n);
    }

    public Class getColumnClass(int n) {
        if (n <= 1) {
            if (this.isEpos) {
                return class$java$lang$String == null ? (class$java$lang$String = EtherPmUtilTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            if (n < 1) {
                return class$java$lang$String == null ? (class$java$lang$String = EtherPmUtilTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$cerent$util$gui$TransmitReceive == null ? (class$cerent$util$gui$TransmitReceive = EtherPmUtilTableModel.class$("cerent.util.gui.TransmitReceive")) : class$cerent$util$gui$TransmitReceive;
        }
        return class$cerent$util$gui$TransmitReceive == null ? (class$cerent$util$gui$TransmitReceive = EtherPmUtilTableModel.class$("cerent.util.gui.TransmitReceive")) : class$cerent$util$gui$TransmitReceive;
    }

    public int getColumnCount() {
        return this.getFixedColumnCount() + this.nCols;
    }

    public String getColumnName(int n) {
        if (n < 1) {
            return "Port";
        }
        if (n == 1 && this.getFixedColumnCount() == 2) {
            return "Mode";
        }
        return this.colNames[n - this.getFixedColumnCount()];
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getFixedColumnCount() {
        return this.fixedColumns;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

