/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.event.AlarmPane;
import cerent.cms.ui.event.EventPanel;
import cerent.cms.ui.event.FilterDialog;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.row.RowDataSource;
import java.awt.Component;

public class CardAlarmPane
extends AlarmPane {
    private boolean isEqTypeShown;

    public CardAlarmPane(String string, ModuleModel moduleModel, TabbedView tabbedView, ElementAlarmStore elementAlarmStore, IEventPanelController iEventPanelController) {
        super(string, moduleModel, tabbedView, CardAlarmPane.getAlarmStore(elementAlarmStore, moduleModel), iEventPanelController);
    }

    protected EventPanel createEventPanel(IEventPanelController iEventPanelController) {
        this.isEqTypeShown = ((ModuleModel)this.uiModel).getNodeModelDelegate().getPlatform().isEqTypeShown();
        int n = 24;
        if (!this.isEqTypeShown) {
            n |= 4;
        }
        return new EventPanel((RowDataSource)this.alarmStore, iEventPanelController, n);
    }

    protected void removeClearedAlarms() {
        try {
            ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.alarmStore;
            elementAlarmStore.getParentStore().removeClearedAlarms();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_COMMUNICATION_ERROR_PARAM_1, (Object)exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncAlarms() {
        try {
            this.setCursor(3);
            ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.alarmStore;
            ElementAlarmStore elementAlarmStore2 = elementAlarmStore.getParentStore();
            elementAlarmStore2.flushAlarmStore();
            elementAlarmStore2.getPendingAlarms();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_COMMUNICATION_ERROR_PARAM_1, exception.getMessage(), exception.toString());
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void showFilterDialog() {
        try {
            INodeModel[] iNodeModelArray = new INodeModel[]{super.getUiModel().getNodeModel()};
            this.alarmStore.getEventFilter().setNodeModel(iNodeModelArray);
            new FilterDialog(this, this.alarmStore.getEventFilter(), "Alarm Filter").show();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private static ElementAlarmStore getAlarmStore(ElementAlarmStore elementAlarmStore, IModuleModel iModuleModel) {
        return elementAlarmStore.getAlarmStore(iModuleModel.getSlot());
    }

    protected INodeModel getAffectedNodeModel(EventInfo eventInfo) {
        INodeModel iNodeModel = this.getUiModel().getNodeModel();
        INodeModel iNodeModel2 = null;
        if (iNodeModel instanceof INodeModel) {
            iNodeModel2 = iNodeModel;
        }
        return iNodeModel2;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.AlarmPane;
    }
}

