/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.event.AlarmSeverity;
import cerent.cms.model.event.EventInfo;
import cerent.cms.ui.helper.EqTypeHelper;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.ComparisonUtil;
import cerent.util.Preferences;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import cerent.util.gui.row.AbstractColumnRenderer;
import cerent.util.gui.row.ColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class EventColumnRenderer
extends AbstractColumnRenderer {
    private static final SDebug db = new SDebug("EventColumnRenderer", false);
    private static final String CK_IMG_PATH = "/images/check_blue.gif";
    private final ImageIcon CK_IMG = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"), "true");
    public static final int SEVERITY = 0;
    public static final int INDEX_SLOT = 1;
    public static final int INDEX_PORT = 2;
    public static final int COND_CODE = 3;
    public static final int COND_DESC = 4;
    public static final int OBJ_TYPE = 5;
    public static final int DATE = 6;
    public static final int NODE = 7;
    public static final int STATE = 8;
    public static final int SRV_AFFECTING = 9;
    public static final int SEQ_NUM = 10;
    public static final int REF_NUM = 11;
    public static final int NEW_ALM = 12;
    public static final int EQ_TYPE = 13;
    public static final int PATH_WIDTH = 14;
    public static final String SEVERITY_NAME = "Sev";
    public static final String INDEX_SLOT_NAME = "Slot";
    public static final String INDEX_PORT_NAME = "Port";
    public static final String COND_CODE_NAME = "Cond";
    public static final String COND_DESC_NAME = "Description";
    public static final String OBJ_TYPE_NAME = "Object";
    public static final String DATE_NAME = "Date";
    public static final String NODE_NAME = "Node";
    public static final String STATE_NAME = "ST";
    public static final String PATH_WIDTH_NAME = "Path Width";
    public static final String SRV_AFFECTING_NAME = "SA";
    public static final String SEQ_NUM_NAME = "Num";
    public static final String REF_NUM_NAME = "Ref";
    public static final String NEW_ALM_NAME = "New";
    public static final String EQ_TYPE_NAME = "Eqpt Type";
    private static final Color[] svBgColor = new Color[]{new Color(100, 170, 220), new Color(255, 153, 255), Color.yellow, Color.orange, Color.red};
    private static final Color[] svFgColor = new Color[]{Color.black, Color.black, Color.black, Color.black, Color.white};
    private String prevDateFormat = null;
    private JLabel label;
    private JLabel checkbox;
    private int mode;
    private static EmptyBorder emptyBorder = new EmptyBorder(0, 2, 0, 2);

    public static Color getBgColor(int n) {
        return svBgColor[n];
    }

    public static Color getFgColor(int n) {
        return svFgColor[n];
    }

    public EventColumnRenderer(int n, String string, int n2, boolean bl, int n3) {
        super(string, n2, bl, n3);
        this.mode = n;
        this.label = new JLabel();
        this.label.setHorizontalAlignment(this.alignment);
        this.label.setOpaque(true);
        this.label.setForeground(Color.black);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.label.setBorder(emptyBorder);
        if (n == 9 || n == 12) {
            this.checkbox = new JLabel(this.CK_IMG);
            this.checkbox.setOpaque(true);
            this.checkbox.setHorizontalAlignment(this.alignment);
        }
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        String string;
        JLabel jLabel = this.label;
        EventInfo eventInfo = (EventInfo)object;
        boolean bl3 = false;
        switch (this.mode) {
            case 0: {
                string = AlarmSeverity.getSeverityCode(eventInfo.getSeverity());
                break;
            }
            case 1: {
                if (eventInfo.getSlot() > 0) {
                    string = Integer.toString(eventInfo.getSlot());
                    break;
                }
                if (eventInfo.getEntityType() == 8 && eventInfo.getFanIndex() > 0) {
                    string = Integer.toString(eventInfo.getFanIndex());
                    break;
                }
                string = " ";
                break;
            }
            case 2: {
                boolean bl4 = this.isZeroBasedPort(eventInfo.getEqType());
                if (eventInfo.getPort() == 127) {
                    string = "all";
                    break;
                }
                if (eventInfo.getSlot() == 9) {
                    string = " ";
                    break;
                }
                if (eventInfo.getPort() != 0) {
                    string = this.getPortString(eventInfo);
                    break;
                }
                if (eventInfo.getPort() == 0 && bl4 && (eventInfo.getTl1Name().startsWith("VFAC") || eventInfo.getTl1Name().startsWith("FAC"))) {
                    string = this.getPortString(eventInfo);
                    break;
                }
                string = " ";
                break;
            }
            case 3: {
                string = this.getCondCode(eventInfo);
                break;
            }
            case 14: {
                int n3 = eventInfo.getPathWidth();
                if (n3 > 0) {
                    string = Integer.toString(n3);
                    break;
                }
                string = "";
                break;
            }
            case 4: {
                string = this.getCondDesc(eventInfo);
                break;
            }
            case 5: {
                string = this.getTl1Aid(eventInfo);
                break;
            }
            case 13: {
                string = EventColumnRenderer.getEqType(eventInfo);
                break;
            }
            case 6: {
                boolean bl5;
                Preferences preferences = Preferences.instance();
                String string2 = preferences.getProperty("ctc", "dateFormat", "MM/DD/YY");
                boolean bl6 = bl5 = !string2.equals("MM/DD/YY");
                if (!string2.equals(this.prevDateFormat)) {
                    this.prevDateFormat = string2;
                    bl3 = true;
                }
                if (preferences.getProperty("ctc", "useNeTimeZone", "0").indexOf("0") == 0) {
                    string = bl5 ? this.convertToEuroDateFormat(eventInfo.getCtcDate()) : eventInfo.getCtcDate();
                    break;
                }
                string = bl5 ? this.convertToEuroDateFormat(eventInfo.getNeDate()) : eventInfo.getNeDate();
                break;
            }
            case 10: {
                if (eventInfo.getSequenceNumber() != 0L) {
                    string = Long.toString(eventInfo.getSequenceNumber());
                    break;
                }
                string = " ";
                break;
            }
            case 11: {
                if (eventInfo.getCorrelateNumber() != 0L) {
                    string = Long.toString(eventInfo.getCorrelateNumber());
                    break;
                }
                string = " ";
                break;
            }
            case 7: {
                string = eventInfo.getNodeName();
                break;
            }
            case 8: {
                string = "" + eventInfo.getState();
                break;
            }
            case 9: {
                if (eventInfo.getSrvAffecting()) {
                    string = null;
                    jLabel = this.checkbox;
                    break;
                }
                string = "";
                break;
            }
            case 12: {
                if (eventInfo.getNewAlm()) {
                    string = null;
                    jLabel = this.checkbox;
                    break;
                }
                string = "";
                break;
            }
            default: {
                string = "???";
            }
        }
        if (string != null) {
            this.label.setText(string);
        }
        if (eventInfo.getState() == 'C') {
            ((Component)jLabel).setBackground(Color.white);
            ((Component)jLabel).setForeground(Color.gray);
        } else {
            ((Component)jLabel).setBackground(svBgColor[eventInfo.getSeverity()]);
            ((Component)jLabel).setForeground(svFgColor[eventInfo.getSeverity()]);
        }
        return jLabel;
    }

    private String convertToEuroDateFormat(String string) {
        return string.substring(3, 5) + "/" + string.substring(0, 2) + string.substring(5);
    }

    protected String getPortString(EventInfo eventInfo) {
        String string = PortHelper.getConcatenatedString((int[])eventInfo.getEntityHierarchyNum());
        String string2 = this.getPortName(eventInfo);
        if (null != string2 && string2.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" \"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
            string = stringBuffer.toString();
        }
        return string;
    }

    protected boolean isZeroBasedPort(int n) {
        return n == 103 || n == 104 || n == 102 || n == 105 || n == 164;
    }

    protected String getPortName(EventInfo eventInfo) {
        String string = null;
        try {
            string = eventInfo.getPortName();
        }
        catch (Exception exception) {
            db.finer("Exception in getPortName() (not supported?) " + exception);
        }
        return string;
    }

    private String getTl1Aid(EventInfo eventInfo) {
        return eventInfo.getTl1Name();
    }

    public static String getEqType(EventInfo eventInfo) {
        Object object = eventInfo.isSonet() ? SONETTDMTerminology.instance() : SDHTDMTerminology.instance();
        try {
            return EventColumnRenderer.getEqType(eventInfo.getEqType(), (TDMTerminology)object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    private static String getEqType(int n, TDMTerminology tDMTerminology) {
        String string;
        String string2 = string = tDMTerminology == null ? null : tDMTerminology.getEqType(n);
        if (string == null) {
            string = EqTypeHelper.eqTypeToName((TDMTerminology)tDMTerminology, (int)n);
        }
        return string;
    }

    private String getCondDesc(EventInfo eventInfo) {
        return eventInfo.getCondDesc();
    }

    private String getCondCode(EventInfo eventInfo) {
        return eventInfo.getCondCode();
    }

    public static ColumnRenderer createEventColumnRenderer(int n) {
        String string;
        int n2 = 30;
        boolean bl = true;
        int n3 = 0;
        switch (n) {
            case 0: {
                string = SEVERITY_NAME;
                n2 = 34;
                break;
            }
            case 1: {
                string = INDEX_SLOT_NAME;
                break;
            }
            case 2: {
                string = INDEX_PORT_NAME;
                n2 = 40;
                break;
            }
            case 3: {
                string = COND_CODE_NAME;
                n2 = 80;
                n3 = 2;
                break;
            }
            case 14: {
                string = PATH_WIDTH_NAME;
                break;
            }
            case 4: {
                string = COND_DESC_NAME;
                n2 = 245;
                n3 = 2;
                break;
            }
            case 5: {
                string = OBJ_TYPE_NAME;
                n2 = 75;
                break;
            }
            case 13: {
                string = EQ_TYPE_NAME;
                n2 = 65;
                break;
            }
            case 6: {
                string = DATE_NAME;
                n2 = 150;
                break;
            }
            case 10: {
                string = SEQ_NUM_NAME;
                n2 = 34;
                break;
            }
            case 11: {
                string = REF_NUM_NAME;
                n2 = 34;
                break;
            }
            case 7: {
                string = NODE_NAME;
                n2 = 50;
                break;
            }
            case 8: {
                string = STATE_NAME;
                n2 = 34;
                break;
            }
            case 9: {
                string = SRV_AFFECTING_NAME;
                n2 = 34;
                break;
            }
            case 12: {
                string = NEW_ALM_NAME;
                n2 = 34;
                break;
            }
            default: {
                string = "???";
            }
        }
        return new EventColumnRenderer(n, string, n2, bl, n3);
    }

    public int compareColumn(Object object, Object object2, int n) {
        int n2 = 0;
        EventInfo eventInfo = (EventInfo)object;
        EventInfo eventInfo2 = (EventInfo)object2;
        switch (this.mode) {
            case 0: {
                n2 = ComparisonUtil.compare(eventInfo.getSeverity(), eventInfo2.getSeverity());
                break;
            }
            case 1: {
                n2 = ComparisonUtil.compare(eventInfo.getSlot(), eventInfo2.getSlot());
                break;
            }
            case 2: {
                n2 = ComparisonUtil.compare(eventInfo.getPort(), eventInfo2.getPort());
                break;
            }
            case 3: {
                n2 = this.getCondCode(eventInfo).compareTo(this.getCondCode(eventInfo2));
                break;
            }
            case 14: {
                n2 = ComparisonUtil.compare(eventInfo.getPathWidth(), eventInfo2.getPathWidth());
                break;
            }
            case 4: {
                n2 = this.getCondDesc(eventInfo).compareTo(this.getCondDesc(eventInfo2));
                break;
            }
            case 5: {
                n2 = this.getTl1Aid(eventInfo).compareTo(this.getTl1Aid(eventInfo2));
                break;
            }
            case 13: {
                n2 = EventColumnRenderer.getEqType(eventInfo).compareTo(EventColumnRenderer.getEqType(eventInfo2));
                break;
            }
            case 6: {
                n2 = ComparisonUtil.compare(eventInfo.getTimeStamp(), eventInfo2.getTimeStamp());
                break;
            }
            case 10: {
                n2 = ComparisonUtil.compare(eventInfo.getSequenceNumber(), eventInfo2.getSequenceNumber());
                break;
            }
            case 11: {
                n2 = ComparisonUtil.compare(eventInfo.getCorrelateNumber(), eventInfo2.getCorrelateNumber());
                break;
            }
            case 7: {
                n2 = eventInfo.getNodeName().compareTo(eventInfo2.getNodeName());
                break;
            }
            case 8: {
                if (eventInfo.getState() == eventInfo2.getState()) break;
                if (eventInfo.getState() < eventInfo2.getState()) {
                    n2 = -1;
                    break;
                }
                n2 = 1;
                break;
            }
            case 9: {
                if (eventInfo.getSrvAffecting() == eventInfo2.getSrvAffecting()) break;
                if (eventInfo.getSrvAffecting()) {
                    n2 = -1;
                    break;
                }
                n2 = 1;
                break;
            }
            case 12: {
                if (eventInfo.getNewAlm() == eventInfo2.getNewAlm()) break;
                if (eventInfo.getNewAlm()) {
                    n2 = -1;
                    break;
                }
                n2 = 1;
                break;
            }
        }
        return n2;
    }
}

