/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.event;

import cerent.cms.model.event.EventFilter;
import cerent.cms.ui.CSHelpConstCom;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.event.AbstractFilterPropertyPane;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.Preferences;
import cerent.util.gui.AbstractPropertySheet;
import cerent.util.gui.BooleanPropertyEditor;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.matcher.AbstractMatcher;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class FilterGeneralPane
extends AbstractFilterPropertyPane {
    private BooleanPropertyEditor timeEnableBox;
    private BooleanPropertyEditor crBox;
    private BooleanPropertyEditor mjBox;
    private BooleanPropertyEditor mnBox;
    private BooleanPropertyEditor naBox;
    private BooleanPropertyEditor nrBox;
    private BooleanPropertyEditor saBox;
    private BooleanPropertyEditor nsaBox;
    private FilterSpinPropertyEditor fromMonBox;
    private FilterSpinPropertyEditor fromDayBox;
    private FilterSpinPropertyEditor fromYearBox;
    private FilterSpinPropertyEditor fromHourBox;
    private FilterSpinPropertyEditor fromMinBox;
    private FilterSpinPropertyEditor fromSecBox;
    private FilterSpinPropertyEditor toMonBox;
    private FilterSpinPropertyEditor toDayBox;
    private FilterSpinPropertyEditor toYearBox;
    private FilterSpinPropertyEditor toHourBox;
    private FilterSpinPropertyEditor toMinBox;
    private FilterSpinPropertyEditor toSecBox;
    public static final int SEV_CR = 4;
    public static final int SEV_MJ = 3;
    public static final int SEV_MN = 2;
    public static final int SEV_NA = 1;
    public static final int SEV_NR = 0;
    public static final String KEY_TIME_ENABLED = "KEY_TIME_ENABLED";
    public static final String KEY_CR = "KEY_CR";
    public static final String KEY_MJ = "KEY_MJ";
    public static final String KEY_MN = "KEY_MN";
    public static final String KEY_NA = "KEY_NA";
    public static final String KEY_NR = "KEY_NR";
    public static final String KEY_SA = "KEY_SA";
    public static final String KEY_NSA = "KEY_NSA";
    public static final String KEY_FROM_MON = "KEY_FROM_MON";
    public static final String KEY_FROM_DAY = "KEY_FROM_DAY";
    public static final String KEY_FROM_YEAR = "KEY_FROM_YEAR";
    public static final String KEY_FROM_HOUR = "KEY_FROM_HOUR";
    public static final String KEY_FROM_MIN = "KEY_FROM_MIN";
    public static final String KEY_FROM_SEC = "KEY_FROM_SEC";
    public static final String KEY_TO_MON = "KEY_TO_MON";
    public static final String KEY_TO_DAY = "KEY_TO_DAY";
    public static final String KEY_TO_YEAR = "KEY_TO_YEAR";
    public static final String KEY_TO_HOUR = "KEY_TO_HOUR";
    public static final String KEY_TO_MIN = "KEY_TO_MIN";
    public static final String KEY_TO_SEC = "KEY_TO_SEC";
    private static final int WIDTH = 525;
    private static final int HEIGHT = 75;
    private JLabel fromDateLbl = null;
    private JLabel toDateLbl = null;

    public FilterGeneralPane(String string, AbstractPropertySheet abstractPropertySheet, Preferences preferences, EventFilter eventFilter) {
        super(string, abstractPropertySheet, preferences, eventFilter);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.createSeverityPane());
        this.add(this.createTimePane());
        this.notifyAllPropertyEditors(this);
        this.load();
    }

    private JPanel createSeverityPane() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 20, 0));
        Dimension dimension = new Dimension(525, 75);
        jPanel.setPreferredSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Show severity", 1, 2));
        this.crBox = new BooleanPropertyEditor("CR");
        jPanel.add(this.crBox);
        this.mjBox = new BooleanPropertyEditor("MJ");
        jPanel.add(this.mjBox);
        this.mnBox = new BooleanPropertyEditor("MN");
        jPanel.add(this.mnBox);
        this.naBox = new BooleanPropertyEditor("NA");
        jPanel.add(this.naBox);
        this.nrBox = new BooleanPropertyEditor("NR");
        jPanel.add(this.nrBox);
        if (this.eventFilter.getType() != 2) {
            this.nrBox.setEnabled(false);
        }
        return jPanel;
    }

    private JPanel createSAPane() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 20, 0));
        Dimension dimension = new Dimension(525, 75);
        jPanel.setPreferredSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Show service affecting", 1, 2));
        this.saBox = new BooleanPropertyEditor("SA");
        jPanel.add(this.saBox);
        this.nsaBox = new BooleanPropertyEditor("NSA");
        jPanel.add(this.nsaBox);
        return jPanel;
    }

    private JPanel createTimePane() {
        Dimension dimension = new Dimension(525, 187);
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setPreferredSize(dimension);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Time", 1, 2));
        String string = null;
        string = this.eventFilter.getType() == 2 ? "Show conditions between time limits" : "Show alarms between time limits";
        this.timeEnableBox = new BooleanPropertyEditor(string);
        jPanel.add(this.timeEnableBox);
        JPanel jPanel2 = new JPanel();
        Dimension dimension2 = new Dimension(68, 20);
        this.fromDateLbl = new JLabel("From Date: ");
        this.fromDateLbl.setPreferredSize(dimension2);
        jPanel2.add(this.fromDateLbl);
        String string2 = this.prefs.getProperty("ctc", "dateFormat", "MM/DD/YY");
        if (string2.equals("MM/DD/YY")) {
            this.fromMonBox = new FilterSpinPropertyEditor("", "'From Month' must be from 1 to 12", "From Month", 1, 1, 12);
            jPanel2.add(this.fromMonBox);
            this.fromDayBox = new FilterSpinPropertyEditor("", "'From Day' must be from 1 to 31", "From Day", 1, 1, 31);
            jPanel2.add(this.fromDayBox);
        } else {
            this.fromDayBox = new FilterSpinPropertyEditor("", "'From Day' must be from 1 to 31", "From Day", 1, 1, 31);
            jPanel2.add(this.fromDayBox);
            this.fromMonBox = new FilterSpinPropertyEditor("", "'From Month' must be from 1 to 12", "From Month", 1, 1, 12);
            jPanel2.add(this.fromMonBox);
        }
        this.fromYearBox = new FilterSpinPropertyEditor("", "The 'From Year' must be from 1970. Please re-enter the 'From Year'", "From Year", 1, 1970, 9999);
        jPanel2.add(this.fromYearBox);
        this.fromHourBox = new FilterSpinPropertyEditor(" Time: ", "'From Hour' must be from 0 to 23", "From Hour", 1, 0, 23);
        jPanel2.add(this.fromHourBox);
        this.fromMinBox = new FilterSpinPropertyEditor("", "'From Minute' must be from 0 to 59", "From Minute", 1, 0, 59);
        jPanel2.add(this.fromMinBox);
        this.fromSecBox = new FilterSpinPropertyEditor("", "'From Second' must be from 0 to 59", "From Second", 1, 0, 59);
        jPanel2.add(this.fromSecBox);
        JPanel jPanel3 = new JPanel();
        this.toDateLbl = new JLabel("To Date: ");
        this.toDateLbl.setPreferredSize(dimension2);
        jPanel3.add(this.toDateLbl);
        if (string2.equals("MM/DD/YY")) {
            this.toMonBox = new FilterSpinPropertyEditor("", "'To Month' must be from 1 to 12", "To Month", 1, 1, 12);
            jPanel3.add(this.toMonBox);
            this.toDayBox = new FilterSpinPropertyEditor("", "'To Day' must be from 1 to 31", "To Day", 1, 1, 31);
            jPanel3.add(this.toDayBox);
        } else {
            this.toDayBox = new FilterSpinPropertyEditor("", "'To Day' must be from 1 to 31", "To Day", 1, 1, 31);
            jPanel3.add(this.toDayBox);
            this.toMonBox = new FilterSpinPropertyEditor("", "'To Month' must be from 1 to 12", "To Month", 1, 1, 12);
            jPanel3.add(this.toMonBox);
        }
        this.toYearBox = new FilterSpinPropertyEditor("", "The 'To Year' must be from 1970. Please re-enter the 'To Year'", "To Year", 1, 1970, 9999);
        jPanel3.add(this.toYearBox);
        this.toHourBox = new FilterSpinPropertyEditor(" Time: ", "'To Hour' must be from 0 to 23", "To Hour", 1, 0, 23);
        jPanel3.add(this.toHourBox);
        this.toMinBox = new FilterSpinPropertyEditor("", "'To Minute' must be from 0 to 59", "To Minute", 1, 0, 59);
        jPanel3.add(this.toMinBox);
        this.toSecBox = new FilterSpinPropertyEditor("", "'To Second' must be from 0 to 59", "To Second", 1, 0, 59);
        jPanel3.add(this.toSecBox);
        this.fromMonBox.setEditorSize(3);
        this.fromDayBox.setEditorSize(3);
        this.fromYearBox.setEditorSize(5);
        this.fromHourBox.setEditorSize(3);
        this.fromMinBox.setEditorSize(3);
        this.fromSecBox.setEditorSize(3);
        this.toMonBox.setEditorSize(3);
        this.toDayBox.setEditorSize(3);
        this.toYearBox.setEditorSize(5);
        this.toHourBox.setEditorSize(3);
        this.toMinBox.setEditorSize(3);
        this.toSecBox.setEditorSize(3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    public void store() {
        String string = this.eventFilter.getPreference();
        this.store(string, KEY_CR, this.crBox);
        this.store(string, KEY_MJ, this.mjBox);
        this.store(string, KEY_MN, this.mnBox);
        this.store(string, KEY_NA, this.naBox);
        this.store(string, KEY_NR, this.nrBox);
        if (this.saBox != null && this.nsaBox != null) {
            this.store(string, KEY_SA, this.saBox);
            this.store(string, KEY_NSA, this.nsaBox);
        }
        this.store(string, KEY_TIME_ENABLED, this.timeEnableBox);
        this.store(string, KEY_FROM_MON, this.fromMonBox);
        this.store(string, KEY_FROM_DAY, this.fromDayBox);
        this.store(string, KEY_FROM_YEAR, this.fromYearBox);
        this.store(string, KEY_FROM_HOUR, this.fromHourBox);
        this.store(string, KEY_FROM_MIN, this.fromMinBox);
        this.store(string, KEY_FROM_SEC, this.fromSecBox);
        this.store(string, KEY_TO_MON, this.toMonBox);
        this.store(string, KEY_TO_DAY, this.toDayBox);
        this.store(string, KEY_TO_YEAR, this.toYearBox);
        this.store(string, KEY_TO_HOUR, this.toHourBox);
        this.store(string, KEY_TO_MIN, this.toMinBox);
        this.store(string, KEY_TO_SEC, this.toSecBox);
    }

    public void load() {
        String string = this.eventFilter.getPreference();
        this.load(string, KEY_CR, this.crBox, "1");
        this.load(string, KEY_MJ, this.mjBox, "1");
        this.load(string, KEY_MN, this.mnBox, "1");
        if (this.eventFilter.getType() != 2) {
            this.load(string, KEY_NA, this.naBox, "0");
            this.load(string, KEY_NR, this.nrBox, "0");
        } else {
            this.load(string, KEY_NA, this.naBox, "1");
            this.load(string, KEY_NR, this.nrBox, "1");
        }
        if (this.saBox != null && this.nsaBox != null) {
            this.load(string, KEY_SA, this.saBox, "1");
            this.load(string, KEY_NSA, this.nsaBox, "1");
        }
        this.load(string, KEY_TIME_ENABLED, this.timeEnableBox, null);
        Calendar calendar = Calendar.getInstance();
        String string2 = String.valueOf(calendar.get(2) + 1);
        String string3 = String.valueOf(calendar.get(5));
        String string4 = String.valueOf(calendar.get(1));
        this.load(string, KEY_FROM_MON, this.fromMonBox, string2);
        this.load(string, KEY_FROM_DAY, this.fromDayBox, string3);
        this.load(string, KEY_FROM_YEAR, this.fromYearBox, string4);
        this.load(string, KEY_FROM_HOUR, this.fromHourBox, "00");
        this.load(string, KEY_FROM_MIN, this.fromMinBox, "00");
        this.load(string, KEY_FROM_SEC, this.fromSecBox, "00");
        this.load(string, KEY_TO_MON, this.toMonBox, string2);
        this.load(string, KEY_TO_DAY, this.toDayBox, string3);
        this.load(string, KEY_TO_YEAR, this.toYearBox, string4);
        this.load(string, KEY_TO_HOUR, this.toHourBox, "23");
        this.load(string, KEY_TO_MIN, this.toMinBox, "59");
        this.load(string, KEY_TO_SEC, this.toSecBox, "59");
        this.setEnabledTime(this.isTimeEnabled());
    }

    private void setEnabledTime(boolean bl) {
        this.fromDateLbl.setEnabled(bl);
        this.fromMonBox.setEnabled(bl);
        this.fromDayBox.setEnabled(bl);
        this.fromYearBox.setEnabled(bl);
        this.fromHourBox.setEnabled(bl);
        this.fromMinBox.setEnabled(bl);
        this.fromSecBox.setEnabled(bl);
        this.toDateLbl.setEnabled(bl);
        this.toMonBox.setEnabled(bl);
        this.toDayBox.setEnabled(bl);
        this.toYearBox.setEnabled(bl);
        this.toHourBox.setEnabled(bl);
        this.toMinBox.setEnabled(bl);
        this.toSecBox.setEnabled(bl);
        this.prefs.setBoolean(this.eventFilter.getPreference(), "TIME_FILTER_ENABLED", bl);
    }

    public AbstractMatcher createSeverityMatcher() {
        ArrayList<AbstractMatcher> arrayList = new ArrayList<AbstractMatcher>();
        if (this.crBox.getValue().equals("1")) {
            arrayList.add(this.eventFilter.createSeverityMatcher(new Integer(4)));
        }
        if (this.mjBox.getValue().equals("1")) {
            arrayList.add(this.eventFilter.createSeverityMatcher(new Integer(3)));
        }
        if (this.mnBox.getValue().equals("1")) {
            arrayList.add(this.eventFilter.createSeverityMatcher(new Integer(2)));
        }
        if (this.naBox.getValue().equals("1")) {
            arrayList.add(this.eventFilter.createSeverityMatcher(new Integer(1)));
        }
        if (this.nrBox.getValue().equals("1")) {
            arrayList.add(this.eventFilter.createSeverityMatcher(new Integer(0)));
        }
        if (arrayList.size() > 0) {
            return this.eventFilter.createOrMatcher(arrayList);
        }
        return null;
    }

    public AbstractMatcher createSAMatcher() {
        ArrayList<AbstractMatcher> arrayList = new ArrayList<AbstractMatcher>();
        if (this.saBox != null && this.saBox.getValue().equals("1")) {
            arrayList.add(this.eventFilter.createSAMatcher(true));
        }
        if (this.nsaBox != null && this.nsaBox.getValue().equals("1")) {
            arrayList.add(this.eventFilter.createSAMatcher(false));
        }
        if (arrayList.size() > 0) {
            return this.eventFilter.createOrMatcher(arrayList);
        }
        return null;
    }

    public boolean onValidate(Container container) {
        long l;
        long l2;
        boolean bl = super.onValidate(container);
        if (bl && this.isTimeEnabled() && (l2 = this.getStartTime()) >= (l = this.getEndTime())) {
            ErrorMsg.displayWarning((Component)this.getTopLevelAncestor(), (EID)CEMC.WID_FILTER_INVALID_ENTRY_PARAM_1, "\nYou must enter a 'From' date and time that is\nearlier than the 'To' date and time.");
            bl = false;
        }
        return bl;
    }

    protected long getStartTime() {
        if (this.isTimeEnabled()) {
            return EventFilter.convertStringDateToLong(this.fromYearBox.getValue().toString(), this.fromMonBox.getValue().toString(), this.fromDayBox.getValue().toString(), this.fromHourBox.getValue().toString(), this.fromMinBox.getValue().toString(), this.fromSecBox.getValue().toString());
        }
        return 0L;
    }

    protected long getEndTime() {
        if (this.isTimeEnabled()) {
            return EventFilter.convertStringDateToLong(this.toYearBox.getValue().toString(), this.toMonBox.getValue().toString(), this.toDayBox.getValue().toString(), this.toHourBox.getValue().toString(), this.toMinBox.getValue().toString(), this.toSecBox.getValue().toString());
        }
        return 0L;
    }

    public AbstractMatcher createTimeMatcher() {
        AbstractMatcher abstractMatcher = null;
        if (this.isTimeEnabled()) {
            long l = this.getStartTime();
            long l2 = this.getEndTime();
            abstractMatcher = this.eventFilter.createTimeMatcher(new Long(l), new Long(l2));
        }
        return abstractMatcher;
    }

    public boolean isTimeEnabled() {
        String string = this.timeEnableBox.getValue().toString();
        return string.equals("1");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() == this.timeEnableBox) {
            this.setEnabledTime(this.isTimeEnabled());
        }
    }

    public CSHelpID getHelpID() {
        if (this.eventFilter.getType() == 2) {
            return CSHelpConstCom.ConditionFilterGeneralPane;
        }
        if (this.eventFilter.getType() == 3) {
            return CSHelpConstCom.HistoryFilterGeneralPane;
        }
        return CSHelpConstCom.AlarmFilterGeneralPane;
    }

    public void dispose() {
        this.timeEnableBox.removePropertyChangeListener(this);
        this.crBox.removePropertyChangeListener(this);
        this.mjBox.removePropertyChangeListener(this);
        this.mnBox.removePropertyChangeListener(this);
        this.naBox.removePropertyChangeListener(this);
        this.nrBox.removePropertyChangeListener(this);
        this.saBox.removePropertyChangeListener(this);
        this.nsaBox.removePropertyChangeListener(this);
        this.fromMonBox.removePropertyChangeListener(this);
        this.fromDayBox.removePropertyChangeListener(this);
        this.fromYearBox.removePropertyChangeListener(this);
        this.fromHourBox.removePropertyChangeListener(this);
        this.fromMinBox.removePropertyChangeListener(this);
        this.fromSecBox.removePropertyChangeListener(this);
        this.toMonBox.removePropertyChangeListener(this);
        this.toDayBox.removePropertyChangeListener(this);
        this.toYearBox.removePropertyChangeListener(this);
        this.toHourBox.removePropertyChangeListener(this);
        this.toMinBox.removePropertyChangeListener(this);
        this.toSecBox.removePropertyChangeListener(this);
        this.timeEnableBox = null;
        this.crBox = null;
        this.mjBox = null;
        this.mnBox = null;
        this.naBox = null;
        this.nrBox = null;
        this.saBox = null;
        this.nsaBox = null;
        this.fromMonBox = null;
        this.fromDayBox = null;
        this.fromYearBox = null;
        this.fromHourBox = null;
        this.fromMinBox = null;
        this.fromSecBox = null;
        this.toMonBox = null;
        this.toDayBox = null;
        this.toYearBox = null;
        this.toHourBox = null;
        this.toMinBox = null;
        this.toSecBox = null;
        this.removeAll();
    }

    class FilterSpinPropertyEditor
    extends SpinPropertyEditor {
        public FilterSpinPropertyEditor(String string, String string2, String string3, int n, int n2, int n3) {
            super(string, n, n2, n3);
            this.txtInput.setToolTipText(string3);
            this.txtInput.getAccessibleContext().setAccessibleDescription(string2);
        }

        public boolean onValidate() {
            if (!this.isEnabled()) {
                return true;
            }
            String string = this.txtInput.getAccessibleContext().getAccessibleDescription();
            if (this.min != 0) {
                try {
                    int n = Integer.parseInt(this.txtInput.getText());
                    if (n < this.min) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    ErrorMsg.displayWarning((Component)this.getTopLevelAncestor(), (EID)CEMC.WID_FILTER_INVALID_ENTRY_PARAM_1, string);
                    return false;
                }
            }
            if (this.txtInput.getText().length() == 0) {
                ErrorMsg.displayWarning((Component)this.getTopLevelAncestor(), (EID)CEMC.WID_FILTER_INVALID_ENTRY_PARAM_1, string);
                return false;
            }
            return true;
        }
    }
}

