/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.fcmr;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.FCMedia.sFCLineAdminInfo;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.FcmrModuleModel;
import cerent.cms.model.FcmrPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.table.AbstractTableModel;

public class FcmrLineMaintTableModel
extends AbstractTableModel {
    private FcmrModuleModel eqpmtModel = null;
    private FcmrPortModel[] portModels = null;
    private FcmrLineModel[] lineModels = null;
    private boolean[] rowDirty = null;
    private int numLines = 0;
    private int numPorts = 0;
    private sFCLineAdminInfo[] lineAdminInfo = null;
    private AdminState[] adminState = null;
    private IServiceState[] serviceState = null;
    public String[] columnNames = new String[]{"Port", "Admin State", "Service State", "Loopback Type"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int ADMIN_STATE_INDEX = 1;
    public static final int SERVICE_STATE_INDEX = 2;
    public static final int LOOPBACK_INDEX = 3;
    private static final SDebug db = new SDebug("FcmrLineMaintTableModel");
    static /* synthetic */ Class class$java$lang$Object;

    public FcmrLineMaintTableModel(FcmrModuleModel fcmrModuleModel, FcmrPortModel[] fcmrPortModelArray, FcmrLineModel[] fcmrLineModelArray) {
        this.portModels = fcmrPortModelArray;
        this.lineModels = fcmrLineModelArray;
        this.numPorts = fcmrPortModelArray == null ? 0 : fcmrPortModelArray.length;
        this.numLines = fcmrLineModelArray == null ? 0 : fcmrLineModelArray.length;
        this.eqpmtModel = fcmrModuleModel;
        this.rowDirty = new boolean[this.numPorts];
        this.adminState = new AdminState[this.numPorts];
        this.serviceState = new IServiceState[this.numPorts];
        this.lineAdminInfo = new sFCLineAdminInfo[this.numPorts];
        this.resetRowDirty();
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.portModels != null && this.numPorts > 0 && n < this.numLines && AbstractPane.isUserAuthorized(this.portModels[0], SecurityLevel.MAINTENANCE)) {
            if (n2 == 3 && this.eqpmtModel.getCardOperMode() == eCardOperMode.OPER_MODE_FCMR_NO_DIST_EXTN) {
                return false;
            }
            try {
                return n2 == 1 || n2 == 3 && AdminState.admitsLoopback(this.getAdminStateFor(n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public sFCLineAdminInfo getLineAdminInfo(int n) throws NoSuchInterface, WrongInterfaceType {
        if (this.lineAdminInfo[n] == null) {
            this.lineAdminInfo[n] = this.lineModels[n].getFcLineAdminInfo();
        }
        if (!AdminState.admitsLoopback(this.getAdminStateFor(n))) {
            this.lineAdminInfo[n].portLoopback = eLoopback.NO_LOOPBACK;
        }
        return this.lineAdminInfo[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private Integer getLineNumberFor(int n) {
        return new Integer(n + 1);
    }

    private AdminState getAdminState(int n) throws NoSuchInterface {
        if (this.adminState[n] == null) {
            eAdminState eAdminState2 = this.getAdminStateFromModel(n);
            this.adminState[n] = AdminState.enumToAdminState(eAdminState2);
        }
        return this.adminState[n];
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        if (this.serviceState[n] == null) {
            sServiceState sServiceState2 = this.getServiceStateFromModel(n);
            this.serviceState[n] = ServiceStateFactory.getServiceState(sServiceState2);
        }
        return this.serviceState[n];
    }

    protected eAdminState getAdminStateFromModel(int n) throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.portModels[n].getInterfaceModel();
        return interfaceModel.getAdminStateEnum();
    }

    protected sServiceState getServiceStateFromModel(int n) throws NoSuchInterface {
        InterfaceModel interfaceModel = (InterfaceModel)this.portModels[n].getInterfaceModel();
        return interfaceModel.getServiceState();
    }

    public eAdminState getAdminStateFor(int n) throws NoSuchInterface {
        return this.getAdminState(n).getAdminStateEnum();
    }

    public int getLoopbackFor(int n) throws NoSuchInterface, WrongInterfaceType {
        return this.getLoopback(n).getIntValue();
    }

    private Attribute getLoopback(int n) throws NoSuchInterface, WrongInterfaceType {
        this.getLineAdminInfo(n);
        return this.getAttributeFor("G1000 Loopback Type", this.getLineAdminInfo((int)n).portLoopback.value());
    }

    private Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }

    public int getRowCount() {
        return this.numPorts;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = FcmrLineMaintTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object getValueAt(int n, int n2) {
        block8: {
            try {
                switch (n2) {
                    case 0: {
                        return this.getLineNumberFor(n);
                    }
                    case 3: {
                        return this.getLoopback(n);
                    }
                    case 1: {
                        return this.getAdminState(n).toString(this.getTerms());
                    }
                    case 2: {
                        return this.getServiceState(n).toString(this.getTerms());
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block8;
                db.println("Error in getValueAt in FcmrPortTableModel " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                this.adminState[n] = (AdminState)object;
                break;
            }
            case 3: {
                if (!(object instanceof Attribute)) break;
                int n3 = ((Attribute)object).getIntValue();
                try {
                    this.getLineAdminInfo((int)n).portLoopback = eLoopback.from_int(n3);
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n] = true;
        this.fireTableRowsUpdated(n, n);
    }

    public void resetRowDirty() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void refreshLineFromModel(int n) {
        this.lineAdminInfo[n] = null;
        this.adminState[n] = null;
        this.serviceState[n] = null;
        this.fireTableRowsUpdated(n, n);
    }

    public void refresh() {
        for (int i = 0; i < this.numLines; ++i) {
            this.lineAdminInfo[i] = null;
            this.adminState[i] = null;
            this.serviceState[i] = null;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public void destroy() {
        this.portModels = null;
        this.lineModels = null;
        this.eqpmtModel = null;
        this.rowDirty = null;
        for (int i = 0; i < this.lineAdminInfo.length; ++i) {
            this.lineAdminInfo[i] = null;
            this.adminState[i] = null;
            this.serviceState[i] = null;
        }
        this.lineAdminInfo = null;
        this.adminState = null;
        this.serviceState = null;
    }

    private TDMTerminology getTerms() {
        return this.eqpmtModel.getNodeModel().getTDMTerminology();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

