/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.l2sc;

import cerent.cms.idl.Equipment.eCardOperMode;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.L2scModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class L2scCardProvPane
extends NodeProvPane
implements ActionListener {
    private JComboBox modeCB = null;
    private static final String[] modeChoices = new String[]{"HDLC", "GFP-F"};
    private static final int HDLC = 0;
    private static final int GFP_F = 1;
    private L2scModuleModel model = (L2scModuleModel)this.getParentView().getUiModel();
    private static final String errMsg = "Card is in use";
    private static final String warnMsg = "This action will reboot the card.  Continue?";
    private static final String warnTitle = "Card will reboot.";
    private boolean modeDirty = false;

    public L2scCardProvPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        JPanel jPanel = new JPanel(new FlowLayout(0, 10, 10));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(new JLabel("Mode: "));
        this.modeCB = new JComboBox<String>(modeChoices);
        Dimension dimension = new Dimension(100, 20);
        this.modeCB.setPreferredSize(dimension);
        this.modeCB.setMinimumSize(dimension);
        this.modeCB.setMaximumSize(dimension);
        this.modeCB.addActionListener(this);
        this.showCurrentMode();
        jPanel.add(this.modeCB);
        this.add(jPanel);
    }

    private void showCurrentMode() {
        eCardOperMode eCardOperMode2 = this.model.getCardOperMode();
        if (eCardOperMode2 == eCardOperMode.OPER_MODE_ML_GFP_F) {
            this.modeCB.setSelectedItem(modeChoices[1]);
        } else {
            this.modeCB.setSelectedItem(modeChoices[0]);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == null) {
            db.severe("Null actionPerformed source");
            return;
        }
        if (object == this.modeCB) {
            this.modeDirty = true;
        }
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangesToModel() throws Exception {
        if (this.modeDirty) {
            boolean bl = true;
            if (this.model.getState() != eEqState.NOT_PRESENT) {
                bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)warnMsg, (String)warnTitle);
            }
            if (!bl) {
                this.refresh();
                return;
            }
            try {
                Object object = this.modeCB.getSelectedItem();
                if (object.equals(modeChoices[0])) {
                    this.model.setCardOperMode(eCardOperMode.OPER_MODE_ML_HDLC);
                } else if (object.equals(modeChoices[1])) {
                    this.model.setCardOperMode(eCardOperMode.OPER_MODE_ML_GFP_F);
                } else if (db.on()) {
                    db.println("Wrong card mode");
                }
                this.modeDirty = false;
            }
            catch (ResourceInUse resourceInUse) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_BLOCKED_BY_CKTS_PARAM_1, (Object)errMsg);
                this.refresh();
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PROVISION_ERROR);
                this.refresh();
            }
            catch (CTCUserException cTCUserException) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_APPLY_CHANGES);
                this.refresh();
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    public void refreshFromModel() throws Exception {
        this.showCurrentMode();
        this.modeDirty = false;
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.L2scCardProvPane;
    }
}

