/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.ml2;

import cerent.cms.model.ML2ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.ml2.ML2PortGraphic;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Observable;
import javax.swing.JPopupMenu;

public class ML2Card
extends CardGraphic
implements ActionListener {
    private static final int HORIZONTAL_CARD_PG_Y_OFFSET = 38;
    private static final int HORIZONTAL_CARD_PG_X_OFFSET = 12;
    private static final int PORT_SIZE = 22;
    private static final int PORT_SPACING = 4;
    private PortModel[] portModels = null;
    protected ML2PortGraphic[] portGraphics = null;

    public ML2Card(ML2ModuleModel mL2ModuleModel, AbstractShelfLayout abstractShelfLayout) {
        super(mL2ModuleModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "ML2Card:" + mL2ModuleModel.getSlot()));
        this.portModels = mL2ModuleModel.getEtherPortModels();
        this.portGraphics = new ML2PortGraphic[this.portModels.length];
        if (this.pci.positionPortsVertically()) {
            int n = 0;
            for (int i = 0; i < this.portModels.length; ++i) {
                n = i > 3 ? (this.cardPainter.getMiniOpticonYSpacing() - this.cardPainter.getMiniPortHeight()) * 2 : 0;
                this.portGraphics[i] = new ML2PortGraphic(this, this.cardPainter.getMultiPortOpticonXOffset() + this.cardPainter.getOpticonXSpacing() * i, this.cardPainter.getMiniOpticonYOffset() + (this.cardPainter.getMiniOpticonYSpacing() * i + n), this.cardPainter.getMiniPortWidth(), this.cardPainter.getMiniPortHeight(), this.portModels[i]);
            }
        } else {
            int n = 12;
            for (int i = 0; i < this.portModels.length; ++i) {
                this.portGraphics[i] = new ML2PortGraphic(this, n, 38, 22, 22, this.portModels[i]);
                n += i == 3 ? 38 : 26;
            }
        }
        this.alarmStore = this.getCardAlarmStore();
        if (this.hasProvisionedCard()) {
            this.alarmStore.enablePortAlarmsStatus(mL2ModuleModel);
            this.update(this.alarmStore.getAlarmStatusObservable(), this.alarmStore.getAlarmStatus());
        }
    }

    private ML2ModuleModel getModule() {
        return (ML2ModuleModel)this.getModel();
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
        if (!this.getModule().isInMapperMode()) {
            jPopupMenu.addSeparator();
            boolean bl = this.eqState.value() == 5 || this.eqState.value() == 4;
            boolean bl2 = AbstractPane.isUserAuthorized(this.getModule(), SecurityLevel.PROVISIONING);
            jPopupMenu.add(this.makeMenuAction("Open IOS Connection...", bl && bl2));
            jPopupMenu.add(this.makeMenuAction("IOS Startup Config...", bl2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Open IOS Connection...")) {
            CardBehavior cardBehavior = this.pci.getCardBehavior(this.getModule().getNodeModelDelegate(), this.db);
            cardBehavior.openIOS(this.getModule());
        } else if (actionEvent.getActionCommand().equals("IOS Startup Config...")) {
            CardBehavior cardBehavior = this.pci.getCardBehavior(this.getModule().getNodeModelDelegate(), this.db);
            cardBehavior.openIOSConfig(this.parent, this.getModule());
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.portGraphics.length; ++i) {
                if (this.portGraphics[i] == null || !this.portGraphics[i].contains(mouseEvent.getPoint())) continue;
                return this.portGraphics[i].getTooltipText();
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return "";
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (object instanceof AlarmStatus && this.portModels != null && this.portGraphics != null) {
            for (int i = 0; i < this.portModels.length; ++i) {
                PortModel portModel = this.portModels[i];
                IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(portModel);
                if (iAlarmStatus == null) continue;
                if (this.db.on()) {
                    int n = this.entityM.getSlot();
                    this.db.println("SlotNo=" + n + ", PortNo=" + portModel.getPort() + ", portEqType=" + portModel.getEqType() + ", AlarmStatus=" + iAlarmStatus + ", highest=" + iAlarmStatus.getHighestSeverity());
                }
                this.portGraphics[i].setAlarmState(iAlarmStatus.getHighestSeverity());
            }
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (!this.pci.positionPortsVertically()) {
                graphics2D.drawRect(8, 34, 108, 30);
                graphics2D.drawRect(124, 34, 108, 30);
            }
            for (int i = 0; i < this.portGraphics.length; ++i) {
                this.portGraphics[i].draw(graphics2D);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("disposing");
        }
        for (int i = 0; i < this.portGraphics.length; ++i) {
            this.portGraphics[i].dispose();
            this.portGraphics[i] = null;
        }
        if (this.hasProvisionedCard()) {
            this.alarmStore.disablePortAlarmsStatus();
        }
        super.dispose();
    }
}

