/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sStsInfo;
import cerent.cms.idl.SonetMedia.sPathStats;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.LinePathHolder;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.HoLoFactory;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import javax.swing.SwingUtilities;

public abstract class PmLayerHoPath
extends PmLayer {
    protected sPathStats[] statsVal;
    protected TdmHoModel model = null;
    protected LinePathHolder lpHolder = null;
    protected int numParms;
    protected int numRegisters;
    protected boolean lpHolderValid;
    public static final int CV_P_INDEX = 0;
    public static final int ES_P_INDEX = 1;
    public static final int FC_P_INDEX = 2;
    public static final int SES_P_INDEX = 3;
    public static final int UAS_P_INDEX = 4;
    public static final int PPJC_PDET_P_INDEX = 5;
    public static final int NPJC_PDET_P_INDEX = 6;
    public static final int PPJC_PGEN_P_INDEX = 7;
    public static final int NPJC_PGEN_P_INDEX = 8;
    public static final int PJC_DIFF_P_INDEX = 9;
    public static final int PJCS_PDET_P_INDEX = 10;
    public static final int PJCS_PGEN_P_INDEX = 11;
    public static final int SDH_SES_P_INDEX = 2;
    public static final int SDH_UAS_P_INDEX = 3;
    public static final int SDH_BBE_P_INDEX = 4;
    public static final int SDH_PPJC_PDET_P_INDEX = 5;
    public static final int SDH_NPJC_PDET_P_INDEX = 6;
    public static final int SDH_PPJC_PGEN_P_INDEX = 7;
    public static final int SDH_NPJC_PGEN_P_INDEX = 8;
    public static final int SDH_PJC_DIFF_P_INDEX = 9;
    public static final int SDH_PJCS_PDET_P_INDEX = 10;
    public static final int SDH_PJCS_PGEN_P_INDEX = 11;
    public static final int SDH_ESR_P_INDEX = 12;
    public static final int SDH_SESR_P_INDEX = 13;
    public static final int SDH_BBER_P_INDEX = 14;
    public static final int NUM_SDH_ONLY_PARAMS = 3;
    protected static final sPathStats _defaultPathStats = new sPathStats(false, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
    protected static final sPathStats _badPathStats = new sPathStats(false, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
    protected static final SDebug db = new SDebug("PmLayerHoPath");

    public PmLayerHoPath(PmTableModel pmTableModel, Object object, int n, boolean bl) {
        super(pmTableModel, object, bl);
        if (object instanceof TdmHoModel) {
            this.model = (TdmHoModel)object;
        } else if (object instanceof LinePathHolder) {
            this.lpHolder = (LinePathHolder)object;
        }
        this.lpHolderValid = true;
        this.numRegisters = n;
        this.numParms = this.parmCount();
        this.statsVal = new sPathStats[n];
        this.tossData();
    }

    public PmLayerHoPath(PmTableModel pmTableModel, Object object, int n) {
        this(pmTableModel, object, n, false);
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.model != null) {
            this.model.clearStats(this.nearEnd, this.intervalType);
        }
    }

    protected TDMTerminology getTdmTerm() {
        if (this.lpHolder != null) {
            return this.lpHolder.getLineModel().getNodeModel().getTDMTerminology();
        }
        return this.model.getNodeModel().getTDMTerminology();
    }

    public String layerLabel() {
        String string = "STS";
        TDMTerminology tDMTerminology = this.getTdmTerm();
        string = tDMTerminology.getGeneralTerms(0);
        return string;
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.statsVal[n] == null || this.statsVal[n] == _defaultPathStats) {
            boolean bl;
            block10: {
                bl = this.fromPeerCard;
                this.statsVal[n] = _defaultPathStats;
                try {
                    if (this.model != null) {
                        this.statsVal[n] = this.model.getStats(this.nearEnd, this.intervalType, (short)n);
                        break block10;
                    }
                    if (this.lpHolder != null && this.lpHolderValid) {
                        try {
                            TdmLineModel tdmLineModel = this.lpHolder.getLineModel();
                            IPortModel iPortModel = tdmLineModel.getPortModel();
                            int n2 = tdmLineModel.getNodeModel().getFramingType();
                            short s = this.lpHolder.getHoNum();
                            short s2 = HoLoFactory.ho2HoNum(n2, s).getIdlHoNum();
                            sStsInfo sStsInfo2 = new sStsInfo();
                            sStsInfo2.index = iPortModel.getIndex();
                            sStsInfo2.sts = s2;
                            this.statsVal[n] = tdmLineModel.getBlsrProtectPathStats(sStsInfo2, this.nearEnd, this.intervalType, (short)n);
                            if (db.on()) {
                                db.println("BlsrProtectPm on p" + Integer.toHexString(sStsInfo2.index) + "/S" + s2 + "\tInt = " + n + "\tES=" + this.statsVal[n].es.cnt + (this.statsVal[n].es.valid ? "" : "*") + "\tSES=" + this.statsVal[n].ses.cnt + (this.statsVal[n].ses.valid ? "" : "*") + "\tCV=" + this.statsVal[n].cv.cnt + (this.statsVal[n].cv.valid ? "" : "*") + "\tUAS=" + this.statsVal[n].uas.cnt + (this.statsVal[n].uas.valid ? "" : "*") + "\tFC=" + this.statsVal[n].fc.cnt + (this.statsVal[n].fc.valid ? "" : "*"));
                            }
                            break block10;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            SDebug.printStackTrace((Throwable)unsupportedOperation);
                            this.lpHolderValid = false;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    PmLayerHoPath.this.refreshParent();
                                }
                            });
                        }
                        break block10;
                    }
                    db.println("PmLayerHoPath::refreshPmStats(), model AND lpHolder were null!");
                }
                catch (InternalCommError internalCommError) {
                    this.statsVal[n] = _badPathStats;
                    throw internalCommError;
                }
            }
            this.fromPeerCard = this.statsVal[n].fromPeerCard;
            if (db.on() && bl != this.fromPeerCard) {
                db.println("STS fromPeerCard changed from " + bl + " to " + this.fromPeerCard);
            }
        }
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmHoModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.statsVal[i] = null;
        }
        this.fromPeerCard = false;
    }

    protected Integer getMuxIndex(int n) {
        return new Integer(n);
    }
}

