/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.pm;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.SonetMedia.sLineStats;
import cerent.cms.idl.SonetMedia.sPhysicalStats;
import cerent.cms.idl.SonetMedia.sSectionStats;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmLineStats;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public abstract class PmLayerTdmLine
extends PmLayer {
    protected sLineStats[] lineStatsVal;
    protected TdmLineModel model = null;
    protected int numRegisters;
    protected int numParms;
    protected int lineParmCount;
    protected int phyParmCount;
    protected sSectionStats[] sectionStatsVal;
    protected sPhysicalStats[] physicalStatsVal;
    public static String[] parmNames;
    public static String[] phyParmNames;
    public static final int CV_S_INDEX = 0;
    public static final int SDH_EB_S_INDEX = 0;
    public static final int ES_S_INDEX = 1;
    public static final int SDH_BBE_S_INDEX = 1;
    public static final int SES_S_INDEX = 2;
    public static final int SDH_ES_S_INDEX = 2;
    public static final int SEFS_S_INDEX = 3;
    public static final int SDH_SES_S_INDEX = 3;
    public static final int CV_L_INDEX = 4;
    public static final int SDH_EB_L_INDEX = 4;
    public static final int ES_L_INDEX = 5;
    public static final int SDH_BBE_L_INDEX = 5;
    public static final int SES_L_INDEX = 6;
    public static final int SDH_ES_L_INDEX = 6;
    public static final int UAS_L_INDEX = 7;
    public static final int SDH_SES_L_INDEX = 7;
    public static final int FC_L_INDEX = 8;
    public static final int SDH_UAS_L_INDEX = 8;
    public static final int PSC_INDEX = 9;
    public static final int PSD_INDEX = 10;
    public static final int PSCW_INDEX = 11;
    public static final int PSDW_INDEX = 12;
    public static final int PSCS_INDEX = 13;
    public static final int PSDS_INDEX = 14;
    public static final int PSCR_INDEX = 15;
    public static final int PSDR_INDEX = 16;
    public static final int LBC_INDEX = 0;
    public static final int OPT_INDEX = 1;
    public static final int OPR_INDEX = 2;
    public static final int NUM_OF_LINE_PARMS = 17;
    public static final int NUM_PHY_PM = 3;
    private static final sSectionStats _defaultSectionStats;
    private static final sLineStats _defaultLineStats;
    private static final sPhysicalStats _defaultPhysicalStats;
    private static final SDebug db;

    public PmLayerTdmLine(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n, boolean bl) {
        super(pmTableModel, tdmLineModel, bl);
        this.model = tdmLineModel;
        this.initParms();
        this.numRegisters = n;
        this.sectionStatsVal = new sSectionStats[n];
        this.lineStatsVal = new sLineStats[n];
        this.physicalStatsVal = new sPhysicalStats[n];
        this.tossData();
    }

    public PmLayerTdmLine(PmTableModel pmTableModel, TdmLineModel tdmLineModel, int n) {
        this(pmTableModel, tdmLineModel, n, true);
    }

    protected void initParms() {
        this.initLineParamNames();
        this.initParamCount();
    }

    protected abstract void initLineParamNames();

    protected void initParamCount() {
        this.lineParmCount = 17;
        this.phyParmCount = 0;
        try {
            int n = this.model.getModuleModel().getEqType();
            if (n == 9) {
                this.lineParmCount = 11;
            } else if (n == 10 || n == 85) {
                this.lineParmCount = 13;
            } else if (n == 118 || n == 120 || n == 121 || n == 181 || n == 182 || n == 119) {
                this.lineParmCount = 9;
            } else if (n == 157) {
                this.lineParmCount = 11;
            }
            this.phyParmCount = this.model.supportsPhysicalPm() ? 3 : 0;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.println("Caught AbstractCmsNoSuchEntityException. Could not get ModuleModel");
        }
        this.numParms = this.lineParmCount + this.phyParmCount;
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearStats(this.nearEnd, this.intervalType);
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.sectionStatsVal[n] == null || this.lineStatsVal[n] == null || this.physicalStatsVal[n] == null || this.sectionStatsVal[n] == _defaultSectionStats || this.lineStatsVal[n] == _defaultLineStats || this.physicalStatsVal[n] == _defaultPhysicalStats) {
            this.sectionStatsVal[n] = _defaultSectionStats;
            this.lineStatsVal[n] = _defaultLineStats;
            this.physicalStatsVal[n] = _defaultPhysicalStats;
            try {
                TdmLineStats tdmLineStats = this.model.getStats(this.nearEnd, this.intervalType, (short)n);
                this.sectionStatsVal[n] = tdmLineStats.sectionStats;
                this.lineStatsVal[n] = tdmLineStats.lineStats;
                this.physicalStatsVal[n] = tdmLineStats.physicalStats;
            }
            catch (InternalCommError internalCommError) {
                this.sectionStatsVal[n] = new sSectionStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
                this.lineStatsVal[n] = new sLineStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
                this.physicalStatsVal[n] = new sPhysicalStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                throw internalCommError;
            }
            if (db.on() && n == 0) {
                this.printStats(0);
            }
        }
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        Object object = new PmRendererStat(PM_STATS_INVALID);
        if (n < this.lineParmCount) {
            object = this.getLinePmValue(n, n2);
        } else if ((n -= this.lineParmCount) < this.phyParmCount) {
            object = this.getPhysicalPmValue(n, n2);
        }
        return object;
    }

    protected abstract Object getLinePmValue(int var1, int var2) throws NoSuchInterface, WrongInterfaceType, InternalCommError;

    protected Object getPhysicalPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_INVALID;
        switch (n) {
            case 0: {
                sPmStat2 = this.physicalStatsVal[n2].lbc;
                break;
            }
            case 1: {
                sPmStat2 = this.physicalStatsVal[n2].opt;
                break;
            }
            case 2: {
                sPmStat2 = this.physicalStatsVal[n2].opr;
                break;
            }
            default: {
                db.println("WARNING: PmLayerTdmLine.getPmValue needs updating, unknown value " + n);
            }
        }
        return new PmRendererStat(sPmStat2);
    }

    public String parmName(int n) {
        String string = "";
        if (n < this.lineParmCount) {
            string = parmNames[n];
        } else if ((n -= this.lineParmCount) < this.phyParmCount) {
            string = phyParmNames[n];
        }
        return string;
    }

    public int parmCount() {
        return this.numParms;
    }

    private void printStats(int n) {
        db.println("Section sefs=" + this.strPmStat(this.sectionStatsVal[n].sefs) + " ses" + this.strPmStat(this.sectionStatsVal[n].ses) + " es" + this.strPmStat(this.sectionStatsVal[n].es) + " cv" + this.strPmStat(this.sectionStatsVal[n].cv));
        db.println("Line cv=" + this.strPmStat(this.lineStatsVal[n].cv) + " es=" + this.strPmStat(this.lineStatsVal[n].es) + " ses=" + this.strPmStat(this.lineStatsVal[n].ses) + " uas=" + this.strPmStat(this.lineStatsVal[n].uas) + " fc=" + this.strPmStat(this.lineStatsVal[n].fc));
        db.println("Physical lbc=" + this.strPmStat(this.physicalStatsVal[n].lbc) + " opt=" + this.strPmStat(this.physicalStatsVal[n].opt) + " opr=" + this.strPmStat(this.physicalStatsVal[n].opr));
    }

    private String strPmStat(sPmStat sPmStat2) {
        if (sPmStat2.valid) {
            return Integer.toString(sPmStat2.cnt);
        }
        return "#";
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (TdmLineModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.sectionStatsVal[i] = null;
            this.lineStatsVal[i] = null;
            this.physicalStatsVal[i] = null;
        }
    }

    static {
        phyParmNames = new String[]{"LBC", "OPT", "OPR"};
        _defaultSectionStats = new sSectionStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
        _defaultLineStats = new sLineStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID, PM_STATS_RATIO_INVALID);
        _defaultPhysicalStats = new sPhysicalStats(PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
        db = new SDebug("PmLayerTdmLine");
    }
}

