/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.rmon;

import cerent.cms.idl.Rmon.eAlarmSampleType;
import cerent.cms.idl.Rmon.eAlarmType;
import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sAlarmAdminInfo;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.DuplicateAlarm;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ML2PosPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.RmonThresholdManager;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.rmon.RmonThresholdColumnRenderer;
import cerent.cms.ui.rmon.RmonThresholdDataSource;
import cerent.cms.ui.rmon.RmonThresholdTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.IntegerPropertyEditor;
import cerent.util.gui.UComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class RmonThresholdCreateDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final String TITLE = "Create Threshold";
    public static final String OK = "OK";
    public static final String CANCEL = "Cancel";
    public static final int MARGIN = 5;
    private static final String SLOT = "Slot:";
    private static final String PORT = "Port:";
    private static final String VARIABLE = "Variable:";
    private static final String ALARM_TYPE = "Alarm Type:";
    private static final String SAMPLE_TYPE = "Sample Type:";
    private static final String INTERVAL = "Sample Period:";
    private static final String RISING_THRESHOLD = "Rising Threshold:";
    private static final String FALLING_THRESHOLD = "Falling Threshold:";
    private static final SDebug db = new SDebug("RmonThresholdCreateDialog");
    private static String ALL = "All";
    private static final int MAX_ROW_COUNT = 25;
    private ArrayList rmonTypeList;
    private ArrayList slotList;
    private JButton okButton;
    private JButton cancelButton;
    private UComboBox slotCB;
    private UComboBox portCB;
    private UComboBox variableCB;
    private UComboBox alarmTypeCB;
    private UComboBox sampleTypeCB;
    IntegerPropertyEditor intervalEdit;
    IntegerPropertyEditor risingThresholdEdit;
    IntegerPropertyEditor fallingThresholdEdit;
    private RmonThresholdTableModel dataModel;
    private RmonThresholdManager rtm;
    private NodeModelDelegate nodeModel;
    private ModuleModel module;
    private ModuleModel observedModule;
    private AttributeMaps attrMap;
    private eStatsId[] stats;
    private PortModel[] validPorts;

    public RmonThresholdCreateDialog(Frame frame, ModuleModel moduleModel, RmonThresholdTableModel rmonThresholdTableModel) {
        this(frame, moduleModel, rmonThresholdTableModel, null);
    }

    public RmonThresholdCreateDialog(Frame frame, ModuleModel moduleModel, RmonThresholdTableModel rmonThresholdTableModel, PortModel[] portModelArray) {
        super(frame, TITLE, true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RmonThresholdCreateDialog.this.dispose();
            }
        });
        this.module = moduleModel;
        this.nodeModel = moduleModel.getNodeModelDelegate();
        this.dataModel = rmonThresholdTableModel;
        this.rtm = RmonThresholdManager.getInstance(this.nodeModel);
        this.validPorts = portModelArray != null ? portModelArray : moduleModel.getPortModels();
        this.attrMap = RmonThresholdColumnRenderer.getRmonAttributeMaps();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.createAttributesPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = itemEvent.getSource();
            if (object == this.slotCB) {
                if (this.slotCB.getSelectedIndex() >= 0) {
                    if (this.portCB.getItemCount() > 0) {
                        this.portCB.removeAllItems();
                    }
                    for (int i = 0; i < this.validPorts.length; ++i) {
                        this.portCB.addItem((Object)this.validPorts[i]);
                    }
                    if (this.module.getEqType() != 183 && this.module.getEqType() != 184 && this.validPorts.length > 0 && !(this.validPorts[0] instanceof ML2PosPortModel)) {
                        this.portCB.addItem((Object)ALL);
                    }
                    this.portCB.setEnabled(true);
                }
            } else if (object == this.portCB) {
                try {
                    this.setVariableCB();
                }
                catch (Exception exception) {
                    if (RmonThresholdCreateDialog.db.on) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    this.variableCB.setEnabled(false);
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_NO_RMON_THRESHOLDS_AVAILABLE);
                }
            } else if (object == this.alarmTypeCB) {
                try {
                    this.setAlarmCB();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private void setAlarmCB() {
        if (this.alarmTypeCB == null) {
            return;
        }
        Attribute attribute = (Attribute)this.alarmTypeCB.getSelectedItem();
        String string = attribute.getIntValue() == 2 || attribute.getIntValue() == 3 ? "RmonAlarmSampleTypeForFalling" : "RmonAlarmSampleType";
        if (this.sampleTypeCB.getItemCount() > 0) {
            this.sampleTypeCB.removeAllItems();
        }
        Attribute[] attributeArray = this.attrMap.getAttributeArray(string);
        for (int i = 0; i < attributeArray.length; ++i) {
            this.sampleTypeCB.addItem((Object)attributeArray[i]);
        }
        if (attributeArray.length == 1) {
            this.sampleTypeCB.setEnabled(false);
        } else {
            this.sampleTypeCB.setEnabled(true);
        }
    }

    private void setVariableCB() throws Exception {
        Object object = this.portCB.getSelectedItem();
        if (object == null || !(object instanceof PortModel)) {
            return;
        }
        PortModel portModel = (PortModel)this.portCB.getSelectedItem();
        this.stats = this.rtm.getCumulativeStatsIdList(portModel.getIndex());
        String[] stringArray = this.rtm.getStatsIdListStr(this.stats);
        if (this.variableCB.getItemCount() > 0) {
            this.variableCB.removeAllItems();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.variableCB.addItem((Object)stringArray[i]);
        }
        this.variableCB.setEnabled(true);
        this.variableCB.setMaximumRowCount(stringArray.length < 25 ? stringArray.length : 25);
        this.variableCB.setSelectedIndex(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.apply()) {
                this.dispose();
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    private JPanel createAttributesPanel() {
        JPanel jPanel = new JPanel();
        this.slotCB = this.createSlotCombo();
        this.slotCB.setRenderer((ListCellRenderer)new RmonCardRenderer());
        this.portCB = new UComboBox();
        this.portCB.setRenderer((ListCellRenderer)new RmonCardPortRenderer());
        this.portCB.setEnabled(false);
        this.slotCB.addItemListener((ItemListener)this);
        this.portCB.addItemListener((ItemListener)this);
        this.variableCB = new UComboBox();
        this.variableCB.setEnabled(false);
        this.slotCB.setEnabled(false);
        this.itemStateChanged(new ItemEvent((ItemSelectable)this.slotCB, 701, this.slotCB.getSelectedItem(), 1));
        this.alarmTypeCB = this.createComboBox("RmonAlarmType");
        this.alarmTypeCB.addItemListener((ItemListener)this);
        this.sampleTypeCB = this.createComboBox("RmonAlarmSampleType");
        this.sampleTypeCB.addItemListener((ItemListener)this);
        this.sampleTypeCB.setSelectedIndex(1);
        this.intervalEdit = new IntegerPropertyEditor("", "sec.");
        this.intervalEdit.setValue(String.valueOf(10));
        this.risingThresholdEdit = new IntegerPropertyEditor("", "count");
        this.fallingThresholdEdit = new IntegerPropertyEditor("", "count");
        this.intervalEdit.setEditorSize(20);
        this.risingThresholdEdit.setEditorSize(20);
        this.fallingThresholdEdit.setEditorSize(20);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.add(new JLabel(SLOT));
        jPanel2.add(new JLabel(PORT));
        jPanel2.add(new JLabel(VARIABLE));
        jPanel2.add(new JLabel(ALARM_TYPE));
        jPanel2.add(new JLabel(SAMPLE_TYPE));
        jPanel2.add(new JLabel(INTERVAL));
        jPanel2.add(new JLabel(RISING_THRESHOLD));
        jPanel2.add(new JLabel(FALLING_THRESHOLD));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel3.add((Component)this.slotCB);
        jPanel3.add((Component)this.portCB);
        jPanel3.add((Component)this.variableCB);
        jPanel3.add((Component)this.alarmTypeCB);
        jPanel3.add((Component)this.sampleTypeCB);
        jPanel3.add(this.intervalEdit);
        jPanel3.add(this.risingThresholdEdit);
        jPanel3.add(this.fallingThresholdEdit);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton(OK);
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton(CANCEL);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }

    private UComboBox createSlotCombo() {
        ArrayList<ModuleModel> arrayList = new ArrayList<ModuleModel>(0);
        ArrayList<String> arrayList2 = new ArrayList<String>(0);
        TDMTerminology tDMTerminology = this.nodeModel.getTDMTerminology();
        arrayList.add(this.module);
        arrayList2.add(this.module.getSlot() + " (" + EntityModel.eqType2Name(tDMTerminology, this.module.getEqType()) + ")");
        Object[][] objectArray = new Object[arrayList.size()][2];
        for (int i = 0; i < arrayList.size(); ++i) {
            objectArray[i][0] = arrayList2.get(i);
            objectArray[i][1] = arrayList.get(i);
        }
        UComboBox uComboBox = new UComboBox((Object[])objectArray);
        uComboBox.setSelectedIndex(0);
        return uComboBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean apply() {
        PortModel[] portModelArray;
        ModuleModel moduleModel;
        sAlarmAdminInfo sAlarmAdminInfo2;
        RmonThresholdDataSource rmonThresholdDataSource;
        block23: {
            rmonThresholdDataSource = (RmonThresholdDataSource)this.dataModel.getDataSource();
            sAlarmAdminInfo2 = new sAlarmAdminInfo();
            if (this.slotCB.getSelectedIndex() == -1) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"slot");
                this.slotCB.requestFocus();
                return false;
            }
            if (this.portCB.getSelectedIndex() == -1) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"port");
                this.portCB.requestFocus();
                return false;
            }
            if (this.variableCB.getSelectedIndex() == -1) {
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_NOT_SELECTED_PARAM_1, (Object)"variable");
                this.portCB.requestFocus();
                return false;
            }
            Object[] objectArray = (Object[])this.slotCB.getSelectedItem();
            moduleModel = (ModuleModel)objectArray[1];
            Attribute attribute = (Attribute)this.alarmTypeCB.getSelectedItem();
            sAlarmAdminInfo2.alarmType = eAlarmType.from_int(attribute.getIntValue());
            attribute = (Attribute)this.sampleTypeCB.getSelectedItem();
            sAlarmAdminInfo2.sampleType = eAlarmSampleType.from_int(attribute.getIntValue());
            sAlarmAdminInfo2.variable = this.stats[this.variableCB.getSelectedIndex()];
            try {
                try {
                    sAlarmAdminInfo2.interval = Integer.parseInt((String)this.intervalEdit.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    sAlarmAdminInfo2.interval = 10;
                    portModelArray = null;
                    if (sAlarmAdminInfo2.interval < 10) {
                        ErrorMsg.displayError((Component)this, (EID)EMC.EID_MIN_SAMPLE_PERIOD, (Object)Integer.toString(10));
                        this.intervalEdit.requestEditorFocus();
                        return false;
                    }
                    break block23;
                }
                portModelArray = null;
                if (sAlarmAdminInfo2.interval >= 10) break block23;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (sAlarmAdminInfo2.interval >= 10) throw throwable;
                ErrorMsg.displayError((Component)this, (EID)EMC.EID_MIN_SAMPLE_PERIOD, (Object)Integer.toString(10));
                this.intervalEdit.requestEditorFocus();
                return false;
            }
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_MIN_SAMPLE_PERIOD, (Object)Integer.toString(10));
            this.intervalEdit.requestEditorFocus();
            return false;
        }
        try {
            sAlarmAdminInfo2.risingThreshold = Integer.parseInt((String)this.risingThresholdEdit.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_RISING_THRESHOLD_RANGE_PARAM_1, (Object)Integer.toString(Integer.MAX_VALUE));
            return false;
        }
        if (sAlarmAdminInfo2.risingThreshold < 1L) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_RISING_THRESHOLD_RANGE_PARAM_1, (Object)Integer.toString(Integer.MAX_VALUE));
            this.risingThresholdEdit.requestEditorFocus();
            return false;
        }
        try {
            sAlarmAdminInfo2.fallingThreshold = Integer.parseInt((String)this.fallingThresholdEdit.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FALLING_THRESHOLD_RANGE_PARAM_1, (Object)Integer.toString(Integer.MAX_VALUE));
            this.fallingThresholdEdit.requestEditorFocus();
            return false;
        }
        if (sAlarmAdminInfo2.fallingThreshold < 1L) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FALLING_THRESHOLD_RANGE_PARAM_1, (Object)Integer.toString(Integer.MAX_VALUE));
            this.fallingThresholdEdit.requestEditorFocus();
            return false;
        }
        if (sAlarmAdminInfo2.risingThreshold < sAlarmAdminInfo2.fallingThreshold) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_RISING_SMALLER_THAN_FALLING);
            this.risingThresholdEdit.requestEditorFocus();
            return false;
        }
        String string = this.nodeModel.getUserName();
        sAlarmAdminInfo2.alarmOwner = new char[32];
        string.getChars(0, string.length() > 32 ? 31 : string.length(), sAlarmAdminInfo2.alarmOwner, 0);
        if (string.length() > 32) {
            sAlarmAdminInfo2.alarmOwner[31] = '\u0000';
        }
        try {
            Object object = this.portCB.getSelectedItem();
            if (object instanceof PortModel) {
                sAlarmAdminInfo2.ifIndex = ((PortModel)object).getIndex();
                rmonThresholdDataSource.createThreshold(sAlarmAdminInfo2);
                return true;
            }
            if (!(object instanceof String)) return true;
            if (!((String)object).equals(ALL)) return true;
            portModelArray = this.validPorts != null ? this.validPorts : moduleModel.getPortModels();
            int n = 0;
            while (n < portModelArray.length) {
                if (portModelArray[n] instanceof PortModel) {
                    sAlarmAdminInfo2.ifIndex = portModelArray[n].getIndex();
                    rmonThresholdDataSource.createThreshold(sAlarmAdminInfo2);
                }
                ++n;
            }
            return true;
        }
        catch (AnnotatedException annotatedException) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_CREATE_RMON_THRESHOLD_PARAM_1, (Object)annotatedException.getMessage());
            return true;
        }
        catch (DuplicateAlarm duplicateAlarm) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_CREATE_RMON_THRESHOLD_PARAM_1, (Object)"Duplicate RMON threshold.");
            return false;
        }
        catch (NoSuchStatsId noSuchStatsId) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_CREATE_RMON_THRESHOLD_PARAM_1, (Object)noSuchStatsId.getMessage());
            return false;
        }
    }

    private UComboBox createComboBox(String string) {
        return new UComboBox((Object[])this.attrMap.getAttributeArray(string));
    }

    public class RmonCardPortRenderer
    extends JLabel
    implements ListCellRenderer {
        public RmonCardPortRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            try {
                if (object instanceof String) {
                    this.setText((String)object);
                } else if (object instanceof PortModel) {
                    PortModel portModel = (PortModel)object;
                    EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                    this.setText(entityCellRenderer.getPortString(portModel, false));
                }
            }
            catch (Exception exception) {
                db.println("RmonCardPortRenderer caught Exception: " + exception);
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    class RmonCardRenderer
    extends JLabel
    implements ListCellRenderer {
        public RmonCardRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[] objectArray = (Object[])object;
            StringBuffer stringBuffer = new StringBuffer();
            if (objectArray != null) {
                stringBuffer.append(((String)objectArray[0]).toString());
            }
            this.setText(stringBuffer.toString());
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

