/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.SonetTopology.sSquelchTblEntry;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.INodeModel;
import cerent.cms.ui.shelf.SppRingPane;
import cerent.util.TDMTerminology;
import cerent.util.gui.UDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class BlsrSquelchTblDialog
extends UDialog
implements ActionListener {
    public static final String CLOSE = "Close";
    private JButton closeButton;
    private SquelchTableModel tableModel;
    private INodeModel node;
    private static String[] columnNames;

    public static BlsrSquelchTblDialog instance(SppRingPane sppRingPane, BlsrModel blsrModel) {
        INodeModel iNodeModel = blsrModel.getNodeModel();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        BlsrSquelchTblDialog.initColumnNames(tDMTerminology);
        String string = tDMTerminology.getRingTerms(1) + " Squelch Table: Ring Name ";
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)sppRingPane));
        return new BlsrSquelchTblDialog(frame, blsrModel, string);
    }

    private BlsrSquelchTblDialog(Frame frame, Object object, String string) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        JPanel jPanel2 = new JPanel();
        this.closeButton = new JButton(CLOSE);
        this.closeButton.addActionListener(this);
        jPanel2.add(this.closeButton);
        BlsrModel blsrModel = (BlsrModel)object;
        this.node = blsrModel.getNodeModel();
        this.setTitle(this.getTitle() + blsrModel.getProvision().ringName);
        this.tableModel = new SquelchTableModel(blsrModel);
        UScrollPane uScrollPane = new UScrollPane((Component)new UTable((TableModel)this.tableModel));
        jPanel.add((Component)uScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    public void dispose() {
        this.tableModel = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.closeButton) {
            this.dispose();
        }
    }

    private static void initColumnNames(TDMTerminology tDMTerminology) {
        columnNames = new String[5];
        BlsrSquelchTblDialog.columnNames[0] = tDMTerminology.getGeneralTerms(0) + " Number";
        BlsrSquelchTblDialog.columnNames[1] = "West-Source";
        BlsrSquelchTblDialog.columnNames[2] = "West-Dest";
        BlsrSquelchTblDialog.columnNames[3] = "East-Source";
        BlsrSquelchTblDialog.columnNames[4] = "East-Dest";
    }

    class SquelchTableModel
    extends AbstractTableModel {
        private BlsrModel model;
        private sSquelchTblEntry[] squelchTable = null;

        SquelchTableModel(BlsrModel blsrModel) {
            this.model = blsrModel;
            this.squelchTable = blsrModel != null ? blsrModel.getSquelchTbl() : new sSquelchTblEntry[0];
        }

        public String getColumnName(int n) {
            return columnNames[n];
        }

        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            if (BlsrSquelchTblDialog.this.node.getFramingType() == 0) {
                return this.squelchTable.length;
            }
            return this.squelchTable.length / 3;
        }

        public Object getValueAt(int n, int n2) {
            int n3 = n;
            n3 = BlsrSquelchTblDialog.this.node.getFramingType() == 1 ? n * 3 : n;
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return this.formatNodeId(this.squelchTable[n3].westStsSource);
                }
                case 2: {
                    return this.formatNodeId(this.squelchTable[n3].westStsDestination);
                }
                case 3: {
                    return this.formatNodeId(this.squelchTable[n3].eastStsSource);
                }
                case 4: {
                    return this.formatNodeId(this.squelchTable[n3].eastStsDestination);
                }
            }
            return null;
        }

        private Object formatNodeId(short s) {
            return s == 255 ? (Object)null : new Short(s);
        }
    }
}

