/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.Equipment.xProvisionError;
import cerent.cms.idl.OpticsTopology.eDwdmRingType;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PimModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.IOSConfigDialog;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.util.AnnotatedException;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IOSTelnetFrame;
import java.awt.Component;
import org.omg.CORBA.UNKNOWN;

public class CardBehavior {
    public static final String DELETE_CARD = "Delete Card";
    public static final String RESET_CARD = "Reset Card";
    public static final String HARD_RESET_CARD = "Hard-reset Card";
    public static final String SOFT_RESET_CARD = "Soft-reset Card";
    protected static final String OPEN_CARD = "Open Card";
    public static final String CMD_OPEN_IOS = "Open IOS Connection...";
    public static final String CMD_IOS_CONFIG = "IOS Startup Config...";
    protected AbstractOpticsLineModel[] opticsLineModels = null;
    private int[] supportedXcCardEqTypes;
    private eDwdmRingType ringtype;
    protected SDebug db;

    public CardBehavior(IPlatform iPlatform, SDebug sDebug) {
        this.supportedXcCardEqTypes = iPlatform.getSupportedXcCardEqTypes();
        this.db = sDebug;
    }

    protected boolean isCardResetAllowed(ModuleModel moduleModel, StringBuffer stringBuffer, eModuleOp eModuleOp2) {
        ProtectionGroupModel protectionGroupModel;
        if (moduleModel == null) {
            stringBuffer.append("Card unavailable.");
            return false;
        }
        boolean bl = true;
        String string = "Are you sure you want to reset this card?";
        if (eModuleOp2 == eModuleOp.HARD_RESET) {
            string = "Are you sure you want to hard-reset this card?";
        } else if (eModuleOp2 == eModuleOp.SOFT_RESET) {
            string = "Are you sure you want to soft-reset this card?";
        }
        eEqState eEqState2 = null;
        try {
            eEqState2 = moduleModel.getState();
        }
        catch (UNKNOWN uNKNOWN) {
            this.db.println("isCardResetAllowed: could not determine state");
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            this.db.println("isCardResetAllowed: could not determine state");
        }
        if (eEqState2 == eEqState.ACTIVE && moduleModel.isInProtectionGroup() && (protectionGroupModel = moduleModel.getProtectionGroupModel()) != null) {
            ModuleModel[] moduleModelArray;
            ModuleModel moduleModel2 = (ModuleModel)protectionGroupModel.getProtectModuleModel();
            if (moduleModel == moduleModel2 && (moduleModel2 = (ModuleModel)protectionGroupModel.getProtectedModuleModel()) == null) {
                moduleModelArray = (ModuleModel[])protectionGroupModel.getMainModuleModels();
                if (moduleModelArray.length == 1) {
                    moduleModel2 = moduleModelArray[0];
                } else {
                    string = "Protection group not ready: Traffic may be lost\n" + string;
                }
            }
            if (moduleModel2 != null) {
                moduleModelArray = null;
                try {
                    moduleModelArray = moduleModel2.getState();
                }
                catch (UNKNOWN uNKNOWN) {
                    this.db.println("isCardResetAllowed: could not determine state for sibling");
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    this.db.println("isCardResetAllowed: could not determine state for sibling");
                }
                if (moduleModelArray == eEqState.NOT_PRESENT) {
                    string = "Protection group incomplete: Traffic may be lost\n" + string;
                } else if (moduleModelArray != eEqState.STANDBY) {
                    if (moduleModel.getEqTypeEnum() == eEqType.XTC_CARD) {
                        bl = false;
                        string = "The other XTC is present but not in standby mode; cannot reset";
                    } else {
                        string = "Other card in protection group not ready: Traffic may be lost\n" + string;
                    }
                }
            }
        }
        stringBuffer.append(string);
        return bl;
    }

    protected Exception maybeAnnotateException(ModuleModel moduleModel, Exception throwable) {
        if (moduleModel.getEqTypeEnum() == eEqType.XTC_CARD) {
            throwable = new AnnotatedException("The standby XTC is not ready for this operation.\nPlease try again when initialization completes (up to 5 minutes)", (Exception)throwable);
        } else {
            String string = moduleModel.getEqTypeName();
            if (string != null && (string.startsWith("XC") || string.startsWith("CXC"))) {
                throwable = new AnnotatedException("This operation could not be performed because\nthe required standby " + string + " card was not detected or has an SWMTXMOD alarm raised.\n\n" + "Please verify that a standby " + string + " card is present or clear the alarm.\n", (Exception)throwable);
            }
        }
        return throwable;
    }

    public void addCard(final Component component, final EntityModel entityModel, final String string) {
        new Thread("Card Provisioner"){

            public void run() {
                try {
                    EntityTableModel entityTableModel = entityModel.getNodeModelDelegate().getEntityTableModel();
                    int n = entityModel.getEntityIndex();
                    eEqType eEqType2 = EntityModel.name2EqType((NodeModelDelegate)entityModel.getNodeModel(), string);
                    if (entityTableModel != null && eEqType2 != null) {
                        entityTableModel.provisionModule(n, eEqType2);
                    }
                }
                catch (xInUse xInUse2) {
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_CARD_SLOT_IN_USE);
                }
                catch (xProvisionError xProvisionError2) {
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_CARD_PROV_ERROR_PARAM_1, (Object)"add");
                }
                catch (Exception exception) {
                    SDebug cfr_ignored_0 = CardBehavior.this.db;
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_CARD_ADD);
                }
            }
        }.start();
    }

    public boolean deleteCard(Component component, EntityModel entityModel) {
        int n;
        boolean bl;
        if (this.isCrossConnectCard(entityModel.getEqType())) {
            bl = CerentDialog.yesNoDialog((Component)component, (String)"The cross-connect card can not be deleted unless no circuits use this node.\nOK to continue?", (String)"Deleting Card");
        } else {
            boolean bl2 = false;
            n = 0;
            if (entityModel.getEqTypeEnum() == eEqType.OPT_BST || entityModel.getEqTypeEnum() == eEqType.OPT_PRE || entityModel.getEqTypeEnum() == eEqType.OPT_BST_E) {
                n = this.isNotDwdmNetype((ModuleModel)entityModel) ? 1 : 0;
                bl2 = this.isPortIS((ModuleModel)entityModel);
                bl = n == 0 ? CerentDialog.yesNoDialog((Component)component, (String)"Are you sure?", (String)"Deleting Card") : (!bl2 ? CerentDialog.yesNoDialog((Component)component, (String)"Are you sure?", (String)"Deleting Card") : CerentDialog.yesNoDialog((Component)component, (String)"Selected operation will be traffic affecting Are you sure?", (String)"Deleting Card"));
            } else {
                if (entityModel.getEqTypeEnum() == eEqType.PPM_1_PORT) {
                    return this.deletePpm(component, entityModel);
                }
                bl = CerentDialog.yesNoDialog((Component)component, (String)"Are you sure?", (String)"Deleting Card");
            }
        }
        ModuleModel moduleModel = (ModuleModel)entityModel;
        n = entityModel.getNodeModel().getFramingType();
        boolean bl3 = FramingType.getFramingType((int)n).isSonet();
        if (bl) {
            try {
                bl = false;
                moduleModel.unprovision();
                bl = true;
            }
            catch (ResourceInUse resourceInUse) {
                StringBuffer stringBuffer = new StringBuffer();
                if (moduleModel.isSupportingBLSR()) {
                    if (bl3) {
                        stringBuffer.append("it is supporting the BLSR.");
                    } else {
                        stringBuffer.append("it is supporting the MS-SPRing.");
                    }
                } else if (moduleModel.isInProtectionGroup()) {
                    stringBuffer.append("it is part of a protection group.");
                } else if (moduleModel.isSupportingGCC()) {
                    stringBuffer.append("the GCC is in use.");
                } else if (moduleModel.isSupportingSDCC()) {
                    stringBuffer.append("the SDCC is in use.");
                } else if (moduleModel.isSupportingLDCC()) {
                    stringBuffer.append("the LDCC is in use.");
                } else if (moduleModel.isTimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (moduleModel.isEXT_1TimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (moduleModel.isEXT_2TimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (moduleModel.hasCircuits()) {
                    stringBuffer.append("one or more circuits transit it.");
                } else if (moduleModel.hasOhCircuits()) {
                    stringBuffer.append("one or more overhead circuits transit it.");
                } else if (moduleModel instanceof DwdmModuleModel) {
                    DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)moduleModel;
                    if (dwdmModuleModel.hasRegenPeer()) {
                        stringBuffer.append("it is part of a regeneration group.");
                    } else {
                        stringBuffer.append("it is in use.\n");
                        stringBuffer.append("This card cannot be deleted when \n");
                        stringBuffer.append("there is at least one client and \n");
                        stringBuffer.append("one trunk port which are IS.");
                    }
                } else if (moduleModel instanceof OpticsModuleModel) {
                    OpticsModuleModel opticsModuleModel = (OpticsModuleModel)moduleModel;
                    if (opticsModuleModel.getEqTypeEnum() == eEqType.OSC_CSM_CARD || opticsModuleModel.getEqTypeEnum() == eEqType.OSCM_CARD) {
                        if (opticsModuleModel.hasOSCMOC3UsedPorts()) {
                            stringBuffer.append("the OSC is in use.");
                        } else if (opticsModuleModel.hasDWDMPatchCord()) {
                            stringBuffer.append("one or more DWDM patchcords are still up.");
                        }
                    } else if (opticsModuleModel.hasDWDMPatchCord()) {
                        stringBuffer.append("one or more DWDM patchcords are still up.");
                    }
                } else {
                    stringBuffer.append("it is in use.");
                }
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_CARD_DELETE_PARAM_1, (Object)stringBuffer.toString());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)component, (EID)EMC.EID_FAIL_CARD_DELETE_PARAM_1, (Object)"provision error");
            }
        }
        return bl;
    }

    public void resetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.RESET);
    }

    public void hardResetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.HARD_RESET);
    }

    public void softResetCard(Component component, ModuleModel moduleModel) {
        this.doResetCard(component, moduleModel, eModuleOp.SOFT_RESET);
    }

    public void hardResetPim(Component component, PimModel pimModel) {
    }

    private void doResetCard(Component component, ModuleModel moduleModel, eModuleOp eModuleOp2) {
        block13: {
            if (eModuleOp2 != eModuleOp.RESET && eModuleOp2 != eModuleOp.SOFT_RESET && eModuleOp2 != eModuleOp.HARD_RESET) {
                if (this.db.on()) {
                    this.db.println("doResetCard failed moduleOp=" + eModuleOp2.value());
                }
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = this.isCardResetAllowed(moduleModel, stringBuffer, eModuleOp2);
            String string = "Resetting card";
            EID eID = EMC.EID_SOFT_RESET_CARD;
            if (eModuleOp2 == eModuleOp.SOFT_RESET) {
                string = "Soft-resetting card";
            } else if (eModuleOp2 == eModuleOp.HARD_RESET) {
                eID = EMC.EID_HARD_RESET_CARD;
                string = "Hard-resetting card";
            }
            if (bl) {
                if (CerentDialog.yesNoDialog((Component)component, (String)stringBuffer.toString(), (String)string)) {
                    try {
                        if (this.db.on()) {
                            this.db.println("resetCard(): card= " + moduleModel.toString() + " moduleOp= " + eModuleOp2.value());
                            this.db.println("resetCard(): msg= " + string);
                        }
                        moduleModel.doCommand(eModuleOp2);
                    }
                    catch (ProvisionError provisionError) {
                        Exception exception = this.maybeAnnotateException(moduleModel, (Exception)((Object)new ProvisionError("")));
                        if (exception instanceof AnnotatedException) {
                            ErrorMsg.displayDetailed(component, eID, exception.getMessage());
                            break block13;
                        }
                        ErrorMsg.displayError((Component)component, (EID)eID);
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                        ErrorMsg.displayError((Component)component, (EID)eID);
                    }
                }
            } else {
                ErrorMsg.displayDetailed(component, eID, stringBuffer.toString());
            }
        }
    }

    public boolean isCrossConnectCard(int n) {
        boolean bl = false;
        for (int i = 0; i < this.supportedXcCardEqTypes.length; ++i) {
            if (n != this.supportedXcCardEqTypes[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean supportsGenericResetCard(IPlatform iPlatform, int n) {
        if (iPlatform.is600() || iPlatform.is310cl()) {
            return false;
        }
        return n != 187;
    }

    public boolean isNotDwdmNetype(ModuleModel moduleModel) {
        if (this.opticsLineModels == null) {
            this.LoadLineModels(moduleModel);
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.opticsLineModels[0].getNodeModel();
        try {
            this.ringtype = nodeModelDelegate.getDwdmOpticalSetupModel().getDwdmRingType();
        }
        catch (Exception exception) {
            this.ringtype = eDwdmRingType.METRO_CORE;
        }
        return this.ringtype == eDwdmRingType.NOT_DWDM;
    }

    public boolean isPortIS(ModuleModel moduleModel) {
        boolean bl = false;
        if (this.opticsLineModels == null) {
            this.LoadLineModels(moduleModel);
        }
        try {
            for (int i = 0; i < this.opticsLineModels.length; ++i) {
                int n = this.opticsLineModels[i].getAdminState();
                if (n != 0) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void LoadLineModels(ModuleModel moduleModel) {
        OpticsPortModel[] opticsPortModelArray = moduleModel.getChildren().toArray(new OpticsPortModel[0]);
        this.opticsLineModels = new AbstractOpticsLineModel[opticsPortModelArray.length];
        for (int i = 0; i < this.opticsLineModels.length; ++i) {
            this.opticsLineModels[i] = opticsPortModelArray[i].getOpticsLineModel();
        }
    }

    protected boolean deletePpm(Component component, EntityModel entityModel) {
        PpmModel ppmModel = (PpmModel)entityModel;
        boolean bl = CerentDialog.yesNoDialog((Component)component, (String)("Are you sure you want to delete PPM " + PluggableHelper.getHierarchyNumString(ppmModel.getHierarchyNums(), '-') + "?"), (String)"Delete PPM");
        if (bl) {
            try {
                ppmModel.unprovision();
            }
            catch (Exception exception) {
                bl = false;
                IModuleModel iModuleModel = entityModel.getModuleModel();
                boolean bl2 = iModuleModel instanceof DwdmModuleModel;
                boolean bl3 = bl2 ? ((DwdmModuleModel)iModuleModel).supportTiming() : false;
                String string = "PPM cannot be deleted if:" + (bl2 ? "\n\t- It is in service " : "") + "\n\t- It is in a protection group " + "\n\t- It has a DCC/GCC in use " + (bl3 ? "\n\t- It is a timing source " : "") + (bl2 ? "" : "\n\t- It has circuits") + "\n\t- It has overhead circuits" + (bl2 ? "\n\t- It has a trunk port in service" : "") + "\n\t- It is an UNKNOWN PPM";
                ErrorMsg.displayDetailed(component, EMC.EID_FAIL_PPM_DELETE, string);
            }
        }
        return bl;
    }

    public void openIOS(IModuleModel iModuleModel) {
        IOSTelnetFrame iOSTelnetFrame = IOSTelnetFrame.instance((IModuleModel)iModuleModel);
        iOSTelnetFrame.pack();
        iOSTelnetFrame.setVisible(true);
    }

    public void openIOSConfig(Component component, IModuleModel iModuleModel) {
        IOSConfigDialog iOSConfigDialog = IOSConfigDialog.instance(component, iModuleModel);
        iOSConfigDialog.pack();
        iOSConfigDialog.setVisible(true);
    }
}

