/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CardPanel
extends JPanel
implements Observer {
    private Icon icon = null;
    private EntityModel entityM = null;
    private AbstractShelfLayout parent;
    private ModuleModel cardModel = null;
    private int eqType;
    private static final SDebug db = new SDebug((KDebug)AbstractShelfLayout.db, "CardPanel");

    public CardPanel(Icon icon, AbstractShelfLayout abstractShelfLayout) {
        this.parent = abstractShelfLayout;
        this.setIcon(icon);
        this.setToolTipText("ZZZ");
    }

    public void paintComponent(Graphics graphics) {
        if (this.icon != null) {
            try {
                this.icon.paintIcon(this, graphics, 0, 0);
            }
            catch (Exception exception) {}
        } else {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = this.getBounds();
            }
            graphics.setColor(Color.gray.brighter());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (icon instanceof CardGraphic) {
            CardGraphic cardGraphic = (CardGraphic)icon;
            this.setPreferredSize(cardGraphic.getDimension());
            this.setMinimumSize(cardGraphic.getDimension());
        }
    }

    public void setEntityM(EntityModel entityModel) {
        this.entityM = entityModel;
        this.registerForUpdates();
    }

    private void registerForUpdates() {
        if (this.entityM.getChildren().size() == 1) {
            this.cardModel = (ModuleModel)this.entityM.getChildren().get(0);
            this.cardModel.addObserver(this);
            this.eqType = this.cardModel.getEqType();
        } else {
            this.cardModel = null;
        }
        this.entityM.addObserver(this);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void dispose() {
        if (this.parent != null && this.parent.getSelectedCard() == this) {
            AbstractViewController.setActiveObject(null);
        }
        if (this.entityM != null) {
            this.entityM.deleteObserver(this);
            if (this.cardModel != null) {
                this.cardModel.deleteObserver(this);
                this.cardModel = null;
            }
            if (this.icon instanceof CardGraphic) {
                ((CardGraphic)this.icon).dispose();
                this.icon = null;
            }
        }
    }

    public void destroy() {
        this.dispose();
        this.entityM = null;
        this.parent = null;
    }

    public EntityModel getEntityModel() {
        return this.entityM;
    }

    public ModuleModel getModuleModel() {
        return this.cardModel;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.icon instanceof CardGraphic) {
            return ((CardGraphic)this.icon).getTooltipText(mouseEvent);
        }
        return null;
    }

    public void update(Observable observable, Object object) {
        if (this.entityM != null && this.entityM.getNodeModel().isInited()) {
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                if (n.equals(ModelUpdateType.ADDED) && observable == this.entityM || n.equals(ModelUpdateType.DELETED) && observable == this.cardModel) {
                    if (db.on()) {
                        db.println("Update Type is : " + object + "\n" + "sender is : " + observable.getClass().getName() + "\n" + "Number of children for entityM are " + this.entityM.getChildren().size());
                    }
                    SwingUtilities.invokeLater(new ReplaceCard());
                } else if (n.equals(ModelUpdateType.CHANGED) && observable == this.cardModel) {
                    if (this.cardModel.getEqType() != this.eqType) {
                        SwingUtilities.invokeLater(new ReplaceCard());
                    }
                } else if (n.equals(ModelUpdateType.DELETED) && observable == this.entityM) {
                    if (db.on()) {
                        db.println("slot entity deleted");
                    }
                    SwingUtilities.invokeLater(new RemoveSlot());
                }
            }
        } else if (db.on()) {
            db.println("update safely discarded (NMD not inited)");
        }
    }

    private class RemoveSlot
    implements Runnable {
        private RemoveSlot() {
        }

        public void run() {
            CardPanel.this.dispose();
            CardPanel.this.setIcon(null);
            CardPanel.this.entityM = null;
            CardPanel.this.repaint();
        }
    }

    private class ReplaceCard
    implements Runnable {
        private ReplaceCard() {
        }

        public void run() {
            block6: {
                try {
                    CardPanel.this.dispose();
                    if (CardPanel.this.entityM != null) {
                        IPlatform iPlatform = CardPanel.this.entityM.getNodeModelDelegate().getPlatform();
                        CardGraphic cardGraphic = iPlatform.createCard(CardPanel.this.entityM, CardPanel.this.parent);
                        CardPanel.this.setIcon(cardGraphic);
                        CardPanel.this.registerForUpdates();
                        ModuleModel moduleModel = null;
                        if (CardPanel.this.parent != null) {
                            CardPanel cardPanel = CardPanel.this.parent.getSelectedCard();
                            if (cardPanel != null && cardPanel.getEntityModel() == CardPanel.this.entityM && CardPanel.this.entityM.getChildren().size() > 0) {
                                moduleModel = (ModuleModel)CardPanel.this.entityM.getChildren().get(0);
                            }
                            if (moduleModel != null && CardTabbedViewFactory.isCardViewAvailable(moduleModel)) {
                                AbstractViewController.setActiveObject((Object)this);
                            }
                        }
                        CardPanel.this.parent.configSpecialModule();
                    }
                    CardPanel.this.repaint();
                }
                catch (Exception exception) {
                    if (!db.on()) break block6;
                    db.println("Error updating cardPanel: " + exception);
                    db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }
}

