/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.Attribute;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.SlotModel;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.MultiLineLabelUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class ChangeCardDialog
extends JDialog {
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JComboBox cbCards;
    private SlotModel slotModel;
    private ModuleModel module;
    private int slotNo;
    private static SDebug db = new SDebug("ChangeCardDialog");

    public ChangeCardDialog(Frame frame, ModuleModel moduleModel) {
        super(frame, "Change Card", true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChangeCardDialog.this.dispose();
            }
        });
        this.module = moduleModel;
        this.slotModel = (SlotModel)moduleModel.getAncestorOfEqType(21);
        this.slotNo = this.slotModel.getPositionInParent();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getDescPanel(), "North");
        container.add((Component)this.getComboPanel(), "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    private JPanel getDescPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        String string = "You are about to change the provisioning of Slot " + this.slotNo + ".\nThe slot is currently provisioned for " + this.module.getEqTypeName() + ".\n\nTo continue, select " + "a new card below:";
        JLabel jLabel = new JLabel(string);
        jLabel.setUI((LabelUI)new MultiLineLabelUI());
        jPanel.add(jLabel);
        return jPanel;
    }

    private JPanel getComboPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Change to: "));
        this.cbCards = new JComboBox(this.getAvailCards());
        jPanel.add(this.cbCards);
        return jPanel;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Attribute attribute = (Attribute)ChangeCardDialog.this.cbCards.getSelectedItem();
                if (db.on) {
                    db.println("The card selected is " + attribute.getKey() + " with eqType equals " + attribute.getIntValue());
                }
                try {
                    ChangeCardDialog.this.module.changeEqType(attribute.getIntValue());
                }
                catch (Exception exception) {
                    db;
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayDetailed((Component)ChangeCardDialog.this, EMC.EID_CARD_CHANGE, exception.getMessage());
                }
                ChangeCardDialog.this.dispose();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeCardDialog.this.dispose();
            }
        });
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private Vector getAvailCards() {
        Vector<Attribute> vector = new Vector<Attribute>();
        List list = this.slotModel.getListOfValidChangeType(eEqType.from_int(this.module.getEqType()));
        Iterator iterator = list.iterator();
        TDMTerminology tDMTerminology = this.slotModel.getNodeModel().getTDMTerminology();
        while (iterator.hasNext()) {
            eEqType eEqType2 = (eEqType)iterator.next();
            vector.add(new Attribute(EntityModel.eqType2Name(tDMTerminology, eEqType2), eEqType2.value()));
        }
        return vector;
    }

    public void dispose() {
        this.setLocation(this.getLocation().x + 1, this.getLocation().y + 1);
        super.dispose();
    }
}

