/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.OpticsTopology.sOscRingParams;
import cerent.cms.model.Attribute;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.DwdmRingModelDelegate;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.DwdmRingCreationDialog;
import cerent.cms.ui.shelf.SppOscPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class DwdmRingPane
extends AbstractPane
implements ActionListener,
ListSelectionListener,
TableModelListener,
Observer {
    private static final String BORDER_NAME = "DWDM Ring ID";
    public static final String RING_INDEX_STR = "Ring ID";
    public static final String W_DIR_STR = "West Direction";
    public static final String E_DIR_STR = "East Direction";
    public static final SDebug db = new SDebug("DwdmRingPane");
    private static final EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
    protected static final String CK_IMG_PATH = "/images/check_blue.gif";
    protected final ImageIcon CK_IMG = new ImageIcon(this.getClass().getResource("/images/check_blue.gif"));
    private final Comparator termComparator = this.createComparator();
    private JButton createPB;
    private JButton deletePB;
    private JButton editPB;
    private DwdmRingModelDelegate dataSource;
    private DwdmRingTableModel tableModel;
    private ArrayList tableDataList;
    private boolean inited = false;
    protected static final SDebug dbg = new SDebug((KDebug)SppOscPane.db, "DwdmRingPane");

    public DwdmRingPane(String string, DwdmRingModelDelegate dwdmRingModelDelegate) {
        super(string, dwdmRingModelDelegate, null);
        this.dataSource = dwdmRingModelDelegate;
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder(this.getBorderName()));
        this.setLayout(new BorderLayout());
        this.tableDataList = new ArrayList();
        this.tableModel = this.createTableModel();
        this.table = new UTable((TableModel)this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.prepareColumns();
        this.tableModel.addTableModelListener(this);
        this.add((Component)new UScrollPane((Component)this.table), "Center");
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.add(this.getButtonBar(), "South");
        this.setEditDeleteEnabled(false);
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        if (this.dataSource != null) {
            this.dataSource.addObserver(this);
        }
        this.inited = true;
    }

    public void dispose() {
        if (this.dataSource != null) {
            this.dataSource.deleteObserver(this);
        }
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    protected JPanel getButtonBar() {
        INodeModel iNodeModel = this.dataSource != null ? this.dataSource.getNodeModel() : null;
        this.createPB = new JButton("Create...");
        this.createPB.addActionListener(this);
        this.enableComponent(this.createPB, (IModel)iNodeModel);
        this.editPB = new JButton("Edit...");
        this.editPB.addActionListener(this);
        this.enableComponent(this.editPB, (IModel)iNodeModel);
        this.deletePB = new JButton("Delete...");
        this.deletePB.addActionListener(this);
        this.enableComponent(this.deletePB, (IModel)iNodeModel);
        JPanel jPanel = DwdmRingPane.createHorizontalPanel(null);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.OscTermPane);
        cSHelpButtonPane.addLeft(this.createPB);
        cSHelpButtonPane.addLeft(this.editPB);
        cSHelpButtonPane.addLeft(this.deletePB);
        jPanel.add(cSHelpButtonPane);
        return jPanel;
    }

    protected void clearTableSelection() {
        if (this.table != null && !this.tableDataList.isEmpty()) {
            this.table.removeRowSelectionInterval(0, this.tableDataList.size() - 1);
        }
    }

    protected void setEditDeleteEnabled(boolean bl) {
        INodeModel iNodeModel;
        INodeModel iNodeModel2 = iNodeModel = this.dataSource != null ? this.dataSource.getNodeModel() : null;
        if (!bl) {
            this.clearTableSelection();
        } else if (!this.isUserAuthorized()) {
            bl = false;
        }
        int n = this.table.getSelectedRowCount();
        this.deletePB.setEnabled(bl && n > 0);
        this.editPB.setEnabled(bl && n == 1);
        this.createPB.setEnabled(this.tableDataList.size() == 0 && DwdmRingPane.isUserAuthorized((IModel)iNodeModel, SecurityLevel.PROVISIONING));
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (observable instanceof DwdmRingModelDelegate) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                this.tableDataList.clear();
                this.refresh();
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                this.tableDataList.clear();
                this.refresh();
            } else {
                this.tableDataList.clear();
                this.refresh();
            }
        }
    }

    public void enteringPage() {
        if (!this.inited) {
            this.init();
        }
        this.refresh();
    }

    public void leavingPage() throws Exception {
    }

    public void refresh() {
        sOscRingParams[] sOscRingParamsArray = new sOscRingParams[]{};
        try {
            sOscRingParamsArray = this.dataSource.getAllParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sOscRingParamsArray != null && sOscRingParamsArray.length > 0) {
            Arrays.sort(sOscRingParamsArray, this.termComparator);
            this.tableDataList = new ArrayList<sOscRingParams>(Arrays.asList(sOscRingParamsArray));
        }
        this.refreshTable();
    }

    protected void refreshTable() {
        this.tableModel.fireTableDataChanged();
        int n = this.table.getSelectedRow();
        if (n < 0 || n > this.tableModel.getRowCount()) {
            this.setEditDeleteEnabled(false);
        }
    }

    protected JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            try {
                int n = this.tableModel.getRowCount();
                boolean bl = n == 0;
                int n2 = this.table.getSelectedRow();
                if (n2 < 0 || n2 >= n) {
                    bl = true;
                }
                this.setEditDeleteEnabled(bl);
            }
            catch (Exception exception) {
                this.setEditDeleteEnabled(false);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        this.setEditDeleteEnabled(!listSelectionModel.isSelectionEmpty());
    }

    private void localDelete(sOscRingParams sOscRingParams2) {
        this.tableDataList.remove(sOscRingParams2);
        this.refreshTable();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.createPB) {
            DwdmRingCreationDialog.instance(this, this.dataSource).show();
        } else if (object == this.editPB) {
            if (this.table.getSelectedRowCount() == 1) {
                int n = this.table.getSelectedRow();
                if (n >= 0 || n < this.tableDataList.size()) {
                    sOscRingParams sOscRingParams2 = (sOscRingParams)this.tableDataList.get(n);
                    DwdmRingCreationDialog.instance(this, this.dataSource, sOscRingParams2).show();
                }
            } else if (db.on()) {
                db.println("selected row count != 1 for edit!");
            }
        } else if (object == this.deletePB) {
            int n;
            int[] nArray = this.table.getSelectedRows();
            Object[] objectArray = new sOscRingParams[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                n = nArray[i];
                if (n >= this.tableDataList.size()) continue;
                objectArray[i] = (sOscRingParams)this.tableDataList.get(n);
            }
            if (objectArray.length > 0) {
                DwdmRingConfirmDialog dwdmRingConfirmDialog = new DwdmRingConfirmDialog(objectArray);
                dwdmRingConfirmDialog.show();
                if (dwdmRingConfirmDialog.isOk()) {
                    if (dwdmRingConfirmDialog.isChecked() && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"Apply this operation ?", (String)"Confirmation Dialog")) {
                        dwdmRingConfirmDialog.setChecked(false);
                    }
                    for (n = 0; n < objectArray.length; ++n) {
                        try {
                            this.localDelete((sOscRingParams)objectArray[n]);
                            this.dataSource.deleteRingId((sOscRingParams)objectArray[n]);
                            continue;
                        }
                        catch (FeatureUnsupported featureUnsupported) {
                            SDebug.printStackTrace((Throwable)featureUnsupported);
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_DELETING_RING);
                            continue;
                        }
                        catch (CannotPerform cannotPerform) {
                            SDebug.printStackTrace((Throwable)cannotPerform);
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_DELETING_RING);
                            continue;
                        }
                        catch (Exception exception) {
                            SDebug.printStackTrace((Throwable)exception);
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ERROR_DELETING_RING);
                        }
                    }
                }
            } else {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_RING_TERM_SEL);
            }
        }
    }

    private void prepareColumns() {
        this.table.getColumn(RING_INDEX_STR).setCellRenderer(new DwdmPaneRenderer());
        this.table.getColumn(W_DIR_STR).setCellRenderer((TableCellRenderer)((Object)new EntityCellRenderer("slot ")));
        this.table.getColumn(E_DIR_STR).setCellRenderer((TableCellRenderer)((Object)new EntityCellRenderer("slot ")));
    }

    private String getBorderName() {
        return BORDER_NAME;
    }

    private Comparator createComparator() {
        return new RingComparator();
    }

    private DwdmRingTableModel createTableModel() {
        return new DwdmRingTableModel();
    }

    private static class RingComparator
    implements Comparator {
        private RingComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            return ((sOscRingParams)object).ringName.compareTo(((sOscRingParams)object2).ringName);
        }
    }

    private class DwdmRingConfirmDialog
    extends GenericConfirmDialog {
        public DwdmRingConfirmDialog(Object[] objectArray) {
            super(objectArray);
        }

        public void show() {
            String string = "Really delete ";
            string = string + (this.termsToDelete.length == 1 ? "selected Ring ID?" : this.termsToDelete.length + " selected Ring ID?");
            Object[] objectArray = new Object[]{new JLabel(string)};
            JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 0, CerentDialog.QUESTION_ICON);
            JDialog jDialog = jOptionPane.createDialog((Component)((Object)DwdmRingPane.this), "Delete Ring ID");
            jDialog.show();
            if (jOptionPane.getValue() != null && (Integer)jOptionPane.getValue() == 0) {
                this.ok = true;
            }
        }
    }

    protected abstract class GenericConfirmDialog {
        protected boolean checked = false;
        protected boolean ok = false;
        protected Object[] termsToDelete;

        protected GenericConfirmDialog(Object[] objectArray) {
            this.termsToDelete = objectArray;
        }

        public boolean isOk() {
            return this.ok;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean bl) {
            this.checked = bl;
        }

        public abstract void show();
    }

    protected class DwdmPaneRenderer
    extends DefaultTableCellRenderer {
        final JLabel checkedLabel;
        final JLabel emptyLabel;

        protected DwdmPaneRenderer() {
            this.checkedLabel = new JLabel(DwdmRingPane.this.CK_IMG);
            this.emptyLabel = new JLabel("");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            sOscRingParams sOscRingParams2 = (sOscRingParams)object;
            switch (n2) {
                case 0: {
                    object = sOscRingParams2.ringName;
                    break;
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class DwdmRingTableModel
    extends AbstractTableModel {
        public static final int RING_INDEX = 0;
        public static final int W_DIR = 1;
        public static final int E_DIR = 2;
        public final String[] columnNames = new String[]{"Ring ID", "West Direction", "East Direction"};

        public int getRowCount() {
            return DwdmRingPane.this.tableDataList.size();
        }

        public Object getValueAt(int n, int n2) {
            sOscRingParams sOscRingParams2 = null;
            IEntityModel iEntityModel = null;
            if (DwdmRingPane.this.tableDataList != null && n < DwdmRingPane.this.tableDataList.size()) {
                if (n2 == 0) {
                    return DwdmRingPane.this.tableDataList.get(n);
                }
                if (n2 == 1) {
                    sOscRingParams2 = (sOscRingParams)DwdmRingPane.this.tableDataList.get(n);
                    try {
                        iEntityModel = DwdmRingPane.this.dataSource.getNodeModel().getEntityTable().getEntityModelByIndex(sOscRingParams2.westPort);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return iEntityModel;
                }
                if (n2 == 2) {
                    sOscRingParams2 = (sOscRingParams)DwdmRingPane.this.tableDataList.get(n);
                    try {
                        iEntityModel = DwdmRingPane.this.dataSource.getNodeModel().getEntityTable().getEntityModelByIndex(sOscRingParams2.eastPort);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return iEntityModel;
                }
                return null;
            }
            return null;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

