/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.AdminState;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.SdccTermConnectionModel;
import cerent.cms.ui.shelf.AbstractTermCreationDialog;
import cerent.cms.ui.shelf.LdccTermPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.TDMTerminology;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ListSelectionEvent;

public class LdccTermCreationDialog
extends AbstractTermCreationDialog {
    private static final String TITLE = "Create LDCC Terminations";
    private static final String TERMINATION_TYPE = "LDCC";

    public static LdccTermCreationDialog instance(LdccTermPane ldccTermPane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)ldccTermPane));
        AbstractTermConnectionModel abstractTermConnectionModel = (AbstractTermConnectionModel)ldccTermPane.getUiModel();
        return new LdccTermCreationDialog(frame, TITLE, TERMINATION_TYPE, abstractTermConnectionModel);
    }

    private LdccTermCreationDialog(Frame frame, String string, String string2, Object object) {
        super(frame, string, string2, object);
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        TDMTerminology tDMTerminology = this.connTable.getNodeModelDelegate().getTDMTerminology();
        String string = AdminState.getAdminTermIS(tDMTerminology);
        String string2 = AdminState.getAdminTermDSBLD(tDMTerminology);
        String string3 = AdminState.getAdminTermAINS(tDMTerminology);
        String string4 = AdminState.getAdminTermMT(tDMTerminology);
        this.asIs = new JRadioButton("Leave unchanged", true);
        this.toIS = new JRadioButton("Set to '" + string + "'");
        this.OOStoAINS = new JRadioButton("Set '" + string2 + "' to '" + string3 + "'");
        this.OOStoMT = new JRadioButton("Set '" + string2 + "' to '" + string4 + "'");
        this.asIs.setEnabled(false);
        this.toIS.setEnabled(false);
        this.OOStoAINS.setEnabled(false);
        this.OOStoMT.setEnabled(false);
        this.adminStateGroup = new ButtonGroup();
        this.adminStateGroup.add(this.asIs);
        this.adminStateGroup.add(this.toIS);
        this.adminStateGroup.add(this.OOStoAINS);
        this.adminStateGroup.add(this.OOStoMT);
        jPanel3.setLayout(new GridLayout(2, 0));
        jPanel3.add(this.asIs);
        jPanel3.add(this.toIS);
        jPanel3.add(this.OOStoAINS);
        jPanel3.add(this.OOStoMT);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Port Admin State"));
        jPanel2.setBorder(BorderFactory.createTitledBorder(TERMINATION_TYPE));
        this.donotAdvertiseOspfButton = new JCheckBox("Disable OSPF on Link");
        this.donotAdvertiseOspfButton.setEnabled(false);
        jPanel2.add(this.donotAdvertiseOspfButton);
        this.farEndForeign = new JCheckBox("Far End is Foreign");
        this.farEndForeign.setEnabled(false);
        jPanel2.add((Component)this.farEndForeign, "East");
        jPanel4.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel4.add(this.okButton);
        this.okButton.setEnabled(false);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel4.add(this.cancelButton);
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            boolean bl = this.termList.getSelectionModel().isSelectionEmpty();
            boolean bl2 = this.hasSDcc();
            if (bl2) {
                if (this.termList.getSelectedValues().length > 1) {
                    this.okButton.setEnabled(false);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_CREATING_LDCC_TERM);
                    return;
                }
                EntityModel entityModel = (EntityModel)this.termList.getSelectedValues()[0];
                this.donotAdvertiseOspfButton.setSelected(!this.isOspfEnabled(entityModel));
                this.farEndForeign.setSelected(this.isFarEndForeign(entityModel));
            } else {
                this.donotAdvertiseOspfButton.setSelected(false);
                this.farEndForeign.setSelected(false);
            }
            this.donotAdvertiseOspfButton.setEnabled(!bl && !bl2);
            this.farEndForeign.setEnabled(!bl && !bl2);
            this.asIs.setEnabled(!bl && !bl2);
            this.asIs.setSelected(true);
            this.toIS.setEnabled(!bl && !bl2);
            this.OOStoAINS.setEnabled(!bl && !bl2);
            this.OOStoMT.setEnabled(!bl && !bl2);
            this.okButton.setEnabled(!bl);
        }
    }

    protected void createTermination(IEntityModel iEntityModel) throws Exception {
        if (this.hasSdcc((EntityModel)iEntityModel)) {
            ErrorMsg.displayWarning((Component)((Object)this), (EID)EMC.WID_CREATING_LDCC_TERM);
        }
        this.connTable.createTermination(iEntityModel, new Object[]{new Boolean(!this.donotAdvertiseOspfButton.isSelected()), new Boolean(this.farEndForeign.isSelected())});
    }

    private boolean hasSDcc() {
        Object[] objectArray = this.termList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.hasSdcc((EntityModel)objectArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasSdcc(EntityModel entityModel) {
        return entityModel.getNodeModelDelegate().getDccTermConnectionModel().entityExistsInTerminations((IEntityModel)entityModel);
    }

    private boolean isOspfEnabled(EntityModel entityModel) {
        SdccTermConnectionModel sdccTermConnectionModel = (SdccTermConnectionModel)entityModel.getNodeModelDelegate().getDccTermConnectionModel();
        return ((OhTermModel)sdccTermConnectionModel.getTermModel(entityModel.getIndex())).isOspfEnable();
    }

    private boolean isFarEndForeign(EntityModel entityModel) {
        SdccTermConnectionModel sdccTermConnectionModel = (SdccTermConnectionModel)entityModel.getNodeModelDelegate().getDccTermConnectionModel();
        return ((OhTermModel)sdccTermConnectionModel.getTermModel(entityModel.getIndex())).isFarEndForeign();
    }
}

