/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IpConfig;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecureIpConfig;
import cerent.cms.ui.VitalStatsPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.text.DateFormat;
import java.util.Observable;
import java.util.Observer;

public class NodeVitalStatsPane
extends VitalStatsPane
implements Observer {
    private EventDispatcher dispatcher;
    private NodeModelDelegate nodeM;
    private String[] apcStatusLabels = new String[]{"APC state : Not Applicable - Network Type\n", "APC state : Enable\n", "APC state : Disable - Internal\n", "APC state : Disable - User\n"};
    private boolean isApcSite = false;
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
    private static final SDebug db = new SDebug("NodeVitalStatsPane");

    public NodeVitalStatsPane(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getElementAlarmStore());
        this.nodeM = nodeModelDelegate;
        this.isApcSite = nodeModelDelegate.getPlatform().supportsDWDM();
        if (this.isApcSite) {
            this.dispatcher = nodeModelDelegate.getDispatcher();
            if (this.dispatcher != null) {
                this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalSetup, 2, (Observer)this);
            }
        }
        this.updateTextArea(null);
        nodeModelDelegate.addObserver(this);
    }

    public void update(Observable observable, Object object) {
        this.updateTextArea(object);
    }

    private void updateTextArea(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        if (this.nodeM != null && object != ModelUpdateType.DELETED) {
            string = this.nodeM.getName();
            string2 = this.getNodeIpAddr();
            if (this.nodeM.getPlatform().isSecureModeSupported() && this.nodeM.isSecureMode()) {
                string3 = this.getSecureIpAddr();
            }
            string4 = this.nodeM.getUserName();
            string5 = ElementDefaults.securityLevelToString(this.nodeM.getSecurityLevel());
            try {
                string6 = this.nodeM.getSwVersion();
            }
            catch (Exception exception) {
                db.fine("Exception received when getting node sw version");
            }
            try {
                string7 = this.nodeM.getDefaultsManager().getNeDefaultsModel().getDefDescription();
            }
            catch (Exception exception) {
                db.fine("Exception received when getting default description: " + exception);
            }
            try {
                string9 = dateFormat.format(this.nodeM.getBootTime());
            }
            catch (Exception exception) {
                db.fine("Exception received when getting boot time: " + exception);
            }
            if (this.isApcSite && (this.nodeM.getNodeType() == 2 || this.nodeM.getNodeType() == 1)) {
                int n = this.nodeM.getDwdmOpticalSetupModel().getApcState();
                try {
                    string8 = this.apcStatusLabels[n];
                }
                catch (Exception exception) {
                    string8 = this.apcStatusLabels[0];
                }
            } else {
                string8 = "";
            }
        }
        if (string == null) {
            string = "unknown node";
        }
        if (string2 == null) {
            string2 = "unavailable";
        }
        if (string3 == null) {
            string3 = "unavailable";
        }
        if (string4 == null) {
            string4 = "unavailable";
        }
        if (string5 == null) {
            string5 = "unavailable";
        }
        if (string6 == null) {
            string6 = "unavailable";
        }
        if (string7 == null) {
            string7 = "unavailable";
        }
        if (string9 == null) {
            string9 = "unknown";
        }
        this.setTitle(string);
        if (this.nodeM.allowIpDisplayed(true)) {
            stringBuffer.append("IP Addr   : ").append(string2).append('\n');
        }
        if (this.nodeM.getPlatform().isSecureModeSupported() && this.nodeM.isSecureMode() && this.nodeM.allowIpDisplayed(false)) {
            stringBuffer.append("Backplane IP Addr   : ").append(string3).append('\n');
        }
        stringBuffer.append("Booted    : ").append(string9).append('\n').append("User      : ").append(string4).append('\n').append("Authority : ").append(string5).append('\n').append("SW Version: ").append(string6).append('\n').append("Defaults  : ").append(string7).append('\n').append(string8);
        this.setText(stringBuffer.toString());
    }

    private String getSecureIpAddr() {
        SecureIpConfig secureIpConfig;
        String string = null;
        if (this.nodeM != null && (secureIpConfig = (SecureIpConfig)this.nodeM.getSecureIpConfig()) != null) {
            string = InetUtil.makeDottedString(secureIpConfig.getIpAddress());
        }
        return string;
    }

    private String getNodeIpAddr() {
        String string = null;
        if (this.nodeM != null) {
            IpConfig ipConfig = (IpConfig)this.nodeM.getIpConfig();
            string = InetUtil.makeDottedString(ipConfig.getIpAddress());
        }
        return string;
    }

    public void dispose() {
        this.nodeM.deleteObserver(this);
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalSetup, 2, (Observer)this);
        }
        super.dispose();
    }
}

