/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.ui.shelf.AbstractOPG;
import cerent.cms.ui.shelf.CardGraphic;

public abstract class OpticalPortGraphic
extends AbstractOPG {
    private int size;

    public OpticalPortGraphic(CardGraphic cardGraphic, int n, int n2, PortModel portModel, int n3) {
        super(cardGraphic, n, n2, 1, 1, portModel);
        this.size = n3;
        if (!this.pci.positionPortsVertically()) {
            this.resize(n3 == 0 ? this.cardPainter.getPortWidth() : this.cardPainter.getSmallPortWidth(), this.cardPainter.getPortHeight());
        } else {
            this.resize(this.cardPainter.getPortWidth(), n3 == 0 ? this.cardPainter.getPortHeight() : this.cardPainter.getSmallPortHeight());
        }
    }

    public OpticalPortGraphic(CardGraphic cardGraphic, int n, int n2, int n3, int n4, PortModel portModel, int n5) {
        super(cardGraphic, n, n2, n3, n4, portModel);
        this.size = n5;
    }

    protected int getConnector1XOffset() {
        if (this.portModel.getParent() instanceof PpmModel && this.pci.is600()) {
            return this.x + this.cardPainter.getPortConn1X();
        }
        if (this.portModel.getParent() instanceof PpmModel) {
            return this.x + (this.pci.positionPortsVertically() ? this.width / 2 : this.width / 3);
        }
        if (this.size == 0 || this.pci.positionPortsVertically()) {
            return this.x + this.cardPainter.getPortConn1X();
        }
        return this.x + this.cardPainter.getSmallPortConn1X();
    }

    protected int getConnector2XOffset() {
        if (this.portModel.getParent() instanceof PpmModel && this.pci.is600()) {
            return this.x + this.cardPainter.getPortConn2X();
        }
        if (this.portModel.getParent() instanceof PpmModel) {
            return this.x + (this.pci.positionPortsVertically() ? this.width / 2 : this.width - this.width / 3 - 1);
        }
        if (this.size == 0 || this.pci.positionPortsVertically()) {
            return this.x + this.cardPainter.getPortConn2X();
        }
        return this.x + this.cardPainter.getSmallPortConn2X();
    }

    protected int getConnector1YOffset() {
        if (this.portModel.getParent() instanceof PpmModel && this.pci.is600()) {
            return this.y + this.cardPainter.getPortConn1Y();
        }
        if (this.portModel.getParent() instanceof PpmModel) {
            return this.y + (this.pci.positionPortsVertically() ? this.height / 3 : this.height / 2);
        }
        if (this.size == 0 || !this.pci.positionPortsVertically()) {
            return this.y + this.cardPainter.getPortConn1Y();
        }
        return this.y + this.cardPainter.getSmallPortConn1Y();
    }

    protected int getConnector2YOffset() {
        if (this.portModel.getParent() instanceof PpmModel && this.pci.is600()) {
            return this.y + this.cardPainter.getPortConn2Y();
        }
        if (this.portModel.getParent() instanceof PpmModel) {
            return this.y + (this.pci.positionPortsVertically() ? this.height - this.height / 3 - 1 : this.height / 2);
        }
        if (this.size == 0 || !this.pci.positionPortsVertically()) {
            return this.y + this.cardPainter.getPortConn2Y();
        }
        return this.y + this.cardPainter.getSmallPortConn2Y();
    }
}

