/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfAreaRange;
import cerent.cms.model.InvalidAreaId;
import cerent.cms.model.InvalidMask;
import cerent.cms.model.InvalidOspfRangeAddress;
import cerent.cms.model.MaxOspfAreaRanges;
import cerent.cms.ui.Pane;
import cerent.cms.ui.shelf.OspfAreaRangeEditPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OspfAreaRangeEditDialog
extends UDialog
implements ActionListener {
    public static final String TITLE = "Edit Selected Area Range";
    private JButton okButton;
    private JButton cancelButton;
    OspfAreaRangeEditPane attributesPane;

    public static OspfAreaRangeEditDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        IModel iModel = pane.getUiModel();
        OspfAreaRangeEditDialog ospfAreaRangeEditDialog = new OspfAreaRangeEditDialog(frame, iModel);
        ospfAreaRangeEditDialog.setSize(new Dimension(300, 200));
        return ospfAreaRangeEditDialog;
    }

    private OspfAreaRangeEditDialog(Frame frame, Object object) {
        super(frame, TITLE, true, object);
    }

    public void setAreaRange(IOspfAreaRange iOspfAreaRange) {
        this.attributesPane.setAreaRange(iOspfAreaRange);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        jPanel.add((Component)this.getAttributesPanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        this.attributesPane.setNodeModel((INodeModel)object);
    }

    public void dispose() {
        if (this.attributesPane != null) {
            this.attributesPane.destroy();
            this.attributesPane = null;
        }
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = "Error creating Area Range entry";
        if (object == this.okButton) {
            try {
                if (this.attributesPane.onValidate()) {
                    this.apply();
                    this.dispose();
                }
            }
            catch (MaxOspfAreaRanges maxOspfAreaRanges) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_MAX_AREA_RANGES);
            }
            catch (InvalidAreaId invalidAreaId) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_INVALID_AREA_ID);
            }
            catch (InvalidMask invalidMask) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_INVALID_MASK);
            }
            catch (InvalidOspfRangeAddress invalidOspfRangeAddress) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_INVALID_RANGE_ADDR);
            }
            catch (Exception exception) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_OSPF_AREA_ERROR_PARAM_1, (Object)exception.getMessage());
            }
        } else if (object == this.cancelButton) {
            this.dispose();
        } else {
            throw new IllegalArgumentException("actionPerformed: unexpected source " + object);
        }
    }

    protected void apply() throws Exception {
        this.attributesPane.setDirty();
        this.attributesPane.apply();
    }

    private JPanel getAttributesPanel() {
        this.attributesPane = new OspfAreaRangeEditPane("OspfAreaRangeEditPane");
        return this.attributesPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = this.makeActionButton("OK");
        jPanel.add(this.okButton);
        this.cancelButton = this.makeActionButton("Cancel");
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        return jButton;
    }
}

